/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pdbfinder.pdb;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class PdbBlock {
    private String iBlock;
    private int iStartProtein;
    private int iEndProtein;
    private int iStartBlock;
    private int iEndBlock;
    private Integer[] iSelectedPositions;
    private boolean iSelection = false;
    private String iUrl;

    public PdbBlock(String aBlock, int aStart_protein, int aEnd_protein, int aStart_block, int aEnd_block) {
        this.iBlock = aBlock;
        this.iStartProtein = aStart_protein;
        this.iEndProtein = aEnd_protein;
        this.iStartBlock = aStart_block;
        this.iEndBlock = aEnd_block;
    }

    public String getBlock() {
        return this.iBlock;
    }

    public void setBlock(String aBlock) {
        this.iBlock = aBlock;
    }

    public int getStartProtein() {
        return this.iStartProtein;
    }

    public void setStartProtein(int aStartProtein) {
        this.iStartProtein = aStartProtein;
    }

    public int getEndProtein() {
        return this.iEndProtein;
    }

    public void setEndProtein(int aEndProtein) {
        this.iEndProtein = aEndProtein;
    }

    public int getStartBlock() {
        return this.iStartBlock;
    }

    public void setStartBlock(int aStartBlock) {
        this.iStartBlock = aStartBlock;
    }

    public int getEndBlock() {
        return this.iEndBlock;
    }

    public void setEndBlock(int aEndBlock) {
        this.iEndBlock = aEndBlock;
    }

    public int getDifference() {
        int diff = this.iStartProtein - this.iStartBlock;
        return diff;
    }

    public boolean getSelection() {
        return this.iSelection;
    }

    public Integer[] getSelectedPositions() {
        return this.iSelectedPositions;
    }

    public void setSelectedPositions(Integer[] aSelectedPositions) {
        this.iSelectedPositions = aSelectedPositions;
        this.iSelection = true;
    }

    public String getBlockSequence(String aPdbAccession) {
        String lUrl = "http://www.rcsb.org/pdb/rest/describePDB?structureId=" + aPdbAccession;
        return this.readUrl(lUrl, aPdbAccession);
    }

    public String readUrl(String aUrl, String aPdbAccession) {
        this.iUrl = aUrl;
        String lSequence = null;
        try {
            int i;
            URL myURL = new URL(aUrl);
            StringBuilder input = new StringBuilder();
            HttpURLConnection c = (HttpURLConnection)myURL.openConnection();
            BufferedInputStream in = new BufferedInputStream(c.getInputStream());
            InputStreamReader r = new InputStreamReader(in);
            while ((i = ((Reader)r).read()) != -1) {
                input.append((char)i);
            }
            ((Reader)r).close();
            in.close();
            lSequence = this.readFasta(input.toString(), aPdbAccession);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            System.out.println("Connect exception for url " + this.iUrl);
        }
        catch (IOException e) {
            System.out.println("I/O exception for url " + this.iUrl);
        }
        return lSequence;
    }

    public String readFasta(String lFasta, String aPdbAccession) {
        String[] lLines = lFasta.split("\n");
        boolean lSequenceNeeded = false;
        StringBuilder lSequence = new StringBuilder();
        for (String lLine : lLines) {
            if (lLine.startsWith(">")) {
                if (lLine.contains(aPdbAccession + ":" + this.iBlock + "|")) {
                    lSequenceNeeded = true;
                    continue;
                }
                lSequenceNeeded = false;
                continue;
            }
            if (!lSequenceNeeded) continue;
            lSequence.append(lLine);
        }
        return lSequence.toString();
    }
}

