/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.psm_scoring.PsmScore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PsmScoringPreferences
implements Serializable {
    static final long serialVersionUID = 4997457408322410176L;
    private HashMap<Integer, HashSet<Integer>> spectrumMatchingScores = null;
    private HashSet<Integer> defaultScores;
    private Integer minDecoysInBin = 10;

    public PsmScoringPreferences() {
        this.setDefaultScores();
    }

    public void addScore(Integer advocateId, Integer scoreId) {
        HashSet<Integer> algorithmScores;
        if (this.spectrumMatchingScores == null) {
            this.spectrumMatchingScores = new HashMap();
        }
        if ((algorithmScores = this.spectrumMatchingScores.get(advocateId)) == null) {
            algorithmScores = new HashSet(1);
            this.spectrumMatchingScores.put(advocateId, algorithmScores);
        }
        algorithmScores.add(scoreId);
    }

    public void clearScores(Integer advocateId) {
        if (this.spectrumMatchingScores != null) {
            this.spectrumMatchingScores.remove(advocateId);
        }
    }

    public void clearAllScores() {
        this.spectrumMatchingScores.clear();
    }

    public HashSet<Integer> getScoreForAlgorithm(Integer advocateId) {
        if (this.spectrumMatchingScores == null) {
            return null;
        }
        return this.spectrumMatchingScores.get(advocateId);
    }

    public boolean isScoringNeeded(int advocate) {
        HashSet<Integer> scores;
        boolean scoreSet = false;
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty() && (scores = this.spectrumMatchingScores.get(advocate)) != null && !scores.isEmpty()) {
            scoreSet = true;
            if (scores.size() > 1) {
                return true;
            }
            for (int scoreIndex : scores) {
                if (scoreIndex == PsmScore.native_score.index) continue;
                return true;
            }
        }
        if (!scoreSet && this.defaultScores != null && !this.defaultScores.isEmpty()) {
            if (this.defaultScores.size() > 1) {
                return true;
            }
            for (int scoreIndex : this.defaultScores) {
                if (scoreIndex == PsmScore.native_score.index) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Integer> getAdvocates() {
        if (this.spectrumMatchingScores == null) {
            return new HashSet<Integer>(0);
        }
        return this.spectrumMatchingScores.keySet();
    }

    public boolean isScoringNeeded(ArrayList<Integer> advocates) {
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty()) {
            for (Integer advocate : advocates) {
                if (!this.isScoringNeeded(advocate)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTargetDecoyNeededForPsmScoring(ArrayList<Integer> advocates) {
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty()) {
            for (Integer advocate : advocates) {
                HashSet<Integer> scores = this.spectrumMatchingScores.get(advocate);
                if (scores == null || scores.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        for (Integer advocateIndex : this.getAdvocates()) {
            Advocate advocate = Advocate.getAdvocate(advocateIndex);
            output.append(advocate.getName()).append(": ");
            boolean first = true;
            for (Integer scoreIndex : this.getScoreForAlgorithm(advocateIndex)) {
                if (first) {
                    first = false;
                } else {
                    output.append(", ");
                }
                PsmScore score = PsmScore.getScore(scoreIndex);
                output.append(score.name);
            }
            output.append(".").append(newLine);
        }
        output.append("Default: ");
        boolean first = true;
        for (Integer scoreIndex : this.getDefaultScores()) {
            if (first) {
                first = false;
            } else {
                output.append(", ");
            }
            PsmScore score = PsmScore.getScore(scoreIndex);
            output.append(score.name);
        }
        output.append(".").append(newLine);
        return output.toString();
    }

    public boolean equals(PsmScoringPreferences otherPsmScoringPreferences) {
        HashSet<Integer> otherAdvocates;
        if (otherPsmScoringPreferences == null) {
            return false;
        }
        if (!Util.sameSets(this.defaultScores, otherPsmScoringPreferences.getDefaultScores())) {
            return false;
        }
        HashSet<Integer> thisAdvocates = new HashSet<Integer>(this.getAdvocates());
        if (!Util.sameSets(thisAdvocates, otherAdvocates = new HashSet<Integer>(otherPsmScoringPreferences.getAdvocates()))) {
            return false;
        }
        for (Integer advocate : thisAdvocates) {
            HashSet<Integer> otherScores;
            HashSet<Integer> thisScores = this.getScoreForAlgorithm(advocate);
            if (Util.sameSets(thisScores, otherScores = otherPsmScoringPreferences.getScoreForAlgorithm(advocate))) continue;
            return false;
        }
        return true;
    }

    public HashSet<Integer> getDefaultScores() {
        if (this.defaultScores == null) {
            this.setDefaultScores();
        }
        return this.defaultScores;
    }

    private void setDefaultScores() {
        this.defaultScores = new HashSet(1);
        this.defaultScores.add(PsmScore.native_score.index);
        if (this.spectrumMatchingScores == null) {
            this.spectrumMatchingScores = new HashMap(3);
            HashSet<Integer> scores = new HashSet<Integer>(3);
            scores.add(PsmScore.hyperScore.index);
            this.spectrumMatchingScores.put(Advocate.direcTag.getIndex(), scores);
            this.spectrumMatchingScores.put(Advocate.pepnovo.getIndex(), new HashSet(scores));
            this.spectrumMatchingScores.put(Advocate.pNovo.getIndex(), new HashSet(scores));
        }
    }

    public Integer getDecoysInFirstBin() {
        if (this.minDecoysInBin == null) {
            this.minDecoysInBin = 10;
        }
        return this.minDecoysInBin;
    }

    public void setDecoysInFirstBin(Integer decoysInFirstBin) {
        this.minDecoysInBin = decoysInFirstBin;
    }
}

