/*
 * Decompiled with CFR 0.152.
 */
package jwave;

import jwave.datatypes.natives.Complex;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;
import jwave.transforms.wavelets.Wavelet;

public final class Transform {
    protected final BasicTransform _basicTransform;

    public Transform(BasicTransform transform) {
        this._basicTransform = transform;
        try {
            if (this._basicTransform == null) {
                throw new JWaveFailure("given object is null!");
            }
            if (!(this._basicTransform instanceof BasicTransform)) {
                throw new JWaveFailure("given object is not of type BasicTransform");
            }
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    public final double[] forward(double[] arrTime) {
        double[] arrHilb = null;
        try {
            arrHilb = this._basicTransform.forward(arrTime);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrHilb;
    }

    public final double[] reverse(double[] arrHilb) {
        double[] arrTime = null;
        try {
            arrTime = this._basicTransform.reverse(arrHilb);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public final double[] forward(double[] arrTime, int level) {
        double[] arrHilb = null;
        try {
            arrHilb = this._basicTransform.forward(arrTime, level);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrHilb;
    }

    public final double[] reverse(double[] arrHilb, int level) {
        double[] arrTime = null;
        try {
            arrTime = this._basicTransform.reverse(arrHilb, level);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public final Complex[] forward(Complex[] arrTime) {
        Complex[] arrFreq = null;
        try {
            arrFreq = this._basicTransform.forward(arrTime);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrFreq;
    }

    public final Complex[] reverse(Complex[] arrFreq) {
        Complex[] arrTime = null;
        try {
            arrTime = this._basicTransform.reverse(arrFreq);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public final double[][] forward(double[][] matrixTime) {
        double[][] matrixHilb = null;
        try {
            matrixHilb = this._basicTransform.forward(matrixTime);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return matrixHilb;
    }

    public final double[][] reverse(double[][] matrixHilb) {
        double[][] matrixTime = null;
        try {
            matrixTime = this._basicTransform.reverse(matrixHilb);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return matrixTime;
    }

    public final double[][] forward(double[][] matrixTime, int levelM, int levelN) {
        double[][] matrixHilb = null;
        try {
            matrixHilb = this._basicTransform.forward(matrixTime, levelM, levelN);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return matrixHilb;
    }

    public final double[][] reverse(double[][] matrixHilb, int levelM, int levelN) {
        double[][] matrixTime = null;
        try {
            matrixTime = this._basicTransform.reverse(matrixHilb, levelM, levelN);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return matrixTime;
    }

    public final double[][][] forward(double[][][] spaceTime) {
        double[][][] spaceHilb = null;
        try {
            spaceHilb = this._basicTransform.forward(spaceTime);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return spaceHilb;
    }

    public final double[][][] reverse(double[][][] spaceHilb) {
        double[][][] spaceTime = null;
        try {
            spaceTime = this._basicTransform.reverse(spaceHilb);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return spaceTime;
    }

    public final double[][][] forward(double[][][] spaceTime, int levelP, int levelQ, int levelR) {
        double[][][] spaceHilb = null;
        try {
            spaceHilb = this._basicTransform.forward(spaceTime, levelP, levelQ, levelR);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return spaceHilb;
    }

    public final double[][][] reverse(double[][][] spaceHilb, int levelP, int levelQ, int levelR) {
        double[][][] spaceTime = null;
        try {
            spaceTime = this._basicTransform.reverse(spaceHilb, levelP, levelQ, levelR);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return spaceTime;
    }

    public final double[][] decompose(double[] arrTime) {
        double[][] matDeComp = null;
        try {
            matDeComp = this._basicTransform.decompose(arrTime);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return matDeComp;
    }

    public final double[] recompose(double[][] matDeComp) {
        double[] arrTime = null;
        try {
            arrTime = this._basicTransform.recompose(matDeComp);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public final double[] recompose(double[][] matDeComp, int level) {
        double[] arrTime = null;
        try {
            arrTime = this._basicTransform.recompose(matDeComp, level);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public final BasicTransform getBasicTransform() {
        BasicTransform basicTransform = null;
        try {
            if (this._basicTransform == null) {
                throw new JWaveFailure("Transform - BasicTransform object is null!");
            }
            if (!(this._basicTransform instanceof BasicTransform)) {
                throw new JWaveFailure("Transform - getBasicTransform - member is not of type BasicTransform!");
            }
            basicTransform = this._basicTransform;
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return basicTransform;
    }

    public final Wavelet getWavelet() {
        Wavelet wavelet = null;
        BasicTransform basicTransform = null;
        try {
            basicTransform = this.getBasicTransform();
            wavelet = basicTransform.getWavelet();
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return wavelet;
    }
}

