/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.spaces;

import jwave.datatypes.Super;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.blocks.BlockFull;
import jwave.datatypes.spaces.Space;
import jwave.exceptions.JWaveException;

public class SpaceFull
extends Space {
    protected Block[] _arrBlocks = null;

    public SpaceFull() {
    }

    public SpaceFull(Space space) {
        super(space);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    for (int k = 0; k < this._noOfLvls; ++k) {
                        this.set(i, j, k, space.get(i, j, k));
                    }
                }
            }
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    public SpaceFull(int noOfRows, int noOfCols, int noOfLvls) {
        super(noOfRows, noOfCols, noOfLvls);
    }

    public SpaceFull(int offSetRow, int offSetCol, int offSetLvl, int noOfRows, int noOfCols, int noOfLvls) {
        super(offSetRow, offSetCol, offSetLvl, noOfRows, noOfCols, noOfLvls);
    }

    @Override
    public Space copy() {
        return new SpaceFull(this);
    }

    @Override
    public boolean isAllocated() {
        boolean isAllocated = true;
        if (this._arrBlocks == null) {
            isAllocated = false;
        }
        return isAllocated;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._arrBlocks = new Block[this._noOfLvls];
            for (int k = 0; k < this._noOfLvls; ++k) {
                BlockFull block = new BlockFull(this._offSetRow, this._offSetCol, this._noOfRows, this._noOfCols);
                ((Super)block).alloc();
                this._arrBlocks[k] = block;
            }
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._arrBlocks != null) {
            for (int k = 0; k < this._noOfLvls; ++k) {
                if (this._arrBlocks[k] == null) continue;
                Block block = this._arrBlocks[k];
                block.erase();
                this._arrBlocks[k] = null;
            }
            this._arrBlocks = null;
        }
    }

    @Override
    public double get(int i, int j, int k) throws JWaveException {
        this.checkMemory();
        this.check(i, j, k);
        Block block = this._arrBlocks[k];
        double value = block.get(i, j);
        return value;
    }

    @Override
    public void set(int i, int j, int k, double value) throws JWaveException {
        this.checkMemory();
        this.check(i, j, k);
        Block block = this._arrBlocks[k];
        block.set(i, j, value);
    }
}

