/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets;

import java.util.Arrays;

public abstract class Wavelet {
    protected String _name = null;
    protected int _motherWavelength = 0;
    protected int _transformWavelength = 0;
    protected double[] _scalingDeCom = null;
    protected double[] _waveletDeCom = null;
    protected double[] _scalingReCon = null;
    protected double[] _waveletReCon = null;

    protected void _buildOrthonormalSpace() {
        int i;
        this._waveletDeCom = new double[this._motherWavelength];
        for (i = 0; i < this._motherWavelength; ++i) {
            this._waveletDeCom[i] = i % 2 == 0 ? this._scalingDeCom[this._motherWavelength - 1 - i] : -this._scalingDeCom[this._motherWavelength - 1 - i];
        }
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (i = 0; i < this._motherWavelength; ++i) {
            this._scalingReCon[i] = this._scalingDeCom[i];
            this._waveletReCon[i] = this._waveletDeCom[i];
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this.getName();
    }

    public int getMotherWavelength() {
        return this._motherWavelength;
    }

    public int getTransformWavelength() {
        return this._transformWavelength;
    }

    public final double[] getScalingDeComposition() {
        return Arrays.copyOf(this._scalingDeCom, this._scalingDeCom.length);
    }

    public final double[] getWaveletDeComposition() {
        return Arrays.copyOf(this._waveletDeCom, this._waveletDeCom.length);
    }

    public final double[] getScalingReConstruction() {
        return Arrays.copyOf(this._scalingReCon, this._scalingReCon.length);
    }

    public final double[] getWaveletReConstruction() {
        return Arrays.copyOf(this._waveletReCon, this._waveletReCon.length);
    }

    public double[] forward(double[] arrTime, int arrTimeLength) {
        double[] arrHilb = new double[arrTimeLength];
        int h = arrHilb.length >> 1;
        for (int i = 0; i < h; ++i) {
            arrHilb[i + h] = 0.0;
            arrHilb[i] = 0.0;
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = (i << 1) + j; k >= arrHilb.length; k -= arrHilb.length) {
                }
                int n = i;
                arrHilb[n] = arrHilb[n] + arrTime[k] * this._scalingDeCom[j];
                int n2 = i + h;
                arrHilb[n2] = arrHilb[n2] + arrTime[k] * this._waveletDeCom[j];
            }
        }
        return arrHilb;
    }

    public double[] reverse(double[] arrHilb, int arrHilbLength) {
        double[] arrTime = new double[arrHilbLength];
        for (int i = 0; i < arrTime.length; ++i) {
            arrTime[i] = 0.0;
        }
        int h = arrTime.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = (i << 1) + j; k >= arrTime.length; k -= arrTime.length) {
                }
                int n = k;
                arrTime[n] = arrTime[n] + (arrHilb[i] * this._scalingReCon[j] + arrHilb[i + h] * this._waveletReCon[j]);
            }
        }
        return arrTime;
    }
}

