/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.ArrayC128;
import org.ojalgo.array.ArrayH256;
import org.ojalgo.array.ArrayQ128;
import org.ojalgo.array.ArrayR032;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.ArrayR128;
import org.ojalgo.array.ArrayR256;
import org.ojalgo.array.ArrayZ008;
import org.ojalgo.array.ArrayZ016;
import org.ojalgo.array.ArrayZ032;
import org.ojalgo.array.ArrayZ064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BufferArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;
import org.ojalgo.tensor.TensorFactory2D;
import org.ojalgo.type.math.MathType;

public final class Array2D<N extends Comparable<N>>
implements Access2D.Visitable<N>,
Access2D.Aggregatable<N>,
Access2D.Sliceable<N>,
Structure2D.ReducibleTo1D<Array1D<N>>,
Access2D.Collectable<N, Mutate2D>,
Mutate2D.ModifiableReceiver<N>,
Mutate2D.Mixable<N>,
Structure2D.Reshapable {
    public static final Factory<ComplexNumber> C128 = Array2D.factory(ArrayC128.FACTORY);
    public static final Factory<Quaternion> H256 = Array2D.factory(ArrayH256.FACTORY);
    public static final Factory<RationalNumber> Q128 = Array2D.factory(ArrayQ128.FACTORY);
    public static final Factory<Double> R032 = Array2D.factory(ArrayR032.FACTORY);
    public static final Factory<Double> R064 = Array2D.factory(ArrayR064.FACTORY);
    public static final Factory<Quadruple> R128 = Array2D.factory(ArrayR128.FACTORY);
    public static final Factory<BigDecimal> R256 = Array2D.factory(ArrayR256.FACTORY);
    public static final Factory<Double> Z008 = Array2D.factory(ArrayZ008.FACTORY);
    public static final Factory<Double> Z016 = Array2D.factory(ArrayZ016.FACTORY);
    public static final Factory<Double> Z032 = Array2D.factory(ArrayZ032.FACTORY);
    public static final Factory<Double> Z064 = Array2D.factory(ArrayZ064.FACTORY);
    @Deprecated
    public static final Factory<BigDecimal> BIG = R256;
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    @Deprecated
    public static final Factory<Double> DIRECT32 = Array2D.factory(BufferArray.DIRECT32);
    @Deprecated
    public static final Factory<Double> DIRECT64 = Array2D.factory(BufferArray.DIRECT64);
    @Deprecated
    public static final Factory<Double> PRIMITIVE32 = R032;
    @Deprecated
    public static final Factory<Double> PRIMITIVE64 = R064;
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;
    private final long myColumnsCount;
    private final BasicArray<N> myDelegate;
    private final long myRowsCount;

    public static <N extends Comparable<N>> Factory<N> factory(DenseArray.Factory<N> denseArray) {
        return new Factory<N>(denseArray);
    }

    Array2D(BasicArray<N> delegate, long structure) {
        this.myDelegate = delegate;
        this.myRowsCount = structure;
        this.myColumnsCount = structure == 0L ? 0L : delegate.count() / structure;
    }

    @Override
    public void add(long index, byte addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, double addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, float addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, int addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, long addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long row, long col, byte addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, Comparable<?> addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, float addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, int addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, long addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, short addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long index, short addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public N aggregateColumn(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitColumn(row, col, visitor);
        return (N)((Comparable)visitor.get());
    }

    @Override
    public N aggregateDiagonal(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitDiagonal(row, col, visitor);
        return (N)((Comparable)visitor.get());
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRange(first, limit, visitor);
        return (N)((Comparable)visitor.get());
    }

    @Override
    public N aggregateRow(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRow(row, col, visitor);
        return (N)((Comparable)visitor.get());
    }

    @Override
    public byte byteValue(long index) {
        return this.myDelegate.byteValue(index);
    }

    @Override
    public byte byteValue(long row, long col) {
        return this.myDelegate.byteValue(Structure2D.index(this.myRowsCount, row, col));
    }

    @Override
    public long count() {
        return this.myDelegate.count();
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(index);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myDelegate.doubleValue(Structure2D.index(this.myRowsCount, row, col));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Array2D)) {
            return false;
        }
        Array2D other = (Array2D)obj;
        if (this.myRowsCount != other.myRowsCount || this.myColumnsCount != other.myColumnsCount) {
            return false;
        }
        return !(this.myDelegate == null ? other.myDelegate != null : !this.myDelegate.equals(other.myDelegate));
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myDelegate.exchange(colA * this.myRowsCount, colB * this.myRowsCount, 1L, this.myRowsCount);
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myDelegate.exchange(rowA, rowB, this.myRowsCount, this.myColumnsCount);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(0L, this.count(), 1L, value);
    }

    @Override
    public void fillAll(NullaryFunction<?> supplier) {
        this.myDelegate.fill(0L, this.count(), 1L, supplier);
    }

    @Override
    public void fillColumn(long row, long col, Access1D<N> values) {
        long offset = Structure2D.index(this.myRowsCount, row, col);
        long limit = Math.min(this.countRows() - row, values.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                this.set(offset + i, values.doubleValue(i));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(offset + i, values.get(i));
            }
        }
    }

    @Override
    public void fillColumn(long row, long col, N value) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, N value) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(index, values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(Structure2D.index(this.myRowsCount, row, col), values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, N value) {
        this.myDelegate.fillOne(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        this.myDelegate.fillOne(Structure2D.index(this.myRowsCount, row, col), supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myDelegate.fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<?> supplier) {
        this.myDelegate.fillOne(index, supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.myDelegate.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<?> supplier) {
        this.myDelegate.fill(first, limit, 1L, supplier);
    }

    @Override
    public void fillRow(long row, long col, Access1D<N> values) {
        long offset = Structure2D.index(this.myRowsCount, row, col);
        long limit = Math.min(this.countColumns() - col, values.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                this.set(offset + i * this.myRowsCount, values.doubleValue(i));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(offset + i * this.myRowsCount, values.get(i));
            }
        }
    }

    @Override
    public void fillRow(long row, long col, N value) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<?> supplier) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, supplier);
    }

    @Override
    public Array1D<N> flatten() {
        return this.myDelegate.wrapInArray1D();
    }

    @Override
    public float floatValue(long index) {
        return this.myDelegate.floatValue(index);
    }

    @Override
    public float floatValue(long row, long col) {
        return this.myDelegate.floatValue(Structure2D.index(this.myRowsCount, row, col));
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(index);
    }

    @Override
    public N get(long row, long col) {
        return this.myDelegate.get(Structure2D.index(this.myRowsCount, row, col));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (int)(this.myColumnsCount ^ this.myColumnsCount >>> 32);
        result = prime * result + (this.myDelegate == null ? 0 : this.myDelegate.hashCode());
        return prime * result + (int)(this.myRowsCount ^ this.myRowsCount >>> 32);
    }

    @Override
    public long indexOfLargest() {
        return this.myDelegate.indexOfLargest();
    }

    @Override
    public int intValue(long index) {
        return this.myDelegate.intValue(index);
    }

    @Override
    public int intValue(long row, long col) {
        return this.myDelegate.intValue(Structure2D.index(this.myRowsCount, row, col));
    }

    @Override
    public long longValue(long index) {
        return this.myDelegate.longValue(index);
    }

    @Override
    public long longValue(long row, long col) {
        return this.myDelegate.longValue(Structure2D.index(this.myRowsCount, row, col));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long row, long col, BinaryFunction<N> mixer, double addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            double oldValue = this.doubleValue(row, col);
            double newValue = mixer.invoke(oldValue, addend);
            this.set(row, col, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long row, long col, BinaryFunction<N> mixer, N addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            N oldValue = this.get(row, col);
            N newValue = mixer.invoke(oldValue, addend);
            this.set(row, col, (Comparable<?>)newValue);
            return newValue;
        }
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.myDelegate.modify(0L, this.count(), 1L, modifier);
    }

    @Override
    public void modifyAny(Transformation2D<N> modifier) {
        modifier.transform(this);
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
        this.myDelegate.modify(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.modify(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        this.myDelegate.modify(0L, this.count(), 1L, function, right);
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(Structure2D.index(this.myRowsCount, row, col), modifier);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(index, modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        this.myDelegate.modify(first, limit, 1L, modifier);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
        this.myDelegate.modify(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, modifier);
    }

    @Override
    public Array1D<N> reduceColumns(Aggregator aggregator) {
        Array1D retVal = ((BasicArray)this.myDelegate.factory().make(this.myColumnsCount)).wrapInArray1D();
        this.reduceColumns(aggregator, retVal);
        return retVal;
    }

    @Override
    public Array1D<N> reduceRows(Aggregator aggregator) {
        Array1D retVal = ((BasicArray)this.myDelegate.factory().make(this.myRowsCount)).wrapInArray1D();
        this.reduceRows(aggregator, retVal);
        return retVal;
    }

    @Override
    public void reset() {
        this.myDelegate.reset();
    }

    @Override
    public Array2D<N> reshape(long rows, long columns) {
        if (Structure2D.count(rows, columns) != this.count()) {
            throw new IllegalArgumentException();
        }
        return this.myDelegate.wrapInArray2D(rows);
    }

    @Override
    public void set(long index, byte value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, float value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, int value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, long value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long row, long col, byte value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, float value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, int value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, long value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, short value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long index, short value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public short shortValue(long index) {
        return this.myDelegate.shortValue(index);
    }

    @Override
    public short shortValue(long row, long col) {
        return this.myDelegate.shortValue(Structure2D.index(this.myRowsCount, row, col));
    }

    @Override
    public Array1D<N> sliceColumn(long col) {
        return this.sliceColumn(0L, col);
    }

    @Override
    public Array1D<N> sliceColumn(long row, long col) {
        return new Array1D<N>(this.myDelegate, Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L);
    }

    @Override
    public Array1D<N> sliceDiagonal(long row, long col) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        return new Array1D<N>(this.myDelegate, Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myDelegate.wrapInArray1D().sliceRange(first, limit);
    }

    @Override
    public Array1D<N> sliceRow(long row) {
        return this.sliceRow(row, 0L);
    }

    @Override
    public Array1D<N> sliceRow(long row, long col) {
        return new Array1D<N>(this.myDelegate, Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount);
    }

    @Override
    public void supplyTo(Mutate2D receiver) {
        this.myDelegate.supplyTo(receiver);
    }

    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<N> visitor) {
        this.myDelegate.visit(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.visit(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, visitor);
    }

    @Override
    public void visitOne(long row, long col, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(Structure2D.index(this.myRowsCount, row, col), visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(index, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.myDelegate.visit(first, limit, 1L, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<N> visitor) {
        this.myDelegate.visit(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, visitor);
    }

    BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    public static final class Factory<N extends Comparable<N>>
    implements Factory2D.Dense<Array2D<N>>,
    Factory2D.MayBeSparse<Array2D<N>, Array2D<N>, Array2D<N>> {
        private final BasicArray.Factory<N> myDelegate;

        Factory(DenseArray.Factory<N> denseArray) {
            this.myDelegate = new BasicArray.Factory<N>(denseArray);
        }

        @Override
        public Array2D<N> columns(Access1D<?> ... source) {
            int tmpColumns = source.length;
            long tmpRows = source[0].count();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            if (tmpDelegate.isPrimitive()) {
                long tmpIndex = 0L;
                for (int j = 0; j < tmpColumns; ++j) {
                    Access1D<?> tmpColumn = source[j];
                    for (long i = 0L; i < tmpRows; ++i) {
                        tmpDelegate.set(tmpIndex++, tmpColumn.doubleValue(i));
                    }
                }
            } else {
                long tmpIndex = 0L;
                for (int j = 0; j < tmpColumns; ++j) {
                    Access1D<?> tmpColumn = source[j];
                    for (long i = 0L; i < tmpRows; ++i) {
                        tmpDelegate.set(tmpIndex++, (Comparable<?>)tmpColumn.get(i));
                    }
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> columns(Comparable<?>[] ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                Comparable<?>[] tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn[i]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> columns(double[] ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn[i]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> columns(List<? extends Comparable<?>> ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].size();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                List<Comparable<?>> tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn.get(i));
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> copy(Access2D<?> source) {
            return this.myDelegate.copy(source).wrapInArray2D(source.countRows());
        }

        public FunctionSet<N> function() {
            return this.myDelegate.function();
        }

        @Override
        public Array2D<N> make(long rows, long columns) {
            return this.makeDense(rows, columns);
        }

        @Override
        public Array2D<N> makeDense(long rows, long columns) {
            return this.myDelegate.makeToBeFilled(rows, columns).wrapInArray2D(rows);
        }

        @Override
        public Array2D<N> makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(rows, columns);
            long tmpIndex = 0L;
            for (long j = 0L; j < columns; ++j) {
                for (long i = 0L; i < rows; ++i) {
                    tmpDelegate.set(tmpIndex++, (Comparable<?>)supplier.get());
                }
            }
            return tmpDelegate.wrapInArray2D(rows);
        }

        @Override
        public Array2D<N> makeSparse(long rows, long columns) {
            return this.myDelegate.makeStructuredZero(rows, columns).wrapInArray2D(rows);
        }

        @Override
        public Array2D<N> rows(Access1D<?> ... source) {
            int tmpRows = source.length;
            long tmpColumns = source[0].count();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            if (tmpDelegate.isPrimitive()) {
                for (int i = 0; i < tmpRows; ++i) {
                    Access1D<?> tmpRow = source[i];
                    for (long j = 0L; j < tmpColumns; ++j) {
                        tmpDelegate.set(Structure2D.index(tmpRows, i, j), tmpRow.doubleValue(j));
                    }
                }
            } else {
                for (int i = 0; i < tmpRows; ++i) {
                    Access1D<?> tmpRow = source[i];
                    for (long j = 0L; j < tmpColumns; ++j) {
                        tmpDelegate.set(Structure2D.index(tmpRows, i, j), (Comparable<?>)tmpRow.get(j));
                    }
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> rows(Comparable<?>[] ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                Comparable<?>[] tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set(Structure2D.index(tmpRows, i, j), tmpRow[j]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> rows(double[] ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set(Structure2D.index(tmpRows, i, j), tmpRow[j]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public Array2D<N> rows(List<? extends Comparable<?>> ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].size();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                List<Comparable<?>> tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set(Structure2D.index(tmpRows, i, j), tmpRow.get(j));
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        public Scalar.Factory<N> scalar() {
            return this.myDelegate.scalar();
        }

        public TensorFactory2D<N, Array2D<N>> tensor() {
            return TensorFactory2D.of(this);
        }

        @Override
        public MathType getMathType() {
            return this.myDelegate.getMathType();
        }
    }
}

