/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.OffHeapArray;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NativeMemory;

final class OffHeapZ064
extends OffHeapArray {
    private final long myPointer;

    OffHeapZ064(long count) {
        super(OffHeapArray.Z064, count);
        this.myPointer = NativeMemory.allocateLongArray(this, count);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.add(index, Scalar.longValue(addend));
    }

    @Override
    public double doubleValue(long index) {
        return NativeMemory.getLong(this.myPointer, index);
    }

    @Override
    public float floatValue(long index) {
        return NativeMemory.getLong(this.myPointer, index);
    }

    @Override
    public long longValue(long index) {
        return NativeMemory.getLong(this.myPointer, index);
    }

    @Override
    public void reset() {
        NativeMemory.initialiseLongArray(this.myPointer, this.count());
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.set(index, Scalar.longValue(value));
    }

    @Override
    public void set(long index, double value) {
        NativeMemory.setLong(this.myPointer, index, Math.round(value));
    }

    @Override
    public void set(long index, float value) {
        NativeMemory.setLong(this.myPointer, index, Math.round(value));
    }

    @Override
    public void set(long index, long value) {
        NativeMemory.setLong(this.myPointer, index, value);
    }
}

