/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.MathContext;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.GrowthStrategy;
import org.ojalgo.array.StrategyBuildingFactory;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public final class SparseArray<N extends Comparable<N>>
extends BasicArray<N> {
    private static final NumberContext MATH_CONTEXT = NumberContext.ofMath(MathContext.DECIMAL64);
    private int myActualLength = 0;
    private final long myCount;
    private long[] myIndices;
    private final DenseArray.Factory<N> myDenseFactory;
    private final GrowthStrategy myGrowthStrategy;
    private DenseArray<N> myValues;
    private final N myZeroNumber;
    private final Scalar<N> myZeroScalar;
    private final double myZeroValue;

    public static <N extends Comparable<N>> SparseFactory<N> factory(DenseArray.Factory<N> denseFactory) {
        return new SparseFactory<N>(denseFactory);
    }

    SparseArray(DenseArray.Factory<N> denseFactory, GrowthStrategy growthStrategy, long count) {
        super(denseFactory);
        this.myCount = count;
        this.myDenseFactory = denseFactory;
        this.myGrowthStrategy = growthStrategy;
        this.myIndices = new long[growthStrategy.initial()];
        this.myValues = growthStrategy.makeInitial(denseFactory);
        this.myZeroScalar = denseFactory.scalar().zero();
        this.myZeroNumber = (Comparable)this.myZeroScalar.get();
        this.myZeroValue = this.myZeroScalar.doubleValue();
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add((long)tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public void add(long index, double addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add((long)tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public void add(long index, float addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add((long)tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public void axpy(double a, Mutate1D.Modifiable<?> y) {
        for (int n = 0; n < this.myActualLength; ++n) {
            y.add(this.myIndices[n], a * this.myValues.doubleValue(n));
        }
    }

    @Override
    public long count() {
        return this.myCount;
    }

    public long countNonzeros() {
        return this.myActualLength;
    }

    public long countZeros() {
        return this.myCount - (long)this.myActualLength;
    }

    @Override
    public double dot(Access1D<?> vector) {
        double retVal = PrimitiveMath.ZERO;
        for (int n = 0; n < this.myActualLength; ++n) {
            retVal += this.myValues.doubleValue(n) * vector.doubleValue(this.myIndices[n]);
        }
        return retVal;
    }

    @Override
    public double doubleValue(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.doubleValueInternally(tmpIndex);
        }
        return this.myZeroValue;
    }

    @Override
    public void fillAll(N value) {
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, NumberDefinition.doubleValue(value))) {
            this.myValues.fillAll(this.myZeroNumber);
        } else {
            int tmpSize = (int)this.count();
            if (tmpSize != this.myIndices.length) {
                this.myIndices = Structure1D.newIncreasingRange(0L, tmpSize);
                this.myValues = (DenseArray)this.myDenseFactory.make(tmpSize);
                this.myActualLength = tmpSize;
            }
            this.myValues.fillAll(value);
        }
    }

    @Override
    public void fillAll(NullaryFunction<?> supplier) {
        int tmpSize = (int)this.count();
        if (tmpSize != this.myIndices.length) {
            this.myIndices = Structure1D.newIncreasingRange(0L, tmpSize);
            this.myValues = (DenseArray)this.myDenseFactory.make(tmpSize);
            this.myActualLength = tmpSize;
        }
        this.myValues.fillAll(supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        if (this.isPrimitive()) {
            this.set(index, values.doubleValue(valueIndex));
        } else {
            this.set(index, (Comparable<?>)values.get(valueIndex));
        }
    }

    @Override
    public void fillOne(long index, N value) {
        this.set(index, (Comparable<?>)value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<?> supplier) {
        this.set(index, (Comparable<?>)supplier.get());
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<?> supplier) {
        this.fill(first, limit, 1L, supplier);
    }

    public long firstInRange(long rangeFirst, long rangeLimit) {
        int tmpFoundAt = this.index(rangeFirst);
        if (tmpFoundAt < 0) {
            tmpFoundAt = -(tmpFoundAt + 1);
        }
        if (tmpFoundAt >= this.myActualLength) {
            return rangeLimit;
        }
        return Math.min(this.myIndices[tmpFoundAt], rangeLimit);
    }

    @Override
    public N get(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.getInternally(tmpIndex);
        }
        return this.myZeroNumber;
    }

    @Override
    public long indexOfLargest() {
        return this.myIndices[Math.toIntExact(this.myValues.indexOfLargest(0L, this.myActualLength, 1L))];
    }

    public long limitOfRange(long rangeFirst, long rangeLimit) {
        int tmpFoundAt = this.index(rangeLimit - 1L);
        if (tmpFoundAt < 0) {
            tmpFoundAt = -(tmpFoundAt + 2);
        }
        if (tmpFoundAt < 0) {
            return rangeFirst;
        }
        return Math.min(this.myIndices[tmpFoundAt] + 1L, rangeLimit);
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        double zeroValue = modifier.invoke(this.myZeroValue);
        if (MATH_CONTEXT.isDifferent(this.myZeroValue, zeroValue)) {
            throw new IllegalArgumentException("SparseArray zero-value modification!");
        }
        this.myValues.modifyAll(modifier);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.set(index, (Comparable<?>)modifier.invoke(this.get(index)));
    }

    public NonzeroView<N> nonzeros() {
        return new NonzeroView<N>(this.myIndices, this.myValues, this.myActualLength);
    }

    @Override
    public void reset() {
        this.myActualLength = 0;
        this.myValues.reset();
    }

    @Override
    public void set(long index, Comparable<?> value) {
        int internalIndex = this.index(index);
        this.update(index, internalIndex, value, false);
    }

    @Override
    public void set(long index, double value) {
        int internalIndex = this.index(index);
        this.update(index, internalIndex, value, false);
    }

    @Override
    public void set(long index, float value) {
        int internalIndex = this.index(index);
        this.update(index, internalIndex, value, false);
    }

    public void supplyNonZerosTo(Mutate1D consumer) {
        if (this.isPrimitive()) {
            for (int n = 0; n < this.myActualLength; ++n) {
                consumer.set(this.myIndices[n], this.myValues.doubleValue(n));
            }
        } else {
            for (int n = 0; n < this.myActualLength; ++n) {
                consumer.set(this.myIndices[n], (Comparable<?>)this.myValues.get(n));
            }
        }
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (this.isPrimitive()) {
            visitor.invoke(this.doubleValue(index));
        } else {
            visitor.invoke(this.get(index));
        }
    }

    public void visitPrimitiveNonzerosInRange(long first, long limit, NonzeroPrimitiveCallback visitor) {
        int localLimit;
        int localFirst = this.index(first);
        if (localFirst < 0) {
            localFirst = -(localFirst + 1);
        }
        if ((localLimit = this.index(limit)) < 0) {
            localLimit = -(localLimit + 1);
        }
        for (int i = localFirst; i < localLimit; ++i) {
            visitor.call(this.myIndices[i], this.myValues.doubleValue(i));
        }
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        int localLimit;
        int localFirst = this.index(first);
        if (localFirst < 0) {
            localFirst = -(localFirst + 1);
        }
        if ((localLimit = this.index(limit)) < 0) {
            localLimit = -(localLimit + 1);
        }
        if (limit - first > (long)(localLimit - localFirst)) {
            visitor.invoke(this.myZeroValue);
        }
        for (int i = localFirst; i < localLimit; ++i) {
            this.myValues.visitOne(i, visitor);
        }
    }

    public void visitReferenceTypeNonzerosInRange(long first, long limit, NonzeroReferenceTypeCallback<N> visitor) {
        int localLimit;
        int localFirst = this.index(first);
        if (localFirst < 0) {
            localFirst = -(localFirst + 1);
        }
        if ((localLimit = this.index(limit)) < 0) {
            localLimit = -(localLimit + 1);
        }
        for (int i = localFirst; i < localLimit; ++i) {
            visitor.call(this.myIndices[i], this.myValues.get(i));
        }
    }

    private void update(long externalIndex, int internalIndex, Comparable<?> value, boolean shouldStoreZero) {
        if (internalIndex >= 0) {
            this.myValues.set((long)internalIndex, value);
        } else if (shouldStoreZero || !value.equals(this.myZeroNumber)) {
            int tmpInsInd = -(internalIndex + 1);
            if (this.myActualLength + 1 <= this.myIndices.length) {
                for (int i = this.myActualLength; i > tmpInsInd; --i) {
                    this.myIndices[i] = this.myIndices[i - 1];
                    this.myValues.set((long)i, (Comparable<?>)this.myValues.get(i - 1));
                }
                this.myIndices[tmpInsInd] = externalIndex;
                this.myValues.set((long)tmpInsInd, value);
            } else {
                int i;
                int tmpCapacity = this.myGrowthStrategy.grow(this.myIndices.length);
                long[] tmpIndices = new long[tmpCapacity];
                DenseArray tmpValues = (DenseArray)this.myDenseFactory.make(tmpCapacity);
                for (i = 0; i < tmpInsInd; ++i) {
                    tmpIndices[i] = this.myIndices[i];
                    tmpValues.set((long)i, (Comparable<?>)this.myValues.get(i));
                }
                tmpIndices[tmpInsInd] = externalIndex;
                tmpValues.set((long)tmpInsInd, value);
                for (i = tmpInsInd; i < this.myIndices.length; ++i) {
                    tmpIndices[i + 1] = this.myIndices[i];
                    tmpValues.set((long)(i + 1), (Comparable<?>)this.myValues.get(i));
                }
                for (i = this.myIndices.length + 1; i < tmpIndices.length; ++i) {
                    tmpIndices[i] = Long.MAX_VALUE;
                }
                this.myIndices = tmpIndices;
                this.myValues = tmpValues;
            }
            ++this.myActualLength;
        }
    }

    private void update(long externalIndex, int internalIndex, double value, boolean shouldStoreZero) {
        if (internalIndex >= 0) {
            this.myValues.set((long)internalIndex, value);
        } else if (shouldStoreZero || NumberContext.compare(value, PrimitiveMath.ZERO) != 0) {
            int tmpInsInd = -(internalIndex + 1);
            if (this.myActualLength + 1 <= this.myIndices.length) {
                for (int i = this.myActualLength; i > tmpInsInd; --i) {
                    this.myIndices[i] = this.myIndices[i - 1];
                    this.myValues.set((long)i, this.myValues.doubleValue(i - 1));
                }
                this.myIndices[tmpInsInd] = externalIndex;
                this.myValues.set((long)tmpInsInd, value);
            } else {
                int i;
                int tmpCapacity = this.myGrowthStrategy.grow(this.myIndices.length);
                long[] tmpIndices = new long[tmpCapacity];
                DenseArray tmpValues = (DenseArray)this.myDenseFactory.make(tmpCapacity);
                for (i = 0; i < tmpInsInd; ++i) {
                    tmpIndices[i] = this.myIndices[i];
                    tmpValues.set((long)i, this.myValues.doubleValue(i));
                }
                tmpIndices[tmpInsInd] = externalIndex;
                tmpValues.set((long)tmpInsInd, value);
                for (i = tmpInsInd; i < this.myIndices.length; ++i) {
                    tmpIndices[i + 1] = this.myIndices[i];
                    tmpValues.set((long)(i + 1), this.myValues.doubleValue(i));
                }
                for (i = this.myIndices.length + 1; i < tmpIndices.length; ++i) {
                    tmpIndices[i] = Long.MAX_VALUE;
                }
                this.myIndices = tmpIndices;
                this.myValues = tmpValues;
            }
            ++this.myActualLength;
        }
    }

    @Override
    protected void exchange(long firstA, long firstB, long step, long count) {
        if (this.isPrimitive()) {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                double tmpVal = this.doubleValue(tmpIndexA);
                this.set(tmpIndexA, this.doubleValue(tmpIndexB));
                this.set(tmpIndexB, tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        } else {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                N tmpVal = this.get(tmpIndexA);
                this.set(tmpIndexA, (Comparable<?>)this.get(tmpIndexB));
                this.set(tmpIndexB, (Comparable<?>)tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, N value) {
        for (long i = first; i < limit; i += step) {
            this.fillOne(i, value);
        }
    }

    @Override
    protected void fill(long first, long limit, long step, NullaryFunction<?> supplier) {
        for (long i = first; i < limit; i += step) {
            this.fillOne(i, supplier);
        }
    }

    @Override
    protected long indexOfLargest(long first, long limit, long step) {
        long retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myIndices.length; ++i) {
            double tmpValue;
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L || !((tmpValue = PrimitiveMath.ABS.invoke(this.myValues.doubleValue(i))) > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpZeroValue)) {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
            this.myValues.modify(tmpIndex, i, left, function);
        }
    }

    @Override
    protected void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpZeroValue)) {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
            this.myValues.modify(tmpIndex, i, function, right);
        }
    }

    @Override
    protected void modify(long first, long limit, long step, UnaryFunction<N> function) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO);
        if (!PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpZeroValue)) {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
            this.myValues.modify(tmpIndex, i, function);
        }
    }

    @Override
    protected void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        boolean tmpOnlyOnce = true;
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex >= first && tmpIndex < limit && (tmpIndex - first) % step == 0L) {
                this.myValues.visitOne(i, visitor);
                continue;
            }
            if (!tmpOnlyOnce) continue;
            visitor.invoke(this.myZeroValue);
            tmpOnlyOnce = false;
        }
    }

    long capacity() {
        return this.myValues.count();
    }

    DenseArray<N> densify() {
        DenseArray retVal = (DenseArray)this.myDenseFactory.make((int)this.count());
        if (this.isPrimitive()) {
            for (int i = 0; i < this.myActualLength; ++i) {
                retVal.set(this.myIndices[i], this.myValues.doubleValue(i));
            }
        } else {
            for (int i = 0; i < this.myActualLength; ++i) {
                retVal.set(this.myIndices[i], (Comparable<?>)this.myValues.get(i));
            }
        }
        return retVal;
    }

    double doubleValueInternally(int internalIndex) {
        return this.myValues.doubleValue(internalIndex);
    }

    long firstIndex() {
        return this.myIndices[0];
    }

    int getActualLength() {
        return this.myActualLength;
    }

    N getInternally(int internalIndex) {
        return this.myValues.get(internalIndex);
    }

    DenseArray<N> getValues() {
        return this.myValues;
    }

    Access1D<N> getValues(long fromIncl, long toExcl) {
        int intFrom = this.index(fromIncl);
        if (intFrom < 0) {
            intFrom = -(intFrom + 1);
        }
        final int first = intFrom;
        int intTo = this.index(toExcl);
        if (intTo < 0) {
            intTo = -(intTo + 1);
        }
        final int limit = intTo;
        return new Access1D<N>(){

            @Override
            public long count() {
                return limit - first;
            }

            @Override
            public double doubleValue(long index) {
                return SparseArray.this.myValues.doubleValue((long)first + index);
            }

            @Override
            public N get(long index) {
                return SparseArray.this.myValues.get((long)first + index);
            }
        };
    }

    @Override
    int index(long index) {
        return Arrays.binarySearch(this.myIndices, 0, this.myActualLength, index);
    }

    LongStream indices() {
        return Arrays.stream(this.myIndices, 0, this.myActualLength);
    }

    long lastIndex() {
        return this.myIndices[this.myActualLength - 1];
    }

    void put(long key, int index, double value) {
        this.update(key, index, value, true);
    }

    void put(long key, int index, N value) {
        this.update(key, index, (Comparable<?>)value, true);
    }

    void remove(long externalIndex, int internalIndex) {
        block4: {
            if (internalIndex < 0) break block4;
            --this.myActualLength;
            if (this.myValues.isPrimitive()) {
                for (int i = internalIndex; i < this.myActualLength; ++i) {
                    this.myIndices[i] = this.myIndices[i + 1];
                    this.myValues.set((long)i, this.myValues.doubleValue(i + 1));
                }
            } else {
                for (int i = internalIndex; i < this.myActualLength; ++i) {
                    this.myIndices[i] = this.myIndices[i + 1];
                    this.myValues.set((long)i, (Comparable<?>)this.myValues.get(i + 1));
                }
            }
        }
    }

    public static final class SparseFactory<N extends Comparable<N>>
    extends StrategyBuildingFactory<N, SparseArray<N>, SparseFactory<N>>
    implements Factory1D<SparseArray<N>> {
        SparseFactory(DenseArray.Factory<N> denseFactory) {
            super(denseFactory);
        }

        @Deprecated
        public SparseArray<N> make() {
            return this.make(Long.MAX_VALUE);
        }

        @Override
        public SparseArray<N> make(long count) {
            return new SparseArray(this.getDenseFactory(), this.getGrowthStrategy(), count);
        }
    }

    public static final class NonzeroView<N extends Comparable<N>>
    implements ElementView1D<N, NonzeroView<N>> {
        private int myCursor = -1;
        private final long[] myIndices;
        private final int myLastCursor;
        private final DenseArray<N> myValues;

        private NonzeroView(long[] indices, DenseArray<N> values, int initial, int last) {
            this.myIndices = indices;
            this.myValues = values;
            this.myCursor = initial;
            this.myLastCursor = last;
        }

        NonzeroView(long[] indices, DenseArray<N> values, int actualLength) {
            this(indices, values, -1, actualLength - 1);
        }

        @Override
        public double doubleValue() {
            return this.myValues.doubleValue(this.myCursor);
        }

        @Override
        public long estimateSize() {
            return this.myLastCursor - this.myCursor;
        }

        @Override
        public void forEachRemaining(Consumer<? super NonzeroView<N>> action) {
            ElementView1D.super.forEachRemaining(action);
        }

        @Override
        public N get() {
            return this.myValues.get(this.myCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < this.myLastCursor;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0;
        }

        @Override
        public long index() {
            return this.myIndices[this.myCursor];
        }

        @Override
        public NonzeroView<N> iterator() {
            return new NonzeroView<N>(this.myIndices, this.myValues, -1, this.myLastCursor);
        }

        public void modify(BinaryFunction<N> function, double right) {
            this.myValues.set((long)this.myCursor, function.invoke(this.myValues.doubleValue(this.myCursor), right));
        }

        public void modify(BinaryFunction<N> function, N right) {
            this.myValues.set((long)this.myCursor, (Comparable<?>)function.invoke(this.myValues.get(this.myCursor), right));
        }

        public void modify(double left, BinaryFunction<N> function) {
            this.myValues.set((long)this.myCursor, function.invoke(left, this.myValues.doubleValue(this.myCursor)));
        }

        public void modify(N left, BinaryFunction<N> function) {
            this.myValues.set((long)this.myCursor, (Comparable<?>)function.invoke(left, this.myValues.get(this.myCursor)));
        }

        @Override
        public NonzeroView<N> next() {
            ++this.myCursor;
            return this;
        }

        @Override
        public long nextIndex() {
            return this.myIndices[this.myCursor + 1];
        }

        @Override
        public NonzeroView<N> previous() {
            --this.myCursor;
            return this;
        }

        @Override
        public long previousIndex() {
            return this.myIndices[this.myCursor - 1];
        }

        @Override
        public boolean tryAdvance(Consumer<? super NonzeroView<N>> action) {
            return ElementView1D.super.tryAdvance(action);
        }

        @Override
        public NonzeroView<N> trySplit() {
            int remaining = this.myLastCursor - this.myCursor;
            if (remaining > 1) {
                int split = this.myCursor + remaining / 2;
                NonzeroView<N> retVal = new NonzeroView<N>(this.myIndices, this.myValues, this.myCursor, split);
                this.myCursor = split;
                return retVal;
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface NonzeroReferenceTypeCallback<N extends Comparable<N>> {
        public void call(long var1, N var3);
    }

    @FunctionalInterface
    public static interface NonzeroPrimitiveCallback {
        public void call(long var1, double var3);
    }
}

