/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.ArrayR032;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.ArrayZ008;
import org.ojalgo.array.ArrayZ016;
import org.ojalgo.array.ArrayZ032;
import org.ojalgo.array.ArrayZ064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.array.operation.CorePrimitiveOperation;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

public abstract class OperationBinary
implements ArrayOperation {
    public static int THRESHOLD = 256;

    public static <N extends Comparable<N>> void invoke(BasicArray<N> data, long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        block12: {
            block10: {
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                if (!data.isPrimitive()) break block10;
                                if (function != PrimitiveMath.ADD) break block11;
                                CorePrimitiveOperation.add(data, first, limit, step, left, right);
                                break block12;
                            }
                            if (function != PrimitiveMath.DIVIDE) break block13;
                            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
                            break block12;
                        }
                        if (function != PrimitiveMath.MULTIPLY) break block14;
                        CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
                        break block12;
                    }
                    if (function != PrimitiveMath.SUBTRACT) break block15;
                    CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
                    break block12;
                }
                switch (data.getMathType()) {
                    case R032: {
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.floatValue(i), right.floatValue(i)));
                        }
                        break block12;
                    }
                    case Z064: {
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.longValue(i), right.longValue(i)));
                        }
                        break block12;
                    }
                    case Z032: 
                    case Z016: 
                    case Z008: {
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.intValue(i), right.intValue(i)));
                        }
                        break block12;
                    }
                    default: {
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.doubleValue(i), right.doubleValue(i)));
                        }
                        break block12;
                    }
                }
            }
            for (long i = first; i < limit; i += step) {
                data.set(i, (Comparable<?>)function.invoke(left.get(i), right.get(i)));
            }
        }
    }

    public static <N extends Comparable<N>> void invoke(BasicArray<N> data, long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function, N right) {
        block12: {
            block10: {
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                if (!data.isPrimitive()) break block10;
                                if (function != PrimitiveMath.ADD) break block11;
                                CorePrimitiveOperation.add(data, first, limit, step, left, right);
                                break block12;
                            }
                            if (function != PrimitiveMath.DIVIDE) break block13;
                            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
                            break block12;
                        }
                        if (function != PrimitiveMath.MULTIPLY) break block14;
                        CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
                        break block12;
                    }
                    if (function != PrimitiveMath.SUBTRACT) break block15;
                    CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
                    break block12;
                }
                switch (data.getMathType()) {
                    case R032: {
                        float floatValue = Scalar.floatValue(right);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.floatValue(i), floatValue));
                        }
                        break block12;
                    }
                    case Z064: {
                        long longValue = Scalar.longValue(right);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.longValue(i), longValue));
                        }
                        break block12;
                    }
                    case Z032: 
                    case Z016: 
                    case Z008: {
                        int intValue = Scalar.intValue(right);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.intValue(i), intValue));
                        }
                        break block12;
                    }
                    default: {
                        double doubleValue = Scalar.doubleValue(right);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(left.doubleValue(i), doubleValue));
                        }
                        break block12;
                    }
                }
            }
            for (long i = first; i < limit; i += step) {
                data.set(i, (Comparable<?>)function.invoke(left.get(i), right));
            }
        }
    }

    public static <N extends Comparable<N>> void invoke(BasicArray<N> data, long first, long limit, long step, N left, BinaryFunction<N> function, Access1D<N> right) {
        block12: {
            block10: {
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                if (!data.isPrimitive()) break block10;
                                if (function != PrimitiveMath.ADD) break block11;
                                CorePrimitiveOperation.add(data, first, limit, step, left, right);
                                break block12;
                            }
                            if (function != PrimitiveMath.DIVIDE) break block13;
                            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
                            break block12;
                        }
                        if (function != PrimitiveMath.MULTIPLY) break block14;
                        CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
                        break block12;
                    }
                    if (function != PrimitiveMath.SUBTRACT) break block15;
                    CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
                    break block12;
                }
                switch (data.getMathType()) {
                    case R032: {
                        float floatValue = Scalar.floatValue(left);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(floatValue, right.floatValue(i)));
                        }
                        break block12;
                    }
                    case Z064: {
                        long longValue = Scalar.longValue(left);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(longValue, right.longValue(i)));
                        }
                        break block12;
                    }
                    case Z032: 
                    case Z016: 
                    case Z008: {
                        int intValue = Scalar.intValue(left);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(intValue, right.intValue(i)));
                        }
                        break block12;
                    }
                    default: {
                        double doubleValue = Scalar.doubleValue(left);
                        for (long i = first; i < limit; i += step) {
                            data.set(i, function.invoke(doubleValue, right.doubleValue(i)));
                        }
                        break block12;
                    }
                }
            }
            for (long i = first; i < limit; i += step) {
                data.set(i, (Comparable<?>)function.invoke(left, right.get(i)));
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof ArrayZ008 && right instanceof ArrayZ008) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ008)left).data, function, ((ArrayZ008)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.byteValue(i), right.byteValue(i));
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, byte right) {
        if (left instanceof ArrayZ008) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ008)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.byteValue(i), right);
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, byte left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof ArrayZ008) {
            OperationBinary.invoke(data, first, limit, step, left, function, ((ArrayZ008)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.byteValue(i));
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, byte left, BinaryFunction<Double> function, byte[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, byte[] left, BinaryFunction<Double> function, byte right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    public static void invoke(byte[] data, int first, int limit, int step, byte[] left, BinaryFunction<Double> function, byte[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof ArrayR064 && right instanceof ArrayR064) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayR064)left).data, function, ((ArrayR064)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.doubleValue(i), right.doubleValue(i));
            }
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, double right) {
        if (left instanceof ArrayR064) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayR064)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.doubleValue(i), right);
            }
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof ArrayR064) {
            OperationBinary.invoke(data, first, limit, step, left, function, ((ArrayR064)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.doubleValue(i));
            }
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, double left, BinaryFunction<Double> function, double[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, double[] left, BinaryFunction<Double> function, double right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    public static void invoke(double[] data, int first, int limit, int step, double[] left, BinaryFunction<Double> function, double[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof ArrayR032 && right instanceof ArrayR032) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayR032)left).data, function, ((ArrayR032)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.floatValue(i), right.floatValue(i));
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, float right) {
        if (left instanceof ArrayR032) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayR032)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.floatValue(i), right);
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, float left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof ArrayR032) {
            OperationBinary.invoke(data, first, limit, step, left, function, ((ArrayR032)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.floatValue(i));
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, float left, BinaryFunction<Double> function, float[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, float[] left, BinaryFunction<Double> function, float right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, float[] left, BinaryFunction<Double> function, float[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof ArrayZ032 && right instanceof ArrayZ032) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ032)left).data, function, ((ArrayZ032)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.intValue(i), right.intValue(i));
            }
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, int right) {
        if (left instanceof ArrayZ032) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ032)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.intValue(i), right);
            }
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, int left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof ArrayZ032) {
            OperationBinary.invoke(data, first, limit, step, left, function, ((ArrayZ032)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.intValue(i));
            }
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, int left, BinaryFunction<Double> function, int[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, int[] left, BinaryFunction<Double> function, int right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    public static void invoke(int[] data, int first, int limit, int step, int[] left, BinaryFunction<Double> function, int[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof ArrayZ064 && right instanceof ArrayZ064) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ064)left).data, function, ((ArrayZ064)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.longValue(i), right.longValue(i));
            }
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, long right) {
        if (left instanceof ArrayZ064) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ064)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.longValue(i), right);
            }
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, long left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof ArrayZ064) {
            OperationBinary.invoke(data, first, limit, step, left, function, ((ArrayZ064)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.longValue(i));
            }
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, long left, BinaryFunction<Double> function, long[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, long[] left, BinaryFunction<Double> function, long right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    public static void invoke(long[] data, int first, int limit, int step, long[] left, BinaryFunction<Double> function, long[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }

    public static <N extends Comparable<N>> void invoke(N[] data, int first, int limit, int step, Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(left.get(i), right.get(i));
        }
    }

    public static <N extends Comparable<N>> void invoke(N[] data, int first, int limit, int step, Access1D<N> left, BinaryFunction<N> function, N right) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(left.get(i), right);
        }
    }

    public static <N extends Comparable<N>> void invoke(N[] data, int first, int limit, int step, N left, BinaryFunction<N> function, Access1D<N> right) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(left, right.get(i));
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left instanceof ArrayZ016 && right instanceof ArrayZ016) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ016)left).data, function, ((ArrayZ016)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.shortValue(i), right.shortValue(i));
            }
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, Access1D<Double> left, BinaryFunction<Double> function, short right) {
        if (left instanceof ArrayZ016) {
            OperationBinary.invoke(data, first, limit, step, ((ArrayZ016)left).data, function, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left.shortValue(i), right);
            }
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, short left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (right instanceof ArrayZ016) {
            OperationBinary.invoke(data, first, limit, step, left, function, ((ArrayZ016)right).data);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right.shortValue(i));
            }
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, short left, BinaryFunction<Double> function, short[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left, right[i]);
            }
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, short[] left, BinaryFunction<Double> function, short right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right);
            }
        }
    }

    public static void invoke(short[] data, int first, int limit, int step, short[] left, BinaryFunction<Double> function, short[] right) {
        if (function == PrimitiveMath.ADD) {
            CorePrimitiveOperation.add(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.DIVIDE) {
            CorePrimitiveOperation.divide(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.MULTIPLY) {
            CorePrimitiveOperation.multiply(data, first, limit, step, left, right);
        } else if (function == PrimitiveMath.SUBTRACT) {
            CorePrimitiveOperation.subtract(data, first, limit, step, left, right);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(left[i], right[i]);
            }
        }
    }
}

