/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.MatrixR064;

public final class FixedReturnsPortfolio
extends EquilibriumModel {
    private final MatrixR064 myReturns;

    public FixedReturnsPortfolio(FinancePortfolio.Context aContext) {
        super(aContext);
        this.myReturns = aContext.getAssetReturns();
    }

    public FixedReturnsPortfolio(MarketEquilibrium aMarketEquilibrium, MatrixR064 returnsVector) {
        super(aMarketEquilibrium);
        this.myReturns = returnsVector;
    }

    private FixedReturnsPortfolio(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myReturns = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void calibrate(FinancePortfolio targetWeights) {
        this.calibrate(targetWeights.getWeights());
    }

    public void calibrate(List<? extends Comparable<?>> targetWeights) {
        this.calibrate((MatrixR064)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{targetWeights}), this.myReturns);
    }

    @Override
    protected MatrixR064 calculateAssetReturns() {
        return this.myReturns;
    }

    @Override
    protected MatrixR064 calculateAssetWeights() {
        return this.calculateAssetWeights(this.myReturns);
    }
}

