/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.data.domain.finance.FinanceUtils;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.TypeUtils;

public class MarketEquilibrium {
    private static final BigDecimal DEFAULT_RISK_AVERSION = BigMath.ONE;
    private static final String STRING_ZERO = "0";
    private static final String SYMBOL = "Asset_";
    private final String[] myAssetKeys;
    private final MatrixR064 myCovariances;
    private BigDecimal myRiskAversion;

    public static Scalar<?> calculatePortfolioReturn(MatrixR064 assetWeights, MatrixR064 assetReturns) {
        return PrimitiveScalar.valueOf(assetWeights.dot(assetReturns));
    }

    private static String[] makeSymbols(int count) {
        String[] retVal = new String[count];
        int tmpMaxLength = Integer.toString(count - 1).length();
        for (int i = 0; i < count; ++i) {
            Object tmpNumberString = Integer.toString(i);
            while (((String)tmpNumberString).length() < tmpMaxLength) {
                tmpNumberString = STRING_ZERO + (String)tmpNumberString;
            }
            retVal[i] = SYMBOL + (String)tmpNumberString;
        }
        return retVal;
    }

    public MarketEquilibrium(Access2D<?> covarianceMatrix) {
        this(covarianceMatrix, DEFAULT_RISK_AVERSION);
    }

    public MarketEquilibrium(Access2D<?> covarianceMatrix, Comparable<?> riskAversionFactor) {
        this(MarketEquilibrium.makeSymbols((int)covarianceMatrix.countRows()), covarianceMatrix, riskAversionFactor);
    }

    public MarketEquilibrium(String[] assetNamesOrKeys, Access2D<?> covarianceMatrix) {
        this(assetNamesOrKeys, covarianceMatrix, DEFAULT_RISK_AVERSION);
    }

    public MarketEquilibrium(String[] assetNamesOrKeys, Access2D<?> covarianceMatrix, Comparable<?> riskAversionFactor) {
        this.myAssetKeys = COPY.copyOf(assetNamesOrKeys);
        this.myCovariances = covarianceMatrix instanceof MatrixR064 ? (MatrixR064)covarianceMatrix : (MatrixR064)MatrixR064.FACTORY.copy((Access2D)covarianceMatrix);
        this.myRiskAversion = TypeUtils.toBigDecimal(riskAversionFactor);
    }

    MarketEquilibrium(MarketEquilibrium marketEquilibrium) {
        this(marketEquilibrium.getAssetKeys(), marketEquilibrium.getCovariances(), (Comparable)marketEquilibrium.getRiskAversion().get());
    }

    public MatrixR064 calculateAssetReturns(MatrixR064 assetWeights) {
        MatrixR064 tmpAssetWeights = this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0 ? assetWeights : (MatrixR064)assetWeights.multiply(this.myRiskAversion.doubleValue());
        return (MatrixR064)this.myCovariances.multiply(tmpAssetWeights);
    }

    public MatrixR064 calculateAssetWeights(MatrixR064 assetReturns) {
        MatrixR064 tmpAssetWeights = (MatrixR064)this.myCovariances.solve((Access2D)assetReturns);
        if (this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0) {
            return tmpAssetWeights;
        }
        return (MatrixR064)tmpAssetWeights.divide(this.myRiskAversion.doubleValue());
    }

    public Scalar<?> calculatePortfolioVariance(MatrixR064 assetWeights) {
        MatrixR064 tmpRight;
        MatrixR064 tmpLeft;
        if (assetWeights.countColumns() == 1L) {
            tmpLeft = (MatrixR064)assetWeights.transpose();
            tmpRight = assetWeights;
        } else {
            tmpLeft = assetWeights;
            tmpRight = (MatrixR064)assetWeights.transpose();
        }
        return ((MatrixR064)tmpLeft.multiply((MatrixR064)this.myCovariances.multiply(tmpRight))).toScalar(0L, 0L);
    }

    public void calibrate(MatrixR064 assetWeights, MatrixR064 assetReturns) {
        Scalar<?> tmpImpliedRiskAversion = this.calculateImpliedRiskAversion(assetWeights, assetReturns);
        this.setRiskAversion((Comparable)tmpImpliedRiskAversion.get());
    }

    public MarketEquilibrium clean() {
        MatrixR064 tmpAssetVolatilities = FinanceUtils.toVolatilities(this.myCovariances, true);
        MatrixR064 tmpCleanedCorrelations = FinanceUtils.toCorrelations(this.myCovariances, true);
        MatrixR064 tmpCovariances = FinanceUtils.toCovariances(tmpAssetVolatilities, tmpCleanedCorrelations);
        return new MarketEquilibrium(this.myAssetKeys, tmpCovariances, this.myRiskAversion);
    }

    public MarketEquilibrium copy() {
        return new MarketEquilibrium(this);
    }

    public String getAssetKey(int index) {
        return this.myAssetKeys[index];
    }

    public String[] getAssetKeys() {
        return COPY.copyOf(this.myAssetKeys);
    }

    public MatrixR064 getCovariances() {
        return this.myCovariances;
    }

    public Scalar<?> getRiskAversion() {
        return BigScalar.of(this.myRiskAversion);
    }

    public void setRiskAversion(Comparable<?> factor) {
        BigDecimal tmpFactor = TypeUtils.toBigDecimal(factor);
        this.myRiskAversion = tmpFactor.signum() == 0 ? DEFAULT_RISK_AVERSION : (tmpFactor.signum() < 0 ? tmpFactor.negate() : tmpFactor);
    }

    public int size() {
        return (int)Math.min(this.myCovariances.countRows(), this.myCovariances.countColumns());
    }

    public MatrixR064 toCorrelations() {
        return FinanceUtils.toCorrelations(this.myCovariances, false);
    }

    Scalar<?> calculateImpliedRiskAversion(MatrixR064 assetWeights, MatrixR064 assetReturns) {
        Scalar<BigDecimal> retVal = ((MatrixR064)((MatrixR064)this.myCovariances.multiply(assetWeights)).solve((Access2D)assetReturns)).toScalar(0L, 0L);
        if (retVal.isSmall(PrimitiveMath.ONE)) {
            retVal = BigScalar.ONE;
        } else if (!retVal.isAbsolute()) {
            retVal = (Scalar)retVal.negate();
        }
        return retVal;
    }

    boolean isDefaultRiskAversion() {
        return this.myRiskAversion.compareTo(DEFAULT_RISK_AVERSION) == 0;
    }
}

