/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.data.domain.finance.portfolio.SimpleAsset;
import org.ojalgo.data.domain.finance.portfolio.simulator.PortfolioSimulator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixR064;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;

public final class SimplePortfolio
extends FinancePortfolio
implements FinancePortfolio.Context {
    private transient MatrixR064 myAssetReturns = null;
    private transient MatrixR064 myAssetVolatilities = null;
    private transient MatrixR064 myAssetWeights = null;
    private final List<SimpleAsset> myComponents;
    private final MatrixR064 myCorrelations;
    private transient MatrixR064 myCovariances = null;
    private transient Comparable<?> myMeanReturn;
    private transient Comparable<?> myReturnVariance;
    private transient List<BigDecimal> myWeights;

    static List<SimpleAsset> toSimpleAssets(double[] someWeights) {
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(someWeights.length);
        for (int i = 0; i < someWeights.length; ++i) {
            retVal.add(new SimpleAsset(Double.valueOf(someWeights[i])));
        }
        return retVal;
    }

    static List<SimpleAsset> toSimpleAssets(Comparable<?>[] someWeights) {
        ArrayList<SimpleAsset> retVal = new ArrayList<SimpleAsset>(someWeights.length);
        for (int i = 0; i < someWeights.length; ++i) {
            retVal.add(new SimpleAsset(someWeights[i]));
        }
        return retVal;
    }

    public SimplePortfolio(Access2D<?> correlationsMatrix, List<SimpleAsset> someAssets) {
        if ((long)someAssets.size() != correlationsMatrix.countRows() || (long)someAssets.size() != correlationsMatrix.countColumns()) {
            throw new IllegalArgumentException("Input dimensions don't match!");
        }
        this.myCorrelations = (MatrixR064)MATRIX_FACTORY.copy((Access2D)correlationsMatrix);
        this.myComponents = someAssets;
    }

    public SimplePortfolio(FinancePortfolio.Context portfolioContext, FinancePortfolio weightsPortfolio) {
        this.myCorrelations = portfolioContext.getCorrelations();
        MatrixR064 tmpCovariances = portfolioContext.getCovariances();
        MatrixR064 tmpAssetReturns = portfolioContext.getAssetReturns();
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        if ((long)tmpWeights.size() != this.myCorrelations.countRows() || (long)tmpWeights.size() != this.myCorrelations.countColumns()) {
            throw new IllegalArgumentException("Input dimensions don't match!");
        }
        this.myComponents = new ArrayList<SimpleAsset>(tmpWeights.size());
        for (int i = 0; i < tmpWeights.size(); ++i) {
            double tmpMeanReturn = tmpAssetReturns.doubleValue(i, 0L);
            double tmpVolatilty = PrimitiveMath.SQRT.invoke(tmpCovariances.doubleValue(i, i));
            BigDecimal tmpWeight = tmpWeights.get(i);
            this.myComponents.add(new SimpleAsset(Double.valueOf(tmpMeanReturn), Double.valueOf(tmpVolatilty), tmpWeight));
        }
    }

    public SimplePortfolio(double[] someWeights) {
        this(SimplePortfolio.toSimpleAssets(someWeights));
    }

    public SimplePortfolio(List<SimpleAsset> someAssets) {
        this((Access2D<?>)MATRIX_FACTORY.makeEye(someAssets.size(), someAssets.size()), someAssets);
    }

    public SimplePortfolio(Comparable<?> ... someWeights) {
        this(SimplePortfolio.toSimpleAssets(someWeights));
    }

    @Override
    public double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        MatrixR064 tmpAssetWeights = (MatrixR064)MATRIX_FACTORY.columns(new List[]{tmpWeights});
        MatrixR064 tmpAssetReturns = this.getAssetReturns();
        return MarketEquilibrium.calculatePortfolioReturn(tmpAssetWeights, tmpAssetReturns).doubleValue();
    }

    @Override
    public double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        List<BigDecimal> tmpWeights = weightsPortfolio.getWeights();
        MatrixR064 tmpAssetWeights = (MatrixR064)MATRIX_FACTORY.columns(new List[]{tmpWeights});
        return new MarketEquilibrium(this.getCovariances()).calculatePortfolioVariance(tmpAssetWeights).doubleValue();
    }

    @Override
    public MatrixR064 getAssetReturns() {
        if (this.myAssetReturns == null) {
            int tmpSize = this.myComponents.size();
            MatrixR064.DenseReceiver tmpReturns = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, 1L);
            for (int i = 0; i < tmpSize; ++i) {
                tmpReturns.set((long)i, 0L, this.getMeanReturn(i));
            }
            this.myAssetReturns = (MatrixR064)tmpReturns.get();
        }
        return this.myAssetReturns;
    }

    @Override
    public MatrixR064 getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            int tmpSize = this.myComponents.size();
            MatrixR064.DenseReceiver tmpVolatilities = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, 1L);
            for (int i = 0; i < tmpSize; ++i) {
                tmpVolatilities.set((long)i, 0L, this.getVolatility(i));
            }
            this.myAssetVolatilities = (MatrixR064)tmpVolatilities.get();
        }
        return this.myAssetVolatilities;
    }

    public double getCorrelation(int row, int col) {
        return this.myCorrelations.doubleValue(row, col);
    }

    @Override
    public MatrixR064 getCorrelations() {
        return this.myCorrelations;
    }

    public double getCovariance(int row, int col) {
        MatrixR064 tmpCovariances = this.myCovariances;
        if (tmpCovariances != null) {
            return tmpCovariances.doubleValue(row, col);
        }
        double tmpRowRisk = this.getVolatility(row);
        double tmpColRisk = this.getVolatility(col);
        double tmpCorrelation = this.getCorrelation(row, col);
        return tmpRowRisk * tmpCorrelation * tmpColRisk;
    }

    @Override
    public MatrixR064 getCovariances() {
        if (this.myCovariances == null) {
            int tmpSize = this.myComponents.size();
            MatrixR064.DenseReceiver tmpCovaris = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, tmpSize);
            for (int j = 0; j < tmpSize; ++j) {
                for (int i = 0; i < tmpSize; ++i) {
                    tmpCovaris.set((long)i, (long)j, this.getCovariance(i, j));
                }
            }
            this.myCovariances = (MatrixR064)tmpCovaris.get();
        }
        return this.myCovariances;
    }

    @Override
    public double getMeanReturn() {
        if (this.myMeanReturn == null) {
            MatrixR064 tmpWeightsVector = this.getAssetWeights();
            MatrixR064 tmpReturnsVector = this.getAssetReturns();
            this.myMeanReturn = (Comparable)MarketEquilibrium.calculatePortfolioReturn(tmpWeightsVector, tmpReturnsVector).get();
        }
        return Scalar.doubleValue(this.myMeanReturn);
    }

    public double getMeanReturn(int index) {
        return this.myComponents.get(index).getMeanReturn();
    }

    @Override
    public double getReturnVariance() {
        if (this.myReturnVariance == null) {
            MarketEquilibrium tmpMarketEquilibrium = new MarketEquilibrium(this.getCovariances());
            MatrixR064 tmpWeightsVector = this.getAssetWeights();
            this.myReturnVariance = (Comparable)tmpMarketEquilibrium.calculatePortfolioVariance(tmpWeightsVector).get();
        }
        return Scalar.doubleValue(this.myReturnVariance);
    }

    public double getReturnVariance(int index) {
        return this.myComponents.get(index).getReturnVariance();
    }

    public PortfolioSimulator getSimulator() {
        ArrayList<GeometricBrownianMotion> tmpAssetProcesses = new ArrayList<GeometricBrownianMotion>(this.myComponents.size());
        for (SimpleAsset tmpAsset : this.myComponents) {
            GeometricBrownianMotion tmpForecast = tmpAsset.forecast();
            tmpForecast.setValue(tmpAsset.getWeight().doubleValue());
            tmpAssetProcesses.add(tmpForecast);
        }
        return new PortfolioSimulator(this.myCorrelations, tmpAssetProcesses);
    }

    public double getVolatility(int index) {
        return this.myComponents.get(index).getVolatility();
    }

    public BigDecimal getWeight(int index) {
        return this.myComponents.get(index).getWeight();
    }

    @Override
    public List<BigDecimal> getWeights() {
        if (this.myWeights == null) {
            this.myWeights = new ArrayList<BigDecimal>(this.myComponents.size());
            for (SimpleAsset tmpAsset : this.myComponents) {
                this.myWeights.add(tmpAsset.getWeight());
            }
        }
        return this.myWeights;
    }

    @Override
    public int size() {
        return this.myComponents.size();
    }

    @Override
    protected void reset() {
        this.myMeanReturn = null;
        this.myReturnVariance = null;
        this.myWeights = null;
        this.myCovariances = null;
        this.myAssetReturns = null;
        this.myAssetVolatilities = null;
        this.myAssetWeights = null;
        for (SimpleAsset tmpAsset : this.myComponents) {
            tmpAsset.reset();
        }
    }

    MatrixR064 getAssetWeights() {
        if (this.myAssetWeights == null) {
            int tmpSize = this.myComponents.size();
            MatrixR064.DenseReceiver tmpWeights = (MatrixR064.DenseReceiver)MATRIX_FACTORY.makeDense(tmpSize, 1L);
            for (int i = 0; i < tmpSize; ++i) {
                tmpWeights.set((long)i, 0L, (Comparable)this.getWeight(i));
            }
            this.myAssetWeights = (MatrixR064)tmpWeights.get();
        }
        return this.myAssetWeights;
    }
}

