/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;

public final class LinearFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Linear<N> {
    private final MatrixStore<N> myCoefficients;

    public static <N extends Comparable<N>> Factory<N> factory(PhysicalStore.Factory<N, ?> factory) {
        return new Factory<N>(factory);
    }

    @Deprecated
    public static LinearFunction<ComplexNumber> makeComplex(Access1D<?> coefficients) {
        return LinearFunction.factory(GenericStore.C128).coefficients(coefficients).make(coefficients.size());
    }

    @Deprecated
    public static LinearFunction<ComplexNumber> makeComplex(int arity) {
        return LinearFunction.factory(GenericStore.C128).make(arity);
    }

    @Deprecated
    public static LinearFunction<Double> makePrimitive(Access1D<?> coefficients) {
        return LinearFunction.factory(Primitive64Store.FACTORY).coefficients(coefficients).make(coefficients.size());
    }

    @Deprecated
    public static LinearFunction<Double> makePrimitive(int arity) {
        return LinearFunction.factory(Primitive64Store.FACTORY).make(arity);
    }

    @Deprecated
    public static LinearFunction<RationalNumber> makeRational(Access1D<?> coefficients) {
        return LinearFunction.factory(GenericStore.Q128).coefficients(coefficients).make(coefficients.size());
    }

    @Deprecated
    public static LinearFunction<RationalNumber> makeRational(int arity) {
        return LinearFunction.factory(GenericStore.Q128).make(arity);
    }

    public static <N extends Comparable<N>> LinearFunction<N> wrap(PhysicalStore<N> coefficients) {
        return new LinearFunction<N>(coefficients);
    }

    LinearFunction(MatrixStore<N> coefficients) {
        if (!coefficients.isVector()) {
            throw new IllegalArgumentException("Must be a  vector!");
        }
        this.myCoefficients = coefficients;
    }

    @Override
    public int arity() {
        return Math.toIntExact(this.myCoefficients.count());
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.getLinearFactors(false);
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.factory().makeZero(this.arity(), this.arity());
    }

    @Override
    public MatrixStore<N> getLinearFactors(boolean negated) {
        Object retVal = this.myCoefficients;
        if (this.myCoefficients.countRows() == 1L) {
            retVal = retVal.transpose();
        }
        if (negated) {
            retVal = retVal.negate();
        }
        return retVal;
    }

    @Override
    public N invoke(Access1D<N> arg) {
        PhysicalStore preallocated = (PhysicalStore)this.myCoefficients.physical().make(1L, 1L);
        this.myCoefficients.multiply(arg, preallocated);
        return preallocated.get(0L, 0L);
    }

    @Override
    public PhysicalStore<N> linear() {
        return (PhysicalStore)this.myCoefficients;
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myCoefficients.physical();
    }

    public static final class Factory<N extends Comparable<N>> {
        private Access1D<?> myCoefficients = null;
        private final PhysicalStore.Factory<N, ?> myFactory;

        Factory(PhysicalStore.Factory<N, ?> factory) {
            this.myFactory = factory;
        }

        public Factory<N> coefficients(Access1D<?> coefficients) {
            this.myCoefficients = coefficients;
            return this;
        }

        public LinearFunction<N> make(int arity) {
            if (this.myCoefficients != null) {
                return new LinearFunction((MatrixStore)this.myFactory.rows(this.myCoefficients));
            }
            return new LinearFunction((MatrixStore)this.myFactory.make(1, arity));
        }
    }
}

