/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.series.NumberSeries;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.TypeUtils;

abstract class AbstractPolynomial<N extends Comparable<N>>
implements PolynomialFunction<N> {
    private final Array1D<N> myCoefficients;
    private transient AbstractPolynomial<N> myDerivative = null;
    private transient AbstractPolynomial<N> myPrimitive = null;

    private AbstractPolynomial() {
        this(null);
    }

    protected AbstractPolynomial(Array1D<N> coefficients) {
        this.myCoefficients = coefficients;
    }

    @Override
    public PolynomialFunction<N> buildDerivative() {
        if (this.myDerivative == null) {
            int tmpSize = Math.max(1, this.myCoefficients.size() - 1);
            this.myDerivative = this.makeInstance(tmpSize);
            for (int i = 0; i < tmpSize; ++i) {
                this.myDerivative.set(i, this.getDerivativeFactor(i));
            }
        }
        return this.myDerivative;
    }

    @Override
    public PolynomialFunction<N> buildPrimitive() {
        if (this.myPrimitive == null) {
            int tmpSize = this.myCoefficients.size() + 1;
            this.myPrimitive = this.makeInstance(tmpSize);
            for (int i = 0; i < tmpSize; ++i) {
                this.myPrimitive.set(i, this.getPrimitiveFactor(i));
            }
        }
        return this.myPrimitive;
    }

    @Override
    public long count() {
        return this.size();
    }

    @Override
    public int degree() {
        return this.myCoefficients.size() - 1;
    }

    @Override
    public double doubleValue(long power) {
        return this.myCoefficients.doubleValue(power);
    }

    @Override
    public void estimate(List<? extends N> x, List<? extends N> y) {
        this.estimate(Access1D.wrap(x), Access1D.wrap(y));
    }

    void estimate(Access1D<?> x, Access1D<?> y, PhysicalStore.Factory<N, ?> store, QR.Factory<N> qr) {
        int tmpRowDim = Math.min(x.size(), y.size());
        int tmpColDim = this.size();
        PhysicalStore tmpBody = (PhysicalStore)store.make(tmpRowDim, tmpColDim);
        PhysicalStore tmpRHS = (PhysicalStore)store.make(tmpRowDim, 1);
        for (int i = 0; i < tmpRowDim; ++i) {
            BigDecimal tmpX = BigMath.ONE;
            BigDecimal tmpXfactor = TypeUtils.toBigDecimal(x.get(i));
            BigDecimal tmpY = TypeUtils.toBigDecimal(y.get(i));
            for (int j = 0; j < tmpColDim; ++j) {
                tmpBody.set((long)i, (long)j, tmpX);
                tmpX = tmpX.multiply(tmpXfactor);
            }
            tmpRHS.set((long)i, 0L, tmpY);
        }
        MatrixDecomposition tmpQR = qr.make(tmpBody);
        tmpQR.decompose(tmpBody);
        this.set(tmpQR.getSolution(tmpRHS));
    }

    @Override
    public void estimate(NumberSeries<?> samples) {
        this.estimate(samples.accessKeys(), samples.accessValues());
    }

    @Override
    public N get(long power) {
        return this.myCoefficients.get(power);
    }

    @Override
    public double invoke(double arg) {
        int power = this.degree();
        double retVal = this.doubleValue(power);
        while (--power >= 0) {
            retVal = this.doubleValue(power) + arg * retVal;
        }
        return retVal;
    }

    @Override
    public float invoke(float arg) {
        int power = this.degree();
        float retVal = this.floatValue(power);
        while (--power >= 0) {
            retVal = this.floatValue(power) + arg * retVal;
        }
        return retVal;
    }

    @Override
    public void set(int power, double coefficient) {
        this.myCoefficients.set((long)power, coefficient);
        this.myDerivative = null;
        this.myPrimitive = null;
    }

    @Override
    public void set(int power, N coefficient) {
        this.myCoefficients.set(power, coefficient);
        this.myDerivative = null;
        this.myPrimitive = null;
    }

    @Override
    public int size() {
        return this.myCoefficients.size();
    }

    protected abstract N getDerivativeFactor(int var1);

    protected abstract N getPrimitiveFactor(int var1);

    protected abstract AbstractPolynomial<N> makeInstance(int var1);
}

