/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import java.math.BigDecimal;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.function.polynomial.PolynomialFunction;
import org.ojalgo.function.polynomial.PolynomialQ128;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.TypeUtils;

public class PolynomialR256
extends AbstractPolynomial<BigDecimal> {
    public PolynomialR256(int degree) {
        super((Array1D)Array1D.R256.make(degree + 1));
    }

    PolynomialR256(Array1D<BigDecimal> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        PolynomialQ128 delegate = new PolynomialQ128(this.degree());
        delegate.estimate(x, y);
        this.set(delegate);
    }

    @Override
    public BigDecimal integrate(BigDecimal fromPoint, BigDecimal toPoint) {
        PolynomialFunction primitive = this.buildPrimitive();
        BigDecimal fromVal = primitive.invoke(fromPoint);
        BigDecimal toVal = primitive.invoke(toPoint);
        return toVal.subtract(fromVal);
    }

    @Override
    public BigDecimal invoke(BigDecimal arg) {
        int power = this.degree();
        BigDecimal retVal = (BigDecimal)this.get(power);
        while (--power >= 0) {
            retVal = ((BigDecimal)this.get(power)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int limit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < limit; ++p) {
            this.set(p, TypeUtils.toBigDecimal(coefficients.get(p)));
        }
    }

    @Override
    protected BigDecimal getDerivativeFactor(int power) {
        int nextIndex = power + 1;
        return ((BigDecimal)this.get(nextIndex)).multiply(new BigDecimal(nextIndex));
    }

    @Override
    protected BigDecimal getPrimitiveFactor(int power) {
        if (power <= 0) {
            return BigMath.ZERO;
        }
        return ((BigDecimal)this.get(power - 1)).divide(new BigDecimal(power));
    }

    @Override
    protected AbstractPolynomial<BigDecimal> makeInstance(int size) {
        return new PolynomialR256((Array1D)Array1D.R256.make(size));
    }
}

