/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.special;

import java.util.Arrays;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;

public abstract class PowerOf2 {
    private static final int[] INT_POWERS;
    private static double LN2;
    private static final long[] LONG_POWERS;
    public final int exponent;

    public static int adjustDown(double value) {
        return PowerOf2.largestNotGreaterThan(Math.toIntExact(Math.round(value)));
    }

    public static int adjustUp(double value) {
        return PowerOf2.smallestNotLessThan(Math.toIntExact(Math.round(value)));
    }

    public static int exponent(double value) {
        return MissingMath.roundToInt(Math.log(value) / LN2);
    }

    public static int find(int value) {
        return Arrays.binarySearch(INT_POWERS, value);
    }

    public static int find(long value) {
        return Arrays.binarySearch(LONG_POWERS, value);
    }

    public static IntPower getIntPower(int exponent) {
        return new IntPower(exponent);
    }

    public static LongPower getLongPower(int exponent) {
        return new LongPower(exponent);
    }

    public static boolean isPowerOf2(int value) {
        return value > 0 && (value & value - 1) == 0;
    }

    public static boolean isPowerOf2(long value) {
        return value > 0L && (value & value - 1L) == 0L;
    }

    public static int largestNotGreaterThan(int value) {
        if (value <= 0) {
            throw new ArithmeticException();
        }
        return Integer.highestOneBit(value);
    }

    public static int powerOf2Larger(int value) {
        int index = Arrays.binarySearch(INT_POWERS, value);
        return index >= 0 ? index : Math.min(-(index + 1), 30);
    }

    public static int powerOf2Larger(long value) {
        int index = Arrays.binarySearch(LONG_POWERS, value);
        return index >= 0 ? index : Math.min(-(index + 1), 62);
    }

    public static int powerOf2Smaller(int value) {
        int index = Arrays.binarySearch(INT_POWERS, value);
        return index >= 0 ? index : Math.max(-(index + 2), 0);
    }

    public static int powerOf2Smaller(long value) {
        int index = Arrays.binarySearch(LONG_POWERS, value);
        return index >= 0 ? index : Math.max(-(index + 2), 0);
    }

    public static int powerOfInt2(int exponent) {
        return INT_POWERS[exponent];
    }

    public static long powerOfLong2(int exponent) {
        return LONG_POWERS[exponent];
    }

    public static int smallestNotLessThan(int value) {
        if (value < 0) {
            throw new ArithmeticException();
        }
        if (value == 0) {
            return 1;
        }
        int candidate = Integer.highestOneBit(value);
        if (candidate == Integer.lowestOneBit(value)) {
            return candidate;
        }
        return candidate << 1;
    }

    PowerOf2(int exp) {
        this.exponent = exp;
    }

    static {
        int p;
        INT_POWERS = new int[31];
        LN2 = Math.log(PrimitiveMath.TWO);
        LONG_POWERS = new long[63];
        PowerOf2.INT_POWERS[0] = 1;
        for (p = 1; p < INT_POWERS.length; ++p) {
            PowerOf2.INT_POWERS[p] = INT_POWERS[p - 1] * 2;
        }
        PowerOf2.LONG_POWERS[0] = 1L;
        for (p = 1; p < LONG_POWERS.length; ++p) {
            PowerOf2.LONG_POWERS[p] = LONG_POWERS[p - 1] * 2L;
        }
    }

    public static final class LongPower
    extends PowerOf2 {
        public final long value;
        private final long myModuloMask;

        LongPower(int exp) {
            super(exp);
            this.value = LONG_POWERS[exp];
            this.myModuloMask = this.value - 1L;
        }

        public long divide(long dividend) {
            return dividend >> this.exponent;
        }

        public long getModuloMask() {
            return this.myModuloMask;
        }

        public long modulo(long dividend) {
            return dividend & this.myModuloMask;
        }
    }

    public static final class IntPower
    extends PowerOf2 {
        public final int value;
        private final int myModuloMask;

        IntPower(int exp) {
            super(exp);
            this.value = INT_POWERS[exp];
            this.myModuloMask = this.value - 1;
        }

        public int divide(int dividend) {
            return dividend >> this.exponent;
        }

        public int getModuloMask() {
            return this.myModuloMask;
        }

        public int modulo(int dividend) {
            return dividend & this.myModuloMask;
        }
    }
}

