/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.LDLDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public interface LDL<N extends Comparable<N>>
extends LDU<N>,
MatrixDecomposition.Hermitian<N>,
MatrixDecomposition.Pivoting<N> {
    public static final Factory<ComplexNumber> C128 = typical -> new LDLDecomposition.C128();
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    public static final Factory<Quaternion> H256 = typical -> new LDLDecomposition.H256();
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    public static final Factory<Double> R064 = typical -> new LDLDecomposition.R064();
    public static final Factory<Quadruple> R128 = typical -> new LDLDecomposition.R128();
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    public static final Factory<RationalNumber> Q128 = typical -> new LDLDecomposition.Q128();
    @Deprecated
    public static final Factory<Quadruple> QUADRUPLE = R128;
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, LDL<N> decomposition, NumberContext context) {
        return Access2D.equals(matrix, decomposition.reconstruct(), context);
    }

    public static <N extends Comparable<N>> Factory<N> modified(Factory<N> delegate, N threshold) {
        return new ModifiedFactory<N>(delegate, threshold);
    }

    public MatrixStore<N> getD();

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxL = this.getL();
        MatrixStore<N> mtrxD = this.getD();
        MatrixStore<N> mtrxR = this.getR();
        int[] reverseOrder = this.getReversePivotOrder();
        return mtrxL.multiply(mtrxD).multiply((MatrixStore<MatrixStore<N>>)mtrxR).rows(reverseOrder).columns(reverseOrder);
    }

    public static final class ModifiedFactory<N extends Comparable<N>>
    implements Factory<N> {
        private final Factory<N> myDelegate;
        private final N myThreshold;

        ModifiedFactory(Factory<N> delegate, N threshold) {
            this.myDelegate = delegate;
            this.myThreshold = threshold;
        }

        @Override
        public LDL<N> make(Structure2D typical) {
            LDL retVal = (LDL)this.myDelegate.make(typical);
            if (this.myThreshold != null && retVal instanceof LDLDecomposition) {
                ((LDLDecomposition)retVal).setThreshold(this.myThreshold);
            }
            return retVal;
        }
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<LDL<N>> {
        default public Factory<N> modified(N threshold) {
            return new ModifiedFactory<N>(this, threshold);
        }
    }
}

