/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;

abstract class QRDecomposition<N extends Comparable<N>>
extends InPlaceDecomposition<N>
implements QR<N> {
    private final boolean myFullSize;
    private int myNumberOfHouseholderTransformations = 0;

    protected QRDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, boolean fullSize) {
        super(factory);
        this.myFullSize = fullSize;
    }

    @Override
    public void btran(PhysicalStore<N> arg) {
        DecompositionStore body = this.getInPlace();
        arg.substituteForwards(body, false, true, false);
        HouseholderReference reference = HouseholderReference.makeColumn(body);
        for (int j = this.getMinDim() - 1; j >= 0; --j) {
            reference.point(j, j);
            if (reference.isZero()) continue;
            arg.transformLeft(reference, 0);
        }
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public int countSignificant(double threshold) {
        DecompositionStore internal = this.getInPlace();
        int significant = 0;
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(Math.abs(internal.doubleValue(ij, ij)) > threshold)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        this.reset();
        DecompositionStore tmpStore = this.setInPlace(matrix);
        int m = this.getRowDim();
        int r = this.getMinDim();
        Householder tmpHouseholder = this.makeHouseholder(m);
        for (int k = 0; k < r; ++k) {
            if (k + 1 >= m || !tmpStore.generateApplyAndCopyHouseholderColumn(k, k, tmpHouseholder)) continue;
            tmpStore.transformLeft(tmpHouseholder, k + 1);
            ++this.myNumberOfHouseholderTransformations;
        }
        return this.computed(true);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction aggregator = this.aggregator().product();
        this.getInPlace().visitDiagonal(aggregator);
        if (this.myNumberOfHouseholderTransformations % 2 != 0) {
            return (N)((Comparable)((Scalar)((Scalar)this.scalar().one().negate()).multiply((Comparable)aggregator.get())).get());
        }
        return (N)((Comparable)aggregator.get());
    }

    @Override
    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        return this.getSolution(this.makeIdentity(this.getRowDim()), preallocated);
    }

    @Override
    public MatrixStore<N> getQ() {
        DecompositionStore retVal = this.makeEye(this.getRowDim(), this.myFullSize ? this.getRowDim() : this.getMinDim());
        HouseholderReference tmpReference = HouseholderReference.makeColumn(this.getInPlace());
        for (int j = this.getMinDim() - 1; j >= 0; --j) {
            tmpReference.point(j, j);
            if (tmpReference.isZero()) continue;
            retVal.transformLeft(tmpReference, j);
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> getR() {
        Structure2D.Logical logical = this.getInPlace().triangular(true, false);
        int nbRows = this.getRowDim();
        int nbCols = this.getColDim();
        if (!this.myFullSize && nbRows > nbCols) {
            return logical.limits(nbCols, -1L);
        }
        return logical;
    }

    @Override
    public double getRankThreshold() {
        Object largest = this.getInPlace().aggregateDiagonal(Aggregator.LARGEST);
        double epsilon = this.getDimensionalEpsilon();
        return epsilon * Math.max(Double.MIN_NORMAL, NumberDefinition.doubleValue(largest));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getSolution(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        rhs.supplyTo(preallocated);
        DecompositionStore body = this.getInPlace();
        int m = this.getRowDim();
        int n = this.getColDim();
        HouseholderReference reference = HouseholderReference.makeColumn(body);
        int limit = this.getMinDim();
        for (int j = 0; j < limit; ++j) {
            reference.point(j, j);
            if (reference.isZero()) continue;
            preallocated.transformLeft(reference, 0);
        }
        preallocated.substituteBackwards(body, false, false, false);
        if (n < m) {
            return preallocated.limits(n, preallocated.getColDim());
        }
        if (n > m) {
            return preallocated.below(n - m);
        }
        return preallocated;
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myNumberOfHouseholderTransformations = 0;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return this.isAspectRatioNormal() && this.isFullRank();
    }

    protected DecompositionStore<N> getL() {
        int tmpRowDim = this.getColDim();
        int tmpColDim = this.getMinDim();
        DecompositionStore retVal = this.makeZero(tmpRowDim, tmpColDim);
        DecompositionStore tmpStore = this.getInPlace();
        for (int j = 0; j < tmpColDim; ++j) {
            for (int i = j; i < tmpRowDim; ++i) {
                retVal.set((long)i, (long)j, (Comparable<?>)tmpStore.get(j, i));
            }
        }
        return retVal;
    }

    static final class R128
    extends QRDecomposition<Quadruple> {
        R128() {
            this(false);
        }

        R128(boolean fullSize) {
            super(GenericStore.R128, fullSize);
        }
    }

    static final class R064
    extends QRDecomposition<Double> {
        R064() {
            this(false);
        }

        R064(boolean fullSize) {
            super(Primitive64Store.FACTORY, fullSize);
        }
    }

    static final class Q128
    extends QRDecomposition<RationalNumber> {
        Q128() {
            this(false);
        }

        Q128(boolean fullSize) {
            super(GenericStore.Q128, fullSize);
        }
    }

    static final class H256
    extends QRDecomposition<Quaternion> {
        H256() {
            this(false);
        }

        H256(boolean fullSize) {
            super(GenericStore.H256, fullSize);
        }
    }

    static final class C128
    extends QRDecomposition<ComplexNumber> {
        C128() {
            this(false);
        }

        C128(boolean fullSize) {
            super(GenericStore.C128, fullSize);
        }
    }
}

