/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.operation.MultiplyBoth;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive32Store;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.Subregion2D;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.math.MathType;

public final class SparseStore<N extends Comparable<N>>
extends FactoryStore<N>
implements TransformableRegion<N> {
    public static final Factory<ComplexNumber> C128 = SparseStore.factory(GenericStore.C128);
    public static final Factory<Quaternion> H256 = SparseStore.factory(GenericStore.H256);
    public static final Factory<Double> R032 = SparseStore.factory(Primitive32Store.FACTORY);
    public static final Factory<Double> R064 = SparseStore.factory(Primitive64Store.FACTORY);
    public static final Factory<Quadruple> R128 = SparseStore.factory(GenericStore.R128);
    public static final Factory<RationalNumber> Q128 = SparseStore.factory(GenericStore.Q128);
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    @Deprecated
    public static final Factory<Double> PRIMITIVE32 = R032;
    @Deprecated
    public static final Factory<Double> PRIMITIVE64 = R064;
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;
    private final SparseArray<N> myElements;
    private final int[] myFirsts;
    private final int[] myLimits;
    private TransformableRegion.FillByMultiplying<N> myMultiplyer;

    public static <N extends Comparable<N>> Factory<N> factory(PhysicalStore.Factory<N, ?> physicalFactory) {
        return new Factory<N>(physicalFactory);
    }

    @Deprecated
    public static SparseStore<ComplexNumber> makeComplex(long rowsCount, long columnsCount) {
        return SparseStore.makeSparse(GenericStore.C128, rowsCount, columnsCount);
    }

    @Deprecated
    public static SparseStore<Double> makePrimitive(long rowsCount, long columnsCount) {
        return SparseStore.makeSparse(Primitive64Store.FACTORY, rowsCount, columnsCount);
    }

    @Deprecated
    public static SparseStore<Double> makePrimitive32(long rowsCount, long columnsCount) {
        return SparseStore.makeSparse(Primitive32Store.FACTORY, rowsCount, columnsCount);
    }

    @Deprecated
    public static SparseStore<Quaternion> makeQuaternion(long rowsCount, long columnsCount) {
        return SparseStore.makeSparse(GenericStore.H256, rowsCount, columnsCount);
    }

    @Deprecated
    public static SparseStore<RationalNumber> makeRational(long rowsCount, long columnsCount) {
        return SparseStore.makeSparse(GenericStore.Q128, rowsCount, columnsCount);
    }

    private static <N extends Scalar<N>> void doGenericColumnAXPY(SparseArray<N> elements, long colX, long colY, N a, TransformableRegion<N> y) {
        long structure = y.countRows();
        long first = structure * colX;
        long limit = first + structure;
        elements.visitReferenceTypeNonzerosInRange(first, limit, (index, value) -> y.add(Structure2D.row(index, structure), colY, value.multiply(a)));
    }

    private static void doPrimitiveColumnAXPY(SparseArray<Double> elements, long colX, long colY, double a, TransformableRegion<Double> y) {
        long structure = y.countRows();
        long first = structure * colX;
        long limit = first + structure;
        elements.visitPrimitiveNonzerosInRange(first, limit, (index, value) -> y.add(Structure2D.row(index, structure), colY, a * value));
    }

    static <N extends Comparable<N>> SparseStore<N> makeSparse(PhysicalStore.Factory<N, ?> physical, long numberOfRows, long numberOfColumns) {
        return new SparseStore<N>(physical, Math.toIntExact(numberOfRows), Math.toIntExact(numberOfColumns));
    }

    static <N extends Comparable<N>> SparseStore<N> makeSparse(PhysicalStore.Factory<N, ?> physical, Structure2D shape) {
        return SparseStore.makeSparse(physical, shape.countRows(), shape.countColumns());
    }

    static <N extends Comparable<N>> void multiply(SparseStore<N> left, SparseStore<N> right, TransformableRegion<N> target) {
        target.reset();
        if (left.isPrimitive()) {
            SparseArray tmpLeft = left.getElements();
            TransformableRegion tmpTarget = target;
            right.nonzeros().stream().forEach(element -> SparseStore.doPrimitiveColumnAXPY(tmpLeft, element.row(), element.column(), element.doubleValue(), tmpTarget));
        } else if (left.getComponentType().isAssignableFrom(ComplexNumber.class)) {
            SparseArray tmpLeft = left.getElements();
            SparseStore<N> tmpRight = right;
            TransformableRegion tmpTarget = target;
            tmpRight.nonzeros().stream().forEach(element -> SparseStore.doGenericColumnAXPY(tmpLeft, element.row(), element.column(), (ComplexNumber)element.get(), tmpTarget));
        } else if (left.getComponentType().isAssignableFrom(RationalNumber.class)) {
            SparseArray tmpLeft = left.getElements();
            SparseStore<N> tmpRight = right;
            TransformableRegion tmpTarget = target;
            tmpRight.nonzeros().stream().forEach(element -> SparseStore.doGenericColumnAXPY(tmpLeft, element.row(), element.column(), (RationalNumber)element.get(), tmpTarget));
        } else if (left.getComponentType().isAssignableFrom(Quaternion.class)) {
            SparseArray tmpLeft = left.getElements();
            SparseStore<N> tmpRight = right;
            TransformableRegion tmpTarget = target;
            tmpRight.nonzeros().stream().forEach(element -> SparseStore.doGenericColumnAXPY(tmpLeft, element.row(), element.column(), (Quaternion)element.get(), tmpTarget));
        } else {
            throw new IllegalStateException("Unsupported element type!");
        }
    }

    SparseStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myElements = ((SparseArray.SparseFactory)((SparseArray.SparseFactory)SparseArray.factory(factory.array()).limit(this.count())).initial(Math.max(rowsCount, columnsCount))).make();
        this.myFirsts = new int[rowsCount];
        this.myLimits = new int[rowsCount];
        Arrays.fill(this.myFirsts, columnsCount);
        Class<?> tmpType = ((Comparable)factory.scalar().zero().get()).getClass();
        this.myMultiplyer = tmpType.equals(Double.class) ? MultiplyBoth.newPrimitive64(rowsCount, columnsCount) : MultiplyBoth.newGeneric(rowsCount, columnsCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long row, long col, Comparable<?> addend) {
        SparseArray<N> sparseArray = this.myElements;
        synchronized (sparseArray) {
            this.myElements.add(Structure2D.index(this.myFirsts.length, row, col), addend);
        }
        this.updateNonZeros(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long row, long col, double addend) {
        SparseArray<N> sparseArray = this.myElements;
        synchronized (sparseArray) {
            this.myElements.add(Structure2D.index(this.myFirsts.length, row, col), addend);
        }
        this.updateNonZeros(row, col);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myElements.doubleValue(Structure2D.index(this.myFirsts.length, row, col));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof SparseStore)) {
            return false;
        }
        SparseStore other = (SparseStore)obj;
        if (this.myElements == null ? other.myElements != null : !this.myElements.equals(other.myElements)) {
            return false;
        }
        return Arrays.equals(this.myFirsts, other.myFirsts) && Arrays.equals(this.myLimits, other.myLimits);
    }

    @Override
    public void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
        int complexity = Math.toIntExact(left.count() / this.countRows());
        if (complexity != Math.toIntExact(right.count() / this.countColumns())) {
            ProgrammingError.throwForMultiplicationNotPossible();
        }
        this.myMultiplyer.invoke((TransformableRegion<N>)this, left, complexity, right);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, (Comparable<?>)values.get(valueIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillOne(long row, long col, N value) {
        SparseArray<N> sparseArray = this.myElements;
        synchronized (sparseArray) {
            this.myElements.fillOne(Structure2D.index(this.myFirsts.length, row, col), value);
        }
        this.updateNonZeros(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        SparseArray<N> sparseArray = this.myElements;
        synchronized (sparseArray) {
            this.myElements.fillOne(Structure2D.index(this.myFirsts.length, row, col), supplier);
        }
        this.updateNonZeros(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        long structure = this.myFirsts.length;
        long rangeFirst = structure * (long)col;
        long rangeLimit = structure * (long)(col + 1);
        long firstInRange = this.myElements.firstInRange(rangeFirst, rangeLimit);
        if (rangeFirst == firstInRange) {
            return 0;
        }
        return (int)(firstInRange % structure);
    }

    @Override
    public int firstInRow(int row) {
        return this.myFirsts[row];
    }

    @Override
    public N get(long row, long col) {
        return this.myElements.get(Structure2D.index(this.myFirsts.length, row, col));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.myElements == null ? 0 : this.myElements.hashCode());
        result = prime * result + Arrays.hashCode(this.myFirsts);
        return prime * result + Arrays.hashCode(this.myLimits);
    }

    @Override
    public long indexOfLargest() {
        return this.myElements.indexOfLargest();
    }

    @Override
    public int limitOfColumn(int col) {
        long structure = this.myFirsts.length;
        long rangeFirst = structure * (long)col;
        long rangeLimit = rangeFirst + structure;
        long limitOfRange = this.myElements.limitOfRange(rangeFirst, rangeLimit);
        if (rangeLimit == limitOfRange) {
            return (int)structure;
        }
        return (int)(limitOfRange % structure);
    }

    @Override
    public int limitOfRow(int row) {
        return this.myLimits[row];
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        long tmpLimit = this.count();
        if (this.isPrimitive()) {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, modifier.invoke(this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, (Comparable<?>)modifier.invoke(this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        boolean notModifiesZero;
        long limit = Math.min(left.count(), this.count());
        boolean bl = notModifiesZero = function.invoke(PrimitiveMath.E, PrimitiveMath.ZERO) == PrimitiveMath.ZERO;
        if (this.isPrimitive()) {
            if (notModifiesZero) {
                for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                    element.modify(left.doubleValue(element.index()), function);
                }
            } else {
                for (long i = 0L; i < limit; ++i) {
                    this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
                }
            }
        } else if (notModifiesZero) {
            for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                element.modify(left.get(element.index()), function);
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Comparable<?>)function.invoke(left.get(i), this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        boolean notModifiesZero;
        long limit = Math.min(this.count(), right.count());
        boolean bl = notModifiesZero = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.E) == PrimitiveMath.ZERO;
        if (this.isPrimitive()) {
            if (notModifiesZero) {
                for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                    element.modify(function, right.doubleValue(element.index()));
                }
            } else {
                for (long i = 0L; i < limit; ++i) {
                    this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
                }
            }
        } else if (notModifiesZero) {
            for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                element.modify(function, right.get(element.index()));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Comparable<?>)function.invoke(this.get(i), right.get(i)));
            }
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        if (this.isPrimitive()) {
            this.set(row, col, modifier.invoke(this.doubleValue(row, col)));
        } else {
            this.set(row, col, (Comparable<?>)modifier.invoke(this.get(row, col)));
        }
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        if (right instanceof SparseStore) {
            SparseStore.multiply(this, (SparseStore)right, target);
        } else if (this.isPrimitive()) {
            long complexity = this.countColumns();
            long numberOfColumns = target.countColumns();
            target.reset();
            this.nonzeros().stream().forEach(element -> {
                long row = element.row();
                long col = element.column();
                double value = element.doubleValue();
                long first = Structure2D.firstInRow((Structure1D)right, col, 0L);
                long limit = Structure2D.limitOfRow((Structure1D)right, col, numberOfColumns);
                for (long j = first; j < limit; ++j) {
                    long index = Structure2D.index(complexity, col, j);
                    double addition = value * right.doubleValue(index);
                    if (NumberContext.compare(addition, PrimitiveMath.ZERO) == 0) continue;
                    target.add(row, j, addition);
                }
            });
        } else {
            super.multiply(right, target);
        }
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        SparseStore retVal = SparseStore.makeSparse(this.physical(), this);
        if (this.isPrimitive()) {
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), nonzero.doubleValue() * scalar);
            }
        } else {
            Scalar sclr = this.physical().scalar().convert(scalar);
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), (Comparable)((Scalar)sclr.multiply((Comparable)nonzero.get())).get());
            }
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        long numberOfRows = this.countRows();
        long numberOfColumns = right.countColumns();
        if (right instanceof SparseStore) {
            SparseStore retVal = SparseStore.makeSparse(this.physical(), numberOfRows, numberOfColumns);
            SparseStore.multiply(this, (SparseStore)right, retVal);
            return retVal;
        }
        PhysicalStore retVal = (PhysicalStore)this.physical().make(numberOfRows, numberOfColumns);
        this.multiply(right, retVal);
        return retVal;
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        SparseStore retVal = SparseStore.makeSparse(this.physical(), this);
        if (this.isPrimitive()) {
            double sclr = NumberDefinition.doubleValue(scalar);
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), nonzero.doubleValue() * sclr);
            }
        } else {
            Scalar sclr = this.physical().scalar().convert((Comparable<?>)scalar);
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), (Comparable)((Scalar)sclr.multiply((Comparable)nonzero.get())).get());
            }
        }
        return retVal;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementView2D<N, ?> nonzeros() {
        return new Access2D.ElementView(this.myElements.nonzeros(), this.countRows());
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        long complexity = this.countRows();
        long numberOfColumns = this.countColumns();
        long numberOfRows = left.count() / complexity;
        if (left instanceof SparseStore) {
            SparseStore retVal = SparseStore.makeSparse(this.physical(), numberOfRows, numberOfColumns);
            SparseStore.multiply((SparseStore)left, this, retVal);
            return retVal;
        }
        if (!this.isPrimitive()) {
            return super.premultiply(left);
        }
        SparseStore retVal = SparseStore.makeSparse(this.physical(), numberOfRows, numberOfColumns);
        this.nonzeros().stream().forEach(element -> {
            long row = element.row();
            long col = element.column();
            double value = element.doubleValue();
            long first = Structure2D.firstInColumn((Structure1D)left, row, 0L);
            long limit = Structure2D.limitOfColumn((Structure1D)left, row, numberOfRows);
            for (long i = first; i < limit; ++i) {
                long index = Structure2D.index(numberOfRows, i, row);
                double addition = value * left.doubleValue(index);
                if (NumberContext.compare(addition, PrimitiveMath.ZERO) == 0) continue;
                retVal.add(i, col, addition);
            }
        });
        return retVal;
    }

    @Override
    public void reduceColumns(Aggregator aggregator, Mutate1D receiver) {
        if (aggregator == Aggregator.SUM && receiver instanceof Mutate1D.Modifiable) {
            if (this.isPrimitive()) {
                this.nonzeros().forEach(element -> ((Mutate2D.Modifiable)((Object)receiver)).add(element.column(), element.doubleValue()));
            } else {
                this.nonzeros().forEach(element -> ((Mutate2D.Modifiable)((Object)receiver)).add(element.column(), (Comparable)element.get()));
            }
        } else {
            super.reduceColumns(aggregator, receiver);
        }
    }

    @Override
    public void reduceRows(Aggregator aggregator, Mutate1D receiver) {
        if (aggregator == Aggregator.SUM && receiver instanceof Mutate1D.Modifiable) {
            if (this.isPrimitive()) {
                this.nonzeros().forEach(element -> ((Mutate2D.Modifiable)((Object)receiver)).add(element.row(), element.doubleValue()));
            } else {
                this.nonzeros().forEach(element -> ((Mutate2D.Modifiable)((Object)receiver)).add(element.row(), (Comparable)element.get()));
            }
        } else {
            super.reduceColumns(aggregator, receiver);
        }
    }

    @Override
    public TransformableRegion<N> regionByColumns(int ... columns) {
        return new Subregion2D.ColumnsRegion<N>(this, this.myMultiplyer, columns);
    }

    @Override
    public TransformableRegion<N> regionByLimits(int rowLimit, int columnLimit) {
        return new Subregion2D.LimitRegion<N>(this, this.myMultiplyer, rowLimit, columnLimit);
    }

    @Override
    public TransformableRegion<N> regionByOffsets(int rowOffset, int columnOffset) {
        return new Subregion2D.OffsetRegion<N>(this, this.myMultiplyer, rowOffset, columnOffset);
    }

    @Override
    public TransformableRegion<N> regionByRows(int ... rows) {
        return new Subregion2D.RowsRegion<N>(this, this.myMultiplyer, rows);
    }

    @Override
    public TransformableRegion<N> regionByTransposing() {
        return new Subregion2D.TransposedRegion<N>(this, this.myMultiplyer);
    }

    @Override
    public void reset() {
        this.myElements.reset();
        Arrays.fill(this.myFirsts, this.getColDim());
        Arrays.fill(this.myLimits, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long row, long col, Comparable<?> value) {
        SparseArray<N> sparseArray = this.myElements;
        synchronized (sparseArray) {
            this.myElements.set(Structure2D.index(this.myFirsts.length, row, col), value);
        }
        this.updateNonZeros(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long row, long col, double value) {
        SparseArray<N> sparseArray = this.myElements;
        synchronized (sparseArray) {
            this.myElements.set(Structure2D.index(this.myFirsts.length, row, col), value);
        }
        this.updateNonZeros(row, col);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
        this.myElements.supplyNonZerosTo(receiver);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<N> visitor) {
        long structure = this.countRows();
        long first = Structure2D.index(structure, row, col);
        long limit = Structure2D.index(structure, 0L, col + 1L);
        this.myElements.visitRange(first, limit, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<N> visitor) {
        int counter = 0;
        if (this.isPrimitive()) {
            for (ElementView2D nzv : this.nonzeros()) {
                if (nzv.row() != row) continue;
                visitor.accept(nzv.doubleValue());
                ++counter;
            }
        } else {
            for (ElementView2D nzv : this.nonzeros()) {
                if (nzv.row() != row) continue;
                visitor.accept((Comparable)nzv.get());
                ++counter;
            }
        }
        if (col + (long)counter < this.countColumns()) {
            visitor.accept(0.0);
        }
    }

    private void updateNonZeros(long row, long col) {
        this.updateNonZeros((int)row, (int)col);
    }

    SparseArray<N> getElements() {
        return this.myElements;
    }

    void updateNonZeros(int row, int col) {
        this.myFirsts[row] = Math.min(col, this.myFirsts[row]);
        this.myLimits[row] = Math.max(col + 1, this.myLimits[row]);
    }

    public static final class Factory<N extends Comparable<N>>
    implements Factory2D<SparseStore<N>> {
        private final PhysicalStore.Factory<N, ?> myPhysicalFactory;

        Factory(PhysicalStore.Factory<N, ?> physicalFactory) {
            this.myPhysicalFactory = physicalFactory;
        }

        @Override
        public FunctionSet<?> function() {
            return this.myPhysicalFactory.function();
        }

        @Override
        public SparseStore<N> make(long rows, long columns) {
            return SparseStore.makeSparse(this.myPhysicalFactory, rows, columns);
        }

        @Override
        public Scalar.Factory<?> scalar() {
            return this.myPhysicalFactory.scalar();
        }

        @Override
        public MathType getMathType() {
            return this.myPhysicalFactory.getMathType();
        }
    }
}

