/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.util.function.Supplier;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.AbstractDeterminator;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public interface DeterminantTask<N extends Comparable<N>>
extends MatrixTask<N> {
    public static final Factory<ComplexNumber> C128 = new Factory<ComplexNumber>(){

        @Override
        public DeterminantTask<ComplexNumber> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.C128.make(template);
            }
            return (DeterminantTask)LU.C128.make(template);
        }
    };
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    public static final Factory<Double> R064 = new Factory<Double>(){

        @Override
        public DeterminantTask<Double> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            long nbRows = template.countRows();
            if (nbRows == 1L) {
                return AbstractDeterminator.FULL_1X1;
            }
            if (symmetric) {
                if (nbRows == 2L) {
                    return AbstractDeterminator.SYMMETRIC_2X2;
                }
                if (nbRows == 3L) {
                    return AbstractDeterminator.SYMMETRIC_3X3;
                }
                if (nbRows == 4L) {
                    return AbstractDeterminator.SYMMETRIC_4X4;
                }
                if (nbRows == 5L) {
                    return AbstractDeterminator.SYMMETRIC_5X5;
                }
                return positiveDefinite ? (DeterminantTask)Cholesky.R064.make(template) : (DeterminantTask)LU.R064.make(template);
            }
            if (nbRows == 2L) {
                return AbstractDeterminator.FULL_2X2;
            }
            if (nbRows == 3L) {
                return AbstractDeterminator.FULL_3X3;
            }
            if (nbRows == 4L) {
                return AbstractDeterminator.FULL_4X4;
            }
            if (nbRows == 5L) {
                return AbstractDeterminator.FULL_5X5;
            }
            return (DeterminantTask)LU.R064.make(template);
        }
    };
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    public static final Factory<Quadruple> R128 = new Factory<Quadruple>(){

        @Override
        public DeterminantTask<Quadruple> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.R128.make(template);
            }
            return (DeterminantTask)LU.R128.make(template);
        }
    };
    @Deprecated
    public static final Factory<Quadruple> QUADRUPLE = R128;
    public static final Factory<Quaternion> H256 = new Factory<Quaternion>(){

        @Override
        public DeterminantTask<Quaternion> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.H256.make(template);
            }
            return (DeterminantTask)LU.H256.make(template);
        }
    };
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    public static final Factory<RationalNumber> Q128 = new Factory<RationalNumber>(){

        @Override
        public DeterminantTask<RationalNumber> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (DeterminantTask)Cholesky.Q128.make(template);
            }
            return (DeterminantTask)LU.Q128.make(template);
        }
    };
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    public N calculateDeterminant(Access2D<?> var1);

    default public Provider2D.Determinant<N> toDeterminantProvider(ElementsSupplier<N> original, Supplier<MatrixStore<N>> alternativeOriginalSupplier) {
        Object determinant = this.calculateDeterminant((Access2D)alternativeOriginalSupplier.get());
        return () -> determinant;
    }

    public static abstract class Factory<N extends Comparable<N>> {
        public final DeterminantTask<N> make(final int dim, boolean symmetric) {
            Structure2D template = new Structure2D(){

                @Override
                public long countColumns() {
                    return dim;
                }

                @Override
                public long countRows() {
                    return dim;
                }
            };
            return this.make(template, symmetric, false);
        }

        public final DeterminantTask<N> make(MatrixStore<N> template) {
            return this.make(template, template.isHermitian(), false);
        }

        public abstract DeterminantTask<N> make(Structure2D var1, boolean var2, boolean var3);
    }
}

