/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.util.Optional;
import java.util.function.Supplier;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.AbstractInverter;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public interface InverterTask<N extends Comparable<N>>
extends MatrixTask<N> {
    public static final Factory<ComplexNumber> C128 = new Factory<ComplexNumber>(){

        @Override
        public InverterTask<ComplexNumber> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (InverterTask)Cholesky.C128.make(template);
            }
            if (template.isSquare()) {
                return (InverterTask)LU.C128.make(template);
            }
            if (template.isTall()) {
                return QR.C128.make(template);
            }
            return SingularValue.C128.make(template);
        }
    };
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    public static final Factory<Double> R064 = new Factory<Double>(){

        @Override
        public InverterTask<Double> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            long nbRows = template.countRows();
            if (symmetric) {
                if (nbRows == 1L) {
                    return AbstractInverter.FULL_1X1;
                }
                if (nbRows == 2L) {
                    return AbstractInverter.SYMMETRIC_2X2;
                }
                if (nbRows == 3L) {
                    return AbstractInverter.SYMMETRIC_3X3;
                }
                if (nbRows == 4L) {
                    return AbstractInverter.SYMMETRIC_4X4;
                }
                if (nbRows == 5L) {
                    return AbstractInverter.SYMMETRIC_5X5;
                }
                return positiveDefinite ? (InverterTask)Cholesky.R064.make(template) : (InverterTask)LU.R064.make(template);
            }
            if (template.isSquare()) {
                if (nbRows == 1L) {
                    return AbstractInverter.FULL_1X1;
                }
                if (nbRows == 2L) {
                    return AbstractInverter.FULL_2X2;
                }
                if (nbRows == 3L) {
                    return AbstractInverter.FULL_3X3;
                }
                if (nbRows == 4L) {
                    return AbstractInverter.FULL_4X4;
                }
                if (nbRows == 5L) {
                    return AbstractInverter.FULL_5X5;
                }
                return (InverterTask)LU.R064.make(template);
            }
            if (template.isTall()) {
                return QR.R064.make(template);
            }
            return SingularValue.R064.make(template);
        }
    };
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    public static final Factory<Quadruple> R128 = new Factory<Quadruple>(){

        @Override
        public InverterTask<Quadruple> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (template.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (InverterTask)Cholesky.R128.make(template);
                }
                return (InverterTask)LU.R128.make(template);
            }
            if (template.isTall()) {
                return QR.R128.make(template);
            }
            return SingularValue.R128.make(template);
        }
    };
    @Deprecated
    public static final Factory<Quadruple> QUADRUPLE = R128;
    public static final Factory<Quaternion> H256 = new Factory<Quaternion>(){

        @Override
        public InverterTask<Quaternion> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (template.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (InverterTask)Cholesky.H256.make(template);
                }
                return (InverterTask)LU.H256.make(template);
            }
            if (template.isTall()) {
                return QR.H256.make(template);
            }
            return SingularValue.H256.make(template);
        }
    };
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    public static final Factory<RationalNumber> Q128 = new Factory<RationalNumber>(){

        @Override
        public InverterTask<RationalNumber> make(Structure2D template, boolean symmetric, boolean positiveDefinite) {
            if (template.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (InverterTask)Cholesky.Q128.make(template);
                }
                return (InverterTask)LU.Q128.make(template);
            }
            if (template.isTall()) {
                return QR.Q128.make(template);
            }
            return SingularValue.Q128.make(template);
        }
    };
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    default public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        return this.invert(original, this.preallocate(original));
    }

    public MatrixStore<N> invert(Access2D<?> var1, PhysicalStore<N> var2) throws RecoverableCondition;

    default public PhysicalStore<N> preallocate(final int numberOfRows, final int numberOfColumns) {
        return this.preallocate(new Structure2D(){

            @Override
            public long countColumns() {
                return numberOfColumns;
            }

            @Override
            public long countRows() {
                return numberOfRows;
            }
        });
    }

    public PhysicalStore<N> preallocate(Structure2D var1);

    default public Provider2D.Inverse<Optional<MatrixStore<N>>> toInverseProvider(ElementsSupplier<N> original, Supplier<MatrixStore<N>> alternativeOriginalSupplier) {
        try {
            MatrixStore invert = this.invert((Access2D)alternativeOriginalSupplier.get());
            return () -> Optional.of(invert);
        }
        catch (RecoverableCondition cause) {
            return Optional::empty;
        }
    }

    public static abstract class Factory<N extends Comparable<N>> {
        public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
            return this.make(original, false, false).invert(original);
        }

        public InverterTask<N> make(final int dim, boolean spd) {
            Structure2D template = new Structure2D(){

                @Override
                public long countColumns() {
                    return dim;
                }

                @Override
                public long countRows() {
                    return dim;
                }
            };
            return this.make(template, spd, spd);
        }

        public InverterTask<N> make(MatrixStore<N> template) {
            return this.make(template, template.isHermitian(), false);
        }

        public abstract InverterTask<N> make(Structure2D var1, boolean var2, boolean var3);
    }
}

