/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.util.Optional;
import java.util.function.Supplier;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.matrix.Provider2D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.AbstractSolver;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quadruple;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public interface SolverTask<N extends Comparable<N>>
extends MatrixTask<N> {
    public static final Factory<ComplexNumber> C128 = new Factory<ComplexNumber>(){

        @Override
        public SolverTask<ComplexNumber> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.C128.make(templateBody);
                }
                return (SolverTask)LU.C128.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.C128.make(templateBody);
            }
            return SingularValue.C128.make(templateBody);
        }
    };
    @Deprecated
    public static final Factory<ComplexNumber> COMPLEX = C128;
    public static final Factory<Double> R064 = new Factory<Double>(){

        @Override
        public SolverTask<Double> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            boolean vectorRHS = templateRHS.countColumns() == 1L;
            long nbCols = templateBody.countColumns();
            if (templateBody.isSquare()) {
                if (symmetric) {
                    if (!vectorRHS) {
                        return positiveDefinite ? (SolverTask)Cholesky.R064.make(templateBody) : (SolverTask)LU.R064.make(templateBody);
                    }
                    if (nbCols == 1L) {
                        return AbstractSolver.FULL_1X1;
                    }
                    if (nbCols == 2L) {
                        return AbstractSolver.SYMMETRIC_2X2;
                    }
                    if (nbCols == 3L) {
                        return AbstractSolver.SYMMETRIC_3X3;
                    }
                    if (nbCols == 4L) {
                        return AbstractSolver.SYMMETRIC_4X4;
                    }
                    if (nbCols == 5L) {
                        return AbstractSolver.SYMMETRIC_5X5;
                    }
                    return positiveDefinite ? (SolverTask)Cholesky.R064.make(templateBody) : (SolverTask)LU.R064.make(templateBody);
                }
                if (!vectorRHS) {
                    return (SolverTask)LU.R064.make(templateBody);
                }
                if (nbCols == 1L) {
                    return AbstractSolver.FULL_1X1;
                }
                if (nbCols == 2L) {
                    return AbstractSolver.FULL_2X2;
                }
                if (nbCols == 3L) {
                    return AbstractSolver.FULL_3X3;
                }
                if (nbCols == 4L) {
                    return AbstractSolver.FULL_4X4;
                }
                if (nbCols == 5L) {
                    return AbstractSolver.FULL_5X5;
                }
                return (SolverTask)LU.R064.make(templateBody);
            }
            if (!templateBody.isTall()) {
                return SingularValue.R064.make(templateBody);
            }
            if (vectorRHS && nbCols <= 5L) {
                return AbstractSolver.LEAST_SQUARES;
            }
            return QR.R064.make(templateBody);
        }
    };
    @Deprecated
    public static final Factory<Double> PRIMITIVE = R064;
    public static final Factory<Quadruple> R128 = new Factory<Quadruple>(){

        @Override
        public SolverTask<Quadruple> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.R128.make(templateBody);
                }
                return (SolverTask)LU.R128.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.R128.make(templateBody);
            }
            return SingularValue.R128.make(templateBody);
        }
    };
    @Deprecated
    public static final Factory<Quadruple> QUADRUPLE = R128;
    public static final Factory<Quaternion> H256 = new Factory<Quaternion>(){

        @Override
        public SolverTask<Quaternion> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.H256.make(templateBody);
                }
                return (SolverTask)LU.H256.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.H256.make(templateBody);
            }
            return SingularValue.H256.make(templateBody);
        }
    };
    @Deprecated
    public static final Factory<Quaternion> QUATERNION = H256;
    public static final Factory<RationalNumber> Q128 = new Factory<RationalNumber>(){

        @Override
        public SolverTask<RationalNumber> make(Structure2D templateBody, Structure2D templateRHS, boolean symmetric, boolean positiveDefinite) {
            if (templateBody.isSquare()) {
                if (symmetric && positiveDefinite) {
                    return (SolverTask)Cholesky.Q128.make(templateBody);
                }
                return (SolverTask)LU.Q128.make(templateBody);
            }
            if (templateBody.isTall()) {
                return QR.Q128.make(templateBody);
            }
            return SingularValue.Q128.make(templateBody);
        }
    };
    @Deprecated
    public static final Factory<RationalNumber> RATIONAL = Q128;

    default public PhysicalStore<N> preallocate(final int numberOfEquations, final int numberOfVariables, final int numberOfSolutions) {
        Structure2D templateBody = new Structure2D(){

            @Override
            public long countColumns() {
                return numberOfVariables;
            }

            @Override
            public long countRows() {
                return numberOfEquations;
            }
        };
        Structure2D templateRHS = new Structure2D(){

            @Override
            public long countColumns() {
                return numberOfSolutions;
            }

            @Override
            public long countRows() {
                return numberOfEquations;
            }
        };
        return this.preallocate(templateBody, templateRHS);
    }

    public PhysicalStore<N> preallocate(Structure2D var1, Structure2D var2);

    default public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    public MatrixStore<N> solve(Access2D<?> var1, Access2D<?> var2, PhysicalStore<N> var3) throws RecoverableCondition;

    default public Provider2D.Solution<Optional<MatrixStore<N>>> toSolutionProvider(ElementsSupplier<N> body, Supplier<MatrixStore<N>> alternativeBodySupplier, Access2D<?> rhs) {
        try {
            MatrixStore solution = this.solve((Access2D)alternativeBodySupplier.get(), rhs);
            return r -> Optional.of(solution);
        }
        catch (RecoverableCondition cause) {
            return r -> Optional.empty();
        }
    }

    public static abstract class Factory<N extends Comparable<N>> {
        public SolverTask<N> make(final int numberOfEquations, final int numberOfVariables, final int numberOfSolutions, boolean symmetric, boolean positiveDefinite) {
            Structure2D templateBody = new Structure2D(){

                @Override
                public long countColumns() {
                    return numberOfVariables;
                }

                @Override
                public long countRows() {
                    return numberOfEquations;
                }
            };
            Structure2D templateRHS = new Structure2D(){

                @Override
                public long countColumns() {
                    return numberOfSolutions;
                }

                @Override
                public long countRows() {
                    return numberOfEquations;
                }
            };
            return this.make(templateBody, templateRHS, symmetric, positiveDefinite);
        }

        public SolverTask<N> make(MatrixStore<N> templateBody, MatrixStore<N> templateRHS) {
            return this.make(templateBody, templateRHS, templateBody.isHermitian(), false);
        }

        public abstract SolverTask<N> make(Structure2D var1, Structure2D var2, boolean var3, boolean var4);

        public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
            return this.make(body, rhs, false, false).solve(body, rhs);
        }
    }
}

