/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public interface InvertibleFactor<N extends Comparable<N>>
extends Structure2D {
    public static <N extends Comparable<N>> InvertibleFactor<N> identity(int dim) {
        return new IdentityFactor(dim);
    }

    default public void btran(Access2D.Collectable<N, ? super PhysicalStore<N>> lhs, PhysicalStore<N> solution) {
        lhs.supplyTo(solution);
        this.btran(solution);
    }

    public void btran(PhysicalStore<N> var1);

    default public void ftran(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> solution) {
        rhs.supplyTo(solution);
        this.ftran(solution);
    }

    public void ftran(PhysicalStore<N> var1);

    public static final class IdentityFactor<N extends Comparable<N>>
    implements InvertibleFactor<N> {
        private final int myDim;

        IdentityFactor(int dim) {
            this.myDim = dim;
        }

        @Override
        public void btran(PhysicalStore<N> arg) {
        }

        @Override
        public long countColumns() {
            return this.myDim;
        }

        @Override
        public long countRows() {
            return this.myDim;
        }

        @Override
        public void ftran(PhysicalStore<N> arg) {
        }
    }
}

