/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.Optional;
import org.ojalgo.netio.BasicLogger;

public final class CharacterRing
implements CharSequence,
Appendable,
BasicLogger.Buffer {
    public static int length = 65536;
    private final char[] myCharacters = new char[length];
    private char myCursor = '\u0000';

    public static RingLogger newRingLogger() {
        return new RingLogger();
    }

    @Override
    public CharacterRing append(char c) throws IOException {
        char c2 = this.myCursor;
        this.myCursor = (char)(c2 + '\u0001');
        this.myCharacters[c2] = c;
        return this;
    }

    @Override
    public CharacterRing append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public CharacterRing append(CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.myCharacters[(this.myCursor + index) % length];
    }

    @Override
    public void clear() {
        Arrays.fill(this.myCharacters, '\u0000');
        this.myCursor = '\u0000';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CharacterRing)) {
            return false;
        }
        CharacterRing other = (CharacterRing)obj;
        return Arrays.equals(this.myCharacters, other.myCharacters) && this.myCursor == other.myCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Appendable receiver) {
        try {
            Appendable appendable = receiver;
            synchronized (appendable) {
                char tmpChar;
                int cursor;
                int i;
                for (i = cursor = this.myCursor; i < length; ++i) {
                    tmpChar = this.myCharacters[i];
                    if (tmpChar == '\u0000') continue;
                    receiver.append(tmpChar);
                }
                for (i = 0; i < cursor; ++i) {
                    tmpChar = this.myCharacters[i];
                    if (tmpChar == '\u0000') continue;
                    receiver.append(tmpChar);
                }
                this.clear();
            }
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(BasicLogger receiver) {
        BasicLogger basicLogger = receiver;
        synchronized (basicLogger) {
            char tmpChar;
            int cursor;
            int i;
            for (i = cursor = this.myCursor; i < length; ++i) {
                tmpChar = this.myCharacters[i];
                if (tmpChar == '\u0000') continue;
                receiver.print(tmpChar);
            }
            for (i = 0; i < cursor; ++i) {
                tmpChar = this.myCharacters[i];
                if (tmpChar == '\u0000') continue;
                receiver.print(tmpChar);
            }
            this.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.myCharacters);
        return prime * result + this.myCursor;
    }

    public int indexOfFirst(char c) {
        int cursor;
        int i;
        int retVal = -1;
        for (i = cursor = this.myCursor; retVal < 0 && i < length; ++i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i - cursor;
        }
        for (i = 0; retVal < 0 && i < cursor; ++i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i + cursor;
        }
        return retVal;
    }

    public int indexOfLast(char c) {
        int i;
        int retVal = -1;
        char cursor = this.myCursor;
        for (i = cursor - '\u0001'; retVal < 0 && i >= 0; --i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i + cursor;
        }
        for (i = length - 1; retVal < 0 && i >= cursor; --i) {
            if (this.myCharacters[i] != c) continue;
            retVal = i - cursor;
        }
        return retVal;
    }

    @Override
    public int length() {
        return length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return CharBuffer.wrap(this, start, end);
    }

    @Override
    public String toString() {
        char cursor = this.myCursor;
        String firstPart = String.valueOf(this.myCharacters, cursor, length - cursor);
        String secondPart = String.valueOf(this.myCharacters, 0, cursor);
        return firstPart + secondPart;
    }

    char getCursor() {
        return this.myCursor;
    }

    public static final class RingLogger
    implements BasicLogger,
    BasicLogger.Buffer {
        private transient Formatter myFormatter;
        private final CharacterRing myRing = new CharacterRing();

        RingLogger() {
        }

        @Override
        public Optional<Writer> asWriter() {
            return Optional.empty();
        }

        @Override
        public void clear() {
            this.myRing.clear();
        }

        @Override
        public void flush(Appendable receiver) {
            this.myRing.flush(receiver);
        }

        @Override
        public void flush(BasicLogger receiver) {
            this.myRing.flush(receiver);
        }

        @Override
        public void print(boolean value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(byte value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(char value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(double value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(float value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(int value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(long value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(Object object) {
            try {
                this.myRing.append(String.valueOf(object));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(short value) {
            try {
                this.myRing.append(String.valueOf(value));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }

        @Override
        public void print(Throwable throwable) {
            throwable.printStackTrace();
        }

        @Override
        public void printf(String format, Object ... args) {
            if (this.myFormatter == null || this.myFormatter.locale() != Locale.getDefault()) {
                this.myFormatter = new Formatter(this.myRing);
            }
            this.myFormatter.format(Locale.getDefault(), format, args);
        }

        @Override
        public void println() {
            try {
                this.myRing.append('\n');
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }
    }
}

