/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.ojalgo.ProgrammingError;
import org.ojalgo.netio.ResourceLocator;

final class ResourceSpecification {
    private String myFragment = null;
    private String myHost = null;
    private String myPath = "";
    private int myPort = -1;
    private final ResourceLocator.KeyedValues myQuery = new ResourceLocator.KeyedValues();
    private String myScheme = "https";

    ResourceSpecification() {
    }

    ResourceSpecification(URI uri) {
        this.myScheme = uri.getScheme();
        this.myHost = uri.getHost();
        this.myPort = uri.getPort();
        this.myPath = uri.getPath();
        this.myQuery.parse(uri.getQuery());
    }

    ResourceSpecification(URL uri) {
        this.myScheme = uri.getProtocol();
        this.myHost = uri.getHost();
        this.myPort = uri.getPort();
        this.myPath = uri.getPath();
        this.myQuery.parse(uri.getQuery());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceSpecification)) {
            return false;
        }
        ResourceSpecification other = (ResourceSpecification)obj;
        if (this.myFragment == null ? other.myFragment != null : !this.myFragment.equals(other.myFragment)) {
            return false;
        }
        if (this.myHost == null ? other.myHost != null : !this.myHost.equals(other.myHost)) {
            return false;
        }
        if (this.myPath == null ? other.myPath != null : !this.myPath.equals(other.myPath)) {
            return false;
        }
        if (this.myPort != other.myPort || !this.myQuery.equals(other.myQuery)) {
            return false;
        }
        return !(this.myScheme == null ? other.myScheme != null : !this.myScheme.equals(other.myScheme));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myFragment == null ? 0 : this.myFragment.hashCode());
        result = 31 * result + (this.myHost == null ? 0 : this.myHost.hashCode());
        result = 31 * result + (this.myPath == null ? 0 : this.myPath.hashCode());
        result = 31 * result + this.myPort;
        result = 31 * result + this.myQuery.hashCode();
        return 31 * result + (this.myScheme == null ? 0 : this.myScheme.hashCode());
    }

    public String toString() {
        return this.toURI().toString();
    }

    String getQuery() {
        if (this.myQuery.isEmpty()) {
            return null;
        }
        return this.myQuery.toString();
    }

    String getQueryValue(String key) {
        return this.myQuery.get(key);
    }

    String putQueryEntry(String key, String value) {
        ProgrammingError.throwIfNull((Object)key);
        if (value != null) {
            return this.myQuery.put(key, value);
        }
        return this.myQuery.remove(key);
    }

    String removeQueryEntry(String key) {
        return this.myQuery.remove(key);
    }

    ResourceSpecification setFragment(String fragment) {
        this.myFragment = fragment;
        return this;
    }

    ResourceSpecification setHost(String host) {
        this.myHost = host;
        return this;
    }

    ResourceSpecification setPath(String path) {
        ProgrammingError.throwIfNull((Object)path);
        this.myPath = path;
        return this;
    }

    ResourceSpecification setPort(int port) {
        this.myPort = port;
        return this;
    }

    ResourceSpecification setQuery(String query) {
        this.myQuery.parse(query);
        return this;
    }

    ResourceSpecification setScheme(String scheme) {
        this.myScheme = scheme;
        return this;
    }

    URI toURI() {
        try {
            return new URI(this.myScheme, null, this.myHost, this.myPort, this.myPath, this.getQuery(), this.myFragment);
        }
        catch (URISyntaxException cause) {
            throw new RuntimeException(cause);
        }
    }

    URL toURL() {
        try {
            return this.toURI().toURL();
        }
        catch (MalformedURLException cause) {
            throw new RuntimeException(cause);
        }
    }
}

