/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.ArrayR256;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.integer.IntegerStrategy;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public interface Optimisation {

    public static enum State implements Optimisation
    {
        APPROXIMATE(8),
        DISTINCT(256),
        FAILED(-1),
        FEASIBLE(16),
        INFEASIBLE(-8),
        INVALID(-2),
        OPTIMAL(64),
        UNBOUNDED(-32),
        UNEXPLORED(0),
        VALID(4);

        private final int myValue;

        private State(int aValue) {
            this.myValue = aValue;
        }

        public boolean isApproximate() {
            return this == APPROXIMATE || this.isFeasible();
        }

        public boolean isDistinct() {
            return this.absValue() >= DISTINCT.absValue();
        }

        public boolean isFailure() {
            return this.myValue < 0;
        }

        public boolean isFeasible() {
            return this.absValue() >= FEASIBLE.absValue();
        }

        public boolean isOptimal() {
            return this.absValue() >= OPTIMAL.absValue();
        }

        public boolean isSuccess() {
            return this.myValue > 0;
        }

        public boolean isUnexplored() {
            return this.myValue == 0;
        }

        public boolean isValid() {
            return this.absValue() >= VALID.absValue();
        }

        private int absValue() {
            return Math.abs(this.myValue);
        }
    }

    public static interface SolverData<N extends Comparable<N>>
    extends ProblemStructure {
    }

    public static interface Solver
    extends Optimisation {
        default public void dispose() {
        }

        default public Result solve() {
            return this.solve(null);
        }

        public Result solve(Result var1);
    }

    public static enum Sense implements Optimisation
    {
        MAX,
        MIN;

    }

    public static final class Result
    implements Optimisation,
    Access1D<BigDecimal>,
    Comparable<Result> {
        private transient Access1D<?> myMultipliers = null;
        private final Access1D<?> mySolution;
        private final State myState;
        private final double myValue;

        public static Result of(double value, State state, double ... solution) {
            return new Result(state, value, ArrayR064.wrap(solution));
        }

        public static Result of(State state, double ... solution) {
            return new Result(state, Double.NaN, Access1D.wrap(solution));
        }

        public static Result parse(String result) {
            int indexOfFirstSpace = result.indexOf(" ");
            int indexOfAtMark = result.indexOf(" @ ");
            String strState = result.substring(0, indexOfFirstSpace);
            String strValue = result.substring(indexOfFirstSpace + 1, indexOfAtMark);
            String[] strSolution = result.substring(indexOfAtMark + 5, result.length() - 2).split(", ");
            State state = State.valueOf(strState);
            double value = Double.parseDouble(strValue);
            ArrayR256 solution = ArrayR256.make(strSolution.length);
            for (int i = 0; i < strSolution.length; ++i) {
                solution.set((long)i, new BigDecimal(strSolution[i]));
            }
            return new Result(state, value, solution);
        }

        public Result(State state, Access1D<?> solution) {
            this(state, Double.NaN, solution);
        }

        public Result(State state, double value, Access1D<?> solution) {
            ProgrammingError.throwIfNull((Object)state, solution);
            this.myState = state;
            this.myValue = value;
            this.mySolution = solution;
        }

        public Result(State state, Result result) {
            this(state, result.getValue(), result);
        }

        @Override
        public int compareTo(Result reference) {
            return NumberContext.compare(this.myValue, reference.getValue());
        }

        @Override
        public long count() {
            return this.mySolution.count();
        }

        @Override
        public double doubleValue(long index) {
            return this.mySolution.doubleValue(index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            return this.myState == other.myState && Double.doubleToLongBits(this.myValue) == Double.doubleToLongBits(other.myValue);
        }

        @Override
        public BigDecimal get(long index) {
            return TypeUtils.toBigDecimal(this.mySolution.get(index));
        }

        public Optional<Access1D<?>> getMultipliers() {
            return Optional.ofNullable(this.myMultipliers);
        }

        public Result getSolution(NumberContext precision) {
            State state = this.getState();
            double value = this.getValue();
            ArrayR256 solution = ArrayR256.make(this.size());
            int limit = ((BigDecimal[])solution.data).length;
            for (int i = 0; i < limit; ++i) {
                solution.set((long)i, precision.enforce(this.get(i)));
            }
            return new Result(state, value, solution);
        }

        public State getState() {
            return this.myState;
        }

        public double getValue() {
            return this.myValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myState == null ? 0 : this.myState.hashCode());
            long temp = Double.doubleToLongBits(this.myValue);
            return 31 * result + (int)(temp ^ temp >>> 32);
        }

        public Result multipliers(Access1D<?> multipliers) {
            this.myMultipliers = multipliers;
            return this;
        }

        @Override
        public int size() {
            return (int)this.count();
        }

        public String toString() {
            return this.myState + " " + this.myValue + " @ " + Access1D.toString(this.mySolution);
        }

        public Result withState(State state) {
            return new Result(state, this.myValue, this.mySolution);
        }
    }

    public static interface ProblemStructure
    extends Optimisation {
        public int countAdditionalConstraints();

        public int countConstraints();

        public int countEqualityConstraints();

        public int countInequalityConstraints();

        public int countVariables();
    }

    public static final class Options
    implements Optimisation {
        public NumberContext feasibility = NumberContext.of(12, 8);
        public int iterations_abort = Integer.MAX_VALUE;
        public int iterations_suffice = Integer.MAX_VALUE;
        public BasicLogger logger_appender = null;
        public boolean logger_detailed = true;
        public Class<? extends Solver> logger_solver = null;
        public NumberContext print = ModelEntity.PRINT;
        public NumberContext solution = NumberContext.ofScale(14).withMode(RoundingMode.HALF_DOWN);
        public Boolean sparse = null;
        public long time_abort = CalendarDateUnit.DAY.toDurationInMillis();
        public long time_suffice = CalendarDateUnit.HOUR.toDurationInMillis();
        public boolean validate = false;
        private Object myConfigurator = null;
        private ConvexSolver.Configuration myConvexConfiguration = new ConvexSolver.Configuration();
        private IntegerStrategy myIntegerStrategy = IntegerStrategy.DEFAULT;
        private LinearSolver.Configuration myLinearConfiguration = new LinearSolver.Configuration();

        public Options abort(CalendarDateDuration duration) {
            ProgrammingError.throwIfNull((Object)duration);
            this.time_abort = duration.toDurationInMillis();
            return this;
        }

        public ConvexSolver.Configuration convex() {
            return this.myConvexConfiguration;
        }

        public Options convex(ConvexSolver.Configuration configuration) {
            Objects.requireNonNull(configuration);
            this.myConvexConfiguration = configuration;
            return this;
        }

        public Options debug(Class<? extends Solver> solver) {
            this.logger_solver = solver;
            this.logger_appender = solver != null ? BasicLogger.DEBUG : null;
            this.logger_detailed = solver != null;
            this.validate = solver != null;
            return this;
        }

        public <T> Optional<T> getConfigurator(Class<T> type) {
            ProgrammingError.throwIfNull(type);
            if (this.myConfigurator != null && type.isInstance(this.myConfigurator)) {
                return Optional.of(this.myConfigurator);
            }
            return Optional.empty();
        }

        public IntegerStrategy integer() {
            return this.myIntegerStrategy;
        }

        public Options integer(IntegerStrategy strategy) {
            Objects.requireNonNull(strategy);
            this.myIntegerStrategy = strategy;
            return this;
        }

        public LinearSolver.Configuration linear() {
            return this.myLinearConfiguration;
        }

        public Options linear(LinearSolver.Configuration configuration) {
            Objects.requireNonNull(configuration);
            this.myLinearConfiguration = configuration;
            return this;
        }

        public Options progress(Class<? extends Solver> solver) {
            this.logger_solver = solver;
            this.logger_appender = solver != null ? BasicLogger.DEBUG : null;
            this.logger_detailed = false;
            this.validate = false;
            return this;
        }

        public void setConfigurator(Object configurator) {
            ProgrammingError.throwIfNull(configurator);
            this.myConfigurator = configurator;
        }

        public Options suffice(CalendarDateDuration duration) {
            ProgrammingError.throwIfNull((Object)duration);
            this.time_suffice = duration.toDurationInMillis();
            return this;
        }
    }

    public static interface Objective
    extends Optimisation {
        public BigDecimal getContributionWeight();

        public boolean isObjective();
    }

    public static interface Model
    extends Optimisation {
        default public void dispose() {
        }

        public Result maximise();

        public Result minimise();

        public boolean validate();
    }

    public static interface Integration<M extends Model, S extends Solver>
    extends Optimisation {
        public S build(M var1);

        public Result extractSolverState(M var1);

        public boolean isCapable(M var1);

        public Result toModelState(Result var1, M var2);

        public Result toSolverState(Result var1, M var2);
    }

    public static enum ConstraintType implements Optimisation
    {
        EQUALITY,
        LOWER,
        NONE,
        UPPER;

    }

    public static interface Constraint
    extends Optimisation {
        public BigDecimal getLowerLimit();

        public BigDecimal getUpperLimit();

        public boolean isConstraint();

        public boolean isEqualityConstraint();

        public boolean isLowerConstraint();

        public boolean isUpperConstraint();
    }
}

