/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.array.SparseArray;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.RowsSupplier;
import org.ojalgo.optimisation.OptimisationData;
import org.ojalgo.optimisation.convex.ConvexObjectiveFunction;
import org.ojalgo.structure.Access2D;

final class ConvexData<N extends Comparable<N>>
implements OptimisationData<N> {
    private final RowsSupplier<N> myAE;
    private final RowsSupplier<N> myAI;
    private final PhysicalStore<N> myBE;
    private final PhysicalStore<N> myBI;
    private final ConvexObjectiveFunction<N> myObjective;

    ConvexData(PhysicalStore.Factory<N, ?> factory, int nbVars, int nbEqus, int nbIneq) {
        this.myObjective = new ConvexObjectiveFunction<N>(factory, nbVars);
        this.myAE = factory.makeRowsSupplier(nbVars);
        this.myAE.addRows(nbEqus);
        this.myBE = (PhysicalStore)factory.make(nbEqus, 1);
        this.myAI = factory.makeRowsSupplier(nbVars);
        this.myAI.addRows(nbIneq);
        this.myBI = (PhysicalStore)factory.make(nbIneq, 1);
    }

    @Override
    public int countAdditionalConstraints() {
        return 0;
    }

    @Override
    public int countConstraints() {
        return this.countEqualityConstraints() + this.countInequalityConstraints();
    }

    @Override
    public int countEqualityConstraints() {
        return this.myAE != null ? this.myAE.getRowDim() : 0;
    }

    @Override
    public int countInequalityConstraints() {
        return this.myAI != null ? this.myAI.getRowDim() : 0;
    }

    @Override
    public int countVariables() {
        return this.myObjective.arity();
    }

    @Override
    public PhysicalStore<N> getAE() {
        return this.myAE.get();
    }

    @Override
    public SparseArray<N> getAE(int row) {
        return this.myAE.getRow(row);
    }

    @Override
    public RowsSupplier<N> getAE(int ... rows) {
        return this.myAE.selectRows(rows);
    }

    @Override
    public PhysicalStore<N> getAI() {
        return this.myAI.get();
    }

    @Override
    public SparseArray<N> getAI(int row) {
        return this.myAI.getRow(row);
    }

    @Override
    public RowsSupplier<N> getAI(int ... rows) {
        return this.myAI.selectRows(rows);
    }

    @Override
    public MatrixStore<N> getBE() {
        return this.myBE;
    }

    @Override
    public double getBE(int row) {
        return this.myBE.doubleValue(row);
    }

    @Override
    public MatrixStore<N> getBI() {
        return this.myBI;
    }

    @Override
    public double getBI(int row) {
        return this.myBI.doubleValue(row);
    }

    @Override
    public ConvexObjectiveFunction<N> getObjective() {
        return this.myObjective;
    }

    @Override
    public <T extends MultiaryFunction.TwiceDifferentiable<N>> T getObjective(Class<T> type) {
        return null;
    }

    @Override
    public Access2D.RowView<N> getRowsAE() {
        return this.myAE.rows();
    }

    @Override
    public Access2D.RowView<N> getRowsAI() {
        return this.myAI.rows();
    }

    @Override
    public void reset() {
    }

    void addObjective(int row, Comparable<?> value) {
        this.myObjective.linear().add((long)row, 0L, value);
    }

    void addObjective(int row, double value) {
        this.myObjective.linear().add((long)row, 0L, value);
    }

    void addObjective(int row, int col, Comparable<?> value) {
        this.myObjective.quadratic().add((long)row, (long)col, value);
    }

    void addObjective(int row, int col, double value) {
        this.myObjective.quadratic().add((long)row, (long)col, value);
    }

    void setAE(int row, int col, Comparable<?> value) {
        this.myAE.getRow(row).set((long)col, value);
    }

    void setAE(int row, int col, double value) {
        this.myAE.getRow(row).set((long)col, value);
    }

    void setAI(int row, int col, Comparable<?> value) {
        this.myAI.getRow(row).set((long)col, value);
    }

    void setAI(int row, int col, double value) {
        this.myAI.getRow(row).set((long)col, value);
    }

    void setBE(int row, Comparable<?> value) {
        this.myBE.set((long)row, 0L, value);
    }

    void setBE(int row, double value) {
        this.myBE.set((long)row, 0L, value);
    }

    void setBI(int row, Comparable<?> value) {
        this.myBI.set((long)row, 0L, value);
    }

    void setBI(int row, double value) {
        this.myBI.set((long)row, 0L, value);
    }

    void setObjective(int row, Comparable<?> value) {
        this.myObjective.linear().set((long)row, 0L, value);
    }

    void setObjective(int row, double value) {
        this.myObjective.linear().set((long)row, 0L, value);
    }

    void setObjective(int row, int col, Comparable<?> value) {
        this.myObjective.quadratic().set((long)row, (long)col, value);
    }

    void setObjective(int row, int col, double value) {
        this.myObjective.quadratic().set((long)row, (long)col, value);
    }

    @FunctionalInterface
    static interface ConvexDataFactory<N extends Comparable<N>> {
        public ConvexData<N> newInstance(int var1, int var2, int var3);
    }
}

