/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.linear.DualSimplexSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.optimisation.linear.LinearStructure;
import org.ojalgo.optimisation.linear.PhasedSimplexSolver;
import org.ojalgo.optimisation.linear.PrimalSimplexSolver;
import org.ojalgo.optimisation.linear.RevisedStore;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.optimisation.linear.TableauStore;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.EnumPartition;
import org.ojalgo.type.context.NumberContext;
import org.ojalgo.type.keyvalue.EntryPair;

abstract class SimplexStore
implements Optimisation.SolverData<Double> {
    private transient int[] myExcludedLower = null;
    private transient int[] myExcludedUnbounded = null;
    private transient int[] myExcludedUpper = null;
    private final double[] myLowerBounds;
    private final EnumPartition<ColumnState> myPartition;
    private final LinearStructure myStructure;
    private final List<String> myToStringList = new ArrayList<String>();
    private final double[] myUpperBounds;
    final int[] excluded;
    final int[] included;
    final int m;
    final int n;
    final LinearStructure meta;

    static SimplexStore build(ExpressionsBasedModel model) {
        return SimplexStore.build(model, SimplexStore::newInstance);
    }

    static <S extends SimplexStore> S build(ExpressionsBasedModel model, Function<LinearStructure, S> storeFactory) {
        double factor;
        int column;
        Expression expression;
        int i;
        Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
        List<Variable> freeVariables = model.getFreeVariables();
        ArrayList equalityConstraints = new ArrayList();
        ArrayList lowerConstraints = new ArrayList();
        ArrayList upperConstraints = new ArrayList();
        model.constraints().map(c -> c.compensate(fixedVariables)).forEach(constraint -> {
            if (constraint.isEqualityConstraint()) {
                equalityConstraints.add(constraint);
            } else {
                if (constraint.isLowerConstraint()) {
                    lowerConstraints.add(constraint);
                }
                if (constraint.isUpperConstraint()) {
                    upperConstraints.add(constraint);
                }
            }
        });
        Expression objective = model.objective().compensate(fixedVariables);
        int nbUpConstr = upperConstraints.size();
        int nbLoConstr = lowerConstraints.size();
        int nbEqConstr = equalityConstraints.size();
        int nbProbVars = freeVariables.size();
        int nbSlckVars = nbUpConstr + nbLoConstr;
        int nbArtiVars = nbEqConstr;
        LinearStructure structure = new LinearStructure(nbUpConstr, nbLoConstr, nbEqConstr, nbProbVars, 0, nbSlckVars, nbArtiVars);
        SimplexStore simplex = (SimplexStore)storeFactory.apply(structure);
        LinearStructure meta = simplex.meta;
        double[] lowerBounds = simplex.getLowerBounds();
        double[] upperBounds = simplex.getUpperBounds();
        Mutate2D mtrxA = simplex.constraintsBody();
        Mutate1D mtrxB = simplex.constraintsRHS();
        Mutate1D mtrxC = simplex.objective();
        for (i = 0; i < nbUpConstr; ++i) {
            expression = (Expression)upperConstraints.get(i);
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                column = model.indexOfFreeVariable(key);
                factor = expression.doubleValue(key, true);
                mtrxA.set((long)i, (long)column, factor);
            }
            mtrxA.set((long)i, (long)(nbProbVars + i), PrimitiveMath.ONE);
            mtrxB.set((long)i, expression.getUpperLimit(true, Double.POSITIVE_INFINITY));
            lowerBounds[nbProbVars + i] = PrimitiveMath.ZERO;
            upperBounds[nbProbVars + i] = Double.POSITIVE_INFINITY;
            meta.slack[i] = EntryPair.of(expression, Optimisation.ConstraintType.UPPER);
        }
        for (i = 0; i < nbLoConstr; ++i) {
            expression = (Expression)lowerConstraints.get(i);
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                column = model.indexOfFreeVariable(key);
                factor = expression.doubleValue(key, true);
                mtrxA.set((long)(nbUpConstr + i), (long)column, factor);
            }
            mtrxA.set((long)(nbUpConstr + i), (long)(nbProbVars + nbUpConstr + i), PrimitiveMath.ONE);
            mtrxB.set((long)(nbUpConstr + i), expression.getLowerLimit(true, Double.NEGATIVE_INFINITY));
            lowerBounds[nbProbVars + nbUpConstr + i] = Double.NEGATIVE_INFINITY;
            upperBounds[nbProbVars + nbUpConstr + i] = PrimitiveMath.ZERO;
            meta.slack[nbUpConstr + i] = EntryPair.of(expression, Optimisation.ConstraintType.LOWER);
        }
        for (i = 0; i < nbEqConstr; ++i) {
            expression = (Expression)equalityConstraints.get(i);
            for (Structure1D.IntIndex key : expression.getLinearKeySet()) {
                column = model.indexOfFreeVariable(key);
                factor = expression.doubleValue(key, true);
                mtrxA.set((long)(nbUpConstr + nbLoConstr + i), (long)column, factor);
            }
            mtrxA.set((long)(nbUpConstr + nbLoConstr + i), (long)(nbProbVars + nbSlckVars + i), PrimitiveMath.ONE);
            mtrxB.set((long)(nbUpConstr + nbLoConstr + i), expression.getUpperLimit(true, PrimitiveMath.ZERO));
            lowerBounds[nbProbVars + nbSlckVars + i] = PrimitiveMath.ZERO;
            upperBounds[nbProbVars + nbSlckVars + i] = PrimitiveMath.ZERO;
        }
        for (i = 0; i < nbProbVars; ++i) {
            Variable variable = freeVariables.get(i);
            lowerBounds[i] = variable.getLowerLimit(false, Double.NEGATIVE_INFINITY);
            upperBounds[i] = variable.getUpperLimit(false, Double.POSITIVE_INFINITY);
        }
        boolean negate = model.getOptimisationSense() == Optimisation.Sense.MAX;
        for (Structure1D.IntIndex key : objective.getLinearKeySet()) {
            double weight = objective.doubleValue(key, true);
            mtrxC.set((long)model.indexOfFreeVariable(key), negate ? -weight : weight);
        }
        return (S)simplex;
    }

    static SimplexStore build(LinearSolver.GeneralBuilder builder) {
        return SimplexStore.build(builder, SimplexStore::newInstance, new int[0]);
    }

    static <S extends SimplexStore> S build(LinearSolver.GeneralBuilder builder, Function<LinearStructure, S> storeFactory, int ... basis) {
        return builder.newSimplexStore(storeFactory, basis);
    }

    static SimplexStore newInstance(LinearStructure structure) {
        if (Math.max(structure.countModelVariables(), structure.countConstraints()) > 5000) {
            return new RevisedStore(structure);
        }
        return new TableauStore(structure);
    }

    SimplexStore(LinearStructure structure) {
        this.m = structure.countConstraints();
        this.n = structure.countVariablesTotally();
        this.myLowerBounds = new double[this.n];
        this.myUpperBounds = new double[this.n];
        this.excluded = Structure1D.newIncreasingRange(0, this.n - this.m);
        this.included = Structure1D.newIncreasingRange(this.n - this.m, this.m);
        this.myPartition = new EnumPartition<ColumnState>(this.n, ColumnState.LOWER);
        for (int j = 0; j < this.m; ++j) {
            this.myPartition.update(this.included[j], ColumnState.BASIS);
        }
        this.myStructure = structure;
        this.meta = structure;
    }

    @Override
    public int countAdditionalConstraints() {
        return 0;
    }

    @Override
    public int countConstraints() {
        return this.m;
    }

    @Override
    public int countEqualityConstraints() {
        return this.m;
    }

    @Override
    public int countInequalityConstraints() {
        return 0;
    }

    @Override
    public int countVariables() {
        return this.n;
    }

    public String toString() {
        this.myToStringList.clear();
        for (int i = 0; i < this.myPartition.size(); ++i) {
            this.myToStringList.add(this.myPartition.get(i).key());
        }
        return this.myToStringList.toString();
    }

    private SimplexStore basis(int index) {
        this.myPartition.update(index, ColumnState.BASIS);
        return this;
    }

    protected void pivot(SimplexSolver.IterDescr iteration) {
        SimplexSolver.ExitInfo exit = iteration.exit;
        SimplexSolver.EnterInfo enter = iteration.enter;
        this.updateBasis(exit.index, exit.to, enter.index);
    }

    protected void shiftColumn(int col, double shift) {
        int n = col;
        this.myLowerBounds[n] = this.myLowerBounds[n] - shift;
        int n2 = col;
        this.myUpperBounds[n2] = this.myUpperBounds[n2] - shift;
    }

    abstract void calculateDualDirection(SimplexSolver.ExitInfo var1);

    abstract void calculateIteration();

    abstract void calculateIteration(SimplexSolver.IterDescr var1);

    abstract void calculatePrimalDirection(SimplexSolver.EnterInfo var1);

    abstract Mutate2D constraintsBody();

    abstract Mutate1D constraintsRHS();

    abstract void copyBasicSolution(double[] var1);

    abstract void copyObjective();

    double[] extractSolution() {
        double[] retVal = new double[this.n];
        int[] lower = this.getExcludedLower();
        for (int i = 0; i < lower.length; ++i) {
            int j = lower[i];
            double value = this.getLowerBound(j);
            retVal[j] = Double.isFinite(value) ? value : PrimitiveMath.ZERO;
        }
        int[] upper = this.getExcludedUpper();
        for (int i = 0; i < upper.length; ++i) {
            int j = upper[i];
            double value = this.getUpperBound(j);
            retVal[j] = Double.isFinite(value) ? value : PrimitiveMath.ZERO;
        }
        this.copyBasicSolution(retVal);
        return retVal;
    }

    abstract double extractValue();

    ColumnState getColumnState(int index) {
        return this.myPartition.get(index);
    }

    abstract double getCost(int var1);

    int[] getExcludedLower() {
        int count = this.myPartition.count(ColumnState.LOWER);
        if (this.myExcludedLower == null || this.myExcludedLower.length != count) {
            this.myExcludedLower = new int[count];
        }
        this.myPartition.extract(ColumnState.LOWER, false, this.myExcludedLower);
        return this.myExcludedLower;
    }

    int[] getExcludedUnbounded() {
        int count = this.myPartition.count(ColumnState.UNBOUNDED);
        if (this.myExcludedUnbounded == null || this.myExcludedUnbounded.length != count) {
            this.myExcludedUnbounded = new int[count];
        }
        this.myPartition.extract(ColumnState.UNBOUNDED, false, this.myExcludedUnbounded);
        return this.myExcludedUnbounded;
    }

    int[] getExcludedUpper() {
        int count = this.myPartition.count(ColumnState.UPPER);
        if (this.myExcludedUpper == null || this.myExcludedUpper.length != count) {
            this.myExcludedUpper = new int[count];
        }
        this.myPartition.extract(ColumnState.UPPER, false, this.myExcludedUpper);
        return this.myExcludedUpper;
    }

    abstract double getInfeasibility(int var1);

    double getLowerBound(int index) {
        return this.myLowerBounds[index];
    }

    double[] getLowerBounds() {
        return this.myLowerBounds;
    }

    final double getLowerGap(int i) {
        double lb;
        double xi = this.getTableauRHS(i);
        if (xi > (lb = this.getLowerBound(this.included[i]))) {
            return xi - lb;
        }
        return PrimitiveMath.ZERO;
    }

    double getRange(int index) {
        return this.myUpperBounds[index] - this.myLowerBounds[index];
    }

    abstract double getReducedCost(int var1);

    abstract double getTableauElement(SimplexSolver.ExitInfo var1, int var2);

    abstract double getTableauElement(int var1, SimplexSolver.EnterInfo var2);

    abstract double getTableauRHS(int var1);

    double getUpperBound(int index) {
        return this.myUpperBounds[index];
    }

    double[] getUpperBounds() {
        return this.myUpperBounds;
    }

    final double getUpperGap(int i) {
        double xi = this.getTableauRHS(i);
        double ub = this.getUpperBound(this.included[i]);
        if (ub > xi) {
            return ub - xi;
        }
        return PrimitiveMath.ZERO;
    }

    boolean isPrintable() {
        return this.myStructure.countVariablesTotally() <= 32;
    }

    SimplexStore lower(int index) {
        this.myPartition.update(index, ColumnState.LOWER);
        return this;
    }

    final DualSimplexSolver newDualSimplexSolver(Optimisation.Options optimisationOptions, int ... basis) {
        DualSimplexSolver solver = new DualSimplexSolver(optimisationOptions, this);
        if (basis.length > 0) {
            solver.basis(basis);
        }
        return solver;
    }

    final PhasedSimplexSolver newPhasedSimplexSolver(Optimisation.Options optimisationOptions, int ... basis) {
        PhasedSimplexSolver solver = new PhasedSimplexSolver(optimisationOptions, this);
        if (basis.length > 0) {
            solver.basis(basis);
        }
        return solver;
    }

    final PrimalSimplexSolver newPrimalSimplexSolver(Optimisation.Options optimisationOptions, int ... basis) {
        PrimalSimplexSolver solver = new PrimalSimplexSolver(optimisationOptions, this);
        if (basis.length > 0) {
            solver.basis(basis);
        }
        return solver;
    }

    abstract Mutate1D objective();

    void resetBasis(int[] newBasis) {
        if (newBasis.length != this.m) {
            throw new IllegalStateException();
        }
        this.myPartition.fill(ColumnState.LOWER);
        for (int i = 0; i < newBasis.length; ++i) {
            this.myPartition.update(newBasis[i], ColumnState.BASIS);
            this.included[i] = newBasis[i];
        }
        this.myPartition.extract(ColumnState.BASIS, true, this.excluded);
    }

    abstract void restoreObjective();

    final LinearStructure structure() {
        return this.myStructure;
    }

    SimplexStore unbounded(int index) {
        this.myPartition.update(index, ColumnState.UNBOUNDED);
        return this;
    }

    void updateBasis(int exit, ColumnState exitToBound, int enter) {
        int inclExit = this.included[exit];
        int exclEnter = this.excluded[enter];
        if (exitToBound == ColumnState.LOWER) {
            this.lower(inclExit);
        } else if (exitToBound == ColumnState.UPPER) {
            this.upper(inclExit);
        } else {
            throw new IllegalArgumentException();
        }
        this.basis(exclEnter);
        this.included[exit] = exclEnter;
        this.excluded[enter] = inclExit;
    }

    SimplexStore upper(int index) {
        this.myPartition.update(index, ColumnState.UPPER);
        return this;
    }

    abstract Collection<Equation> generateCutCandidates(boolean[] var1, NumberContext var2, double var3);

    static enum ColumnState {
        BASIS('B'),
        LOWER('L'),
        UNBOUNDED('\u2013'),
        UPPER('U');

        private final String myKey;

        private ColumnState(char key) {
            this.myKey = String.valueOf(key);
        }

        String key() {
            return this.myKey;
        }
    }
}

