/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Access2D;

public final class Random1D {
    public final int length;
    private final MatrixStore<Double> myCholeskiedCorrelations;

    public static void setSeed(long seed) {
        Random1D.random().setSeed(seed);
    }

    private static Random random() {
        return ThreadLocalRandom.current();
    }

    public Random1D(Access2D<?> correlations) {
        Cholesky cholesky = (Cholesky)Cholesky.PRIMITIVE.make();
        cholesky.decompose(Primitive64Store.FACTORY.makeWrapper(correlations));
        this.myCholeskiedCorrelations = cholesky.getL();
        cholesky.reset();
        this.length = (int)this.myCholeskiedCorrelations.countRows();
    }

    public Random1D(int size) {
        this.myCholeskiedCorrelations = null;
        this.length = size;
    }

    private Random1D() {
        this(null);
    }

    public Array1D<Double> nextDouble() {
        Primitive64Store uncorrelated = (Primitive64Store)Primitive64Store.FACTORY.make(this.length, 1);
        for (int i = 0; i < this.length; ++i) {
            uncorrelated.set((long)i, 0L, Random1D.random().nextDouble());
        }
        if (this.myCholeskiedCorrelations != null) {
            return ((Primitive64Store)this.myCholeskiedCorrelations.multiply((Double)((Object)uncorrelated))).asList();
        }
        return uncorrelated.asList();
    }

    public Array1D<Double> nextGaussian() {
        Primitive64Store uncorrelated = (Primitive64Store)Primitive64Store.FACTORY.make(this.length, 1);
        for (int i = 0; i < this.length; ++i) {
            uncorrelated.set((long)i, 0L, Random1D.random().nextGaussian());
        }
        if (this.myCholeskiedCorrelations != null) {
            return ((Primitive64Store)this.myCholeskiedCorrelations.multiply((Double)((Object)uncorrelated))).asList();
        }
        return uncorrelated.asList();
    }

    public int size() {
        return this.length;
    }
}

