/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.scedasticity;

import java.util.Arrays;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.scedasticity.ARCH;
import org.ojalgo.random.scedasticity.AbstractScedasticity;
import org.ojalgo.structure.Access1D;

public final class GARCH
extends AbstractScedasticity {
    private final ARCH myARCH;
    private final double[] myVariances;
    private final double[] myWeights;

    public static GARCH estimate(Access1D<?> series, int p, int q) {
        SampleSet ss = SampleSet.wrap(series);
        double mean = ss.getMean();
        double variance = ss.getVariance();
        GARCH model = GARCH.newInstance(p, q);
        int dim = 10 * Math.max(p, q);
        Access1D<?> parameters = AbstractScedasticity.parameters(series, mean, dim);
        double base = variance / PrimitiveMath.TWELVE;
        double[] varianceWeights = new double[p];
        double[] errorWeights = new double[q];
        double totalErrorWeights = PrimitiveMath.ZERO;
        for (int i = 0; i < q; ++i) {
            double weight = ELEVEN_TWELFTHS * parameters.doubleValue(i);
            if (!(weight >= PrimitiveMath.ZERO)) continue;
            errorWeights[i] = weight;
            totalErrorWeights += errorWeights[i];
        }
        AbstractScedasticity.decreasing(varianceWeights, ELEVEN_TWELFTHS - totalErrorWeights);
        model.base(base);
        model.errorWeights(errorWeights);
        model.varianceWeights(varianceWeights);
        model.initialise(mean, variance);
        return model;
    }

    public static GARCH newInstance(int p, int q) {
        return GARCH.newInstance(p, q, PrimitiveMath.ZERO, DEFAULT_VARIANCE);
    }

    public static GARCH newInstance(int p, int q, double mean, double variance) {
        GARCH retVal = new GARCH(p, q);
        retVal.base(variance / PrimitiveMath.TWELVE);
        double[] errorWeights = new double[q];
        AbstractScedasticity.average(errorWeights, PrimitiveMath.ONE / PrimitiveMath.TWELVE);
        retVal.errorWeights(errorWeights);
        double[] varianceWeights = new double[p];
        AbstractScedasticity.decreasing(varianceWeights, PrimitiveMath.TEN / PrimitiveMath.TWELVE);
        retVal.varianceWeights(varianceWeights);
        retVal.initialise(mean, variance);
        return retVal;
    }

    public GARCH(int p, int q) {
        this.myARCH = new ARCH(q);
        this.myVariances = new double[p];
        this.myWeights = new double[p];
    }

    public GARCH base(double base) {
        this.myARCH.base(base);
        return this;
    }

    public GARCH errorWeights(double ... lagged) {
        this.myARCH.errorWeights(lagged);
        return this;
    }

    @Override
    public double getMean() {
        return this.myARCH.getMean();
    }

    @Override
    public double getVariance() {
        double retVal = this.myARCH.getVariance();
        int limit = Math.min(this.myWeights.length, this.myVariances.length);
        for (int i = 0; i < limit; ++i) {
            retVal += this.myWeights[i] * this.myVariances[i];
        }
        return retVal;
    }

    @Override
    public void initialise(double mean, double variance) {
        this.myARCH.initialise(mean, variance);
        Arrays.fill(this.myVariances, variance);
    }

    @Override
    public void update(double value) {
        double variance = this.getVariance();
        this.myARCH.update(value);
        for (int i = this.myVariances.length - 1; i > 0; --i) {
            this.myVariances[i] = this.myVariances[i - 1];
        }
        this.myVariances[0] = variance;
    }

    public GARCH varianceWeights(double ... lagged) {
        Arrays.fill(this.myWeights, PrimitiveMath.ZERO);
        int limit = Math.min(this.myWeights.length, lagged.length);
        for (int i = 0; i < limit; ++i) {
            double tmpVal = lagged[i];
            if (tmpVal < PrimitiveMath.ZERO) {
                throw new IllegalArgumentException();
            }
            this.myWeights[i] = tmpVal;
        }
        return this;
    }
}

