/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series.primitive;

import java.util.Calendar;
import java.util.Date;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.series.primitive.PrimitiveTimeSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class ImplicitTimeSeries
extends PrimitiveTimeSeries {
    private final CalendarDateUnit myResolution;
    private final CalendarDate myFirst;

    public ImplicitTimeSeries(Calendar first, CalendarDateUnit resolution, PrimitiveSeries valueSeries) {
        super(valueSeries);
        this.myFirst = CalendarDate.make(first, (CalendarDate.Resolution)resolution);
        this.myResolution = resolution;
    }

    public ImplicitTimeSeries(CalendarDate first, CalendarDateUnit resolution, PrimitiveSeries valueSeries) {
        super(valueSeries);
        this.myFirst = first.filter(resolution);
        this.myResolution = resolution;
    }

    public ImplicitTimeSeries(Date first, CalendarDateUnit resolution, PrimitiveSeries valueSeries) {
        super(valueSeries);
        this.myFirst = CalendarDate.make(first, (CalendarDate.Resolution)resolution);
        this.myResolution = resolution;
    }

    @Override
    public ImplicitTimeSeries add(double addend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.add(addend));
    }

    @Override
    public ImplicitTimeSeries add(PrimitiveSeries addend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.add(addend));
    }

    @Override
    public ImplicitTimeSeries copy() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.copy());
    }

    @Override
    public ImplicitTimeSeries differences() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.differences());
    }

    @Override
    public ImplicitTimeSeries differences(int period) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.differences(period));
    }

    @Override
    public ImplicitTimeSeries divide(double divisor) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.divide(divisor));
    }

    @Override
    public ImplicitTimeSeries divide(PrimitiveSeries divisor) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.divide(divisor));
    }

    @Override
    public PrimitiveSeries exp() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.exp());
    }

    @Override
    public CalendarDate first() {
        return this.myFirst;
    }

    @Override
    public long getAverageStepSize() {
        return this.myResolution.toDurationInMillis();
    }

    @Override
    public long[] keys() {
        long[] retVal = new long[this.size()];
        CalendarDate tmpKey = this.myFirst;
        retVal[0] = tmpKey.millis;
        for (int t = 1; t < retVal.length; ++t) {
            tmpKey = tmpKey.step(this.myResolution);
            retVal[t] = tmpKey.millis;
        }
        return retVal;
    }

    @Override
    public CalendarDate last() {
        return this.myFirst.step(this.size() - 1, this.myResolution);
    }

    @Override
    public PrimitiveSeries log() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.log());
    }

    @Override
    public ImplicitTimeSeries multiply(double aFactor) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.multiply(aFactor));
    }

    @Override
    public ImplicitTimeSeries multiply(PrimitiveSeries multiplicand) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.multiply(multiplicand));
    }

    @Override
    public ImplicitTimeSeries quotients() {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.quotients());
    }

    @Override
    public ImplicitTimeSeries quotients(int period) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.quotients(period));
    }

    public CalendarDateUnit resolution() {
        return this.myResolution;
    }

    @Override
    public ImplicitTimeSeries runningProduct(double initialValue) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.runningProduct(initialValue));
    }

    @Override
    public ImplicitTimeSeries runningSum(double initialValue) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.runningSum(initialValue));
    }

    @Override
    public ImplicitTimeSeries subtract(double subtrahend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.subtract(subtrahend));
    }

    @Override
    public ImplicitTimeSeries subtract(PrimitiveSeries subtrahend) {
        return new ImplicitTimeSeries(this.first(), this.resolution(), super.subtract(subtrahend));
    }
}

