/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.text.Format;
import org.ojalgo.ProgrammingError;
import org.ojalgo.type.context.FormatContext;
import org.ojalgo.type.format.StringFormat;

public final class StringContext
extends FormatContext<String> {
    private static final Format DEFAULT_FORMAT = new StringFormat();
    private final int myLength;

    public StringContext() {
        super(DEFAULT_FORMAT);
        this.myLength = 0;
    }

    public StringContext(Format format, int length) {
        super(format);
        this.myLength = length;
    }

    public StringContext(int length) {
        super(DEFAULT_FORMAT);
        this.myLength = length;
    }

    private StringContext(Format format) {
        super(format);
        this.myLength = 0;
        ProgrammingError.throwForIllegalInvocation();
    }

    @Override
    public String enforce(String object) {
        Object retVal = object.trim();
        int tmpLength = ((String)retVal).length();
        if (this.myLength > 1 && tmpLength > this.myLength) {
            retVal = ((String)retVal).substring(0, this.myLength - 1).trim() + "\u2026";
        }
        return retVal;
    }

    @Override
    protected void configureFormat(Format format, Object object) {
    }

    @Override
    protected String handleFormatException(Format format, Object object) {
        return "";
    }

    @Override
    protected String handleParseException(Format format, String string) {
        return "";
    }
}

