/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.ojalgo.type.function.AutoSupplier;

final class MappedSupplier<IN, OUT>
implements AutoSupplier<OUT> {
    private final Function<IN, OUT> myMapper;
    private final Supplier<IN> mySupplier;
    private final Predicate<IN> myFilter;

    MappedSupplier(Supplier<IN> supplier, Function<IN, OUT> mapper) {
        this(supplier, in -> true, mapper);
    }

    MappedSupplier(Supplier<IN> supplier, Predicate<IN> filter, Function<IN, OUT> mapper) {
        this.mySupplier = supplier;
        this.myFilter = filter;
        this.myMapper = mapper;
    }

    @Override
    public void close() throws Exception {
        if (this.mySupplier instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.mySupplier)).close();
        }
    }

    @Override
    public OUT read() {
        Object unmapped = null;
        OUT retVal = null;
        while (true) {
            IN IN = this.mySupplier.get();
            unmapped = IN;
            if (IN == null) break;
            if (!this.myFilter.test(unmapped)) continue;
            OUT OUT = this.myMapper.apply(unmapped);
            retVal = OUT;
            if (OUT != null) break;
        }
        return retVal;
    }
}

