/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDBParamName_0_8;
import fr.profi.mzdb.db.model.MzDBParamName_0_9;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.model.params.param.CV;
import fr.profi.mzdb.db.model.params.param.CVTerm;
import fr.profi.mzdb.db.model.params.param.CVUnit;
import fr.profi.mzdb.db.model.params.param.UserTerm;
import fr.profi.mzdb.io.reader.MzDbReaderQueries;
import fr.profi.mzdb.io.reader.SharedParamTreeReader;
import fr.profi.mzdb.io.reader.cache.AbstractDataEncodingReader;
import fr.profi.mzdb.io.reader.cache.DataEncodingReader;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCache;
import fr.profi.mzdb.io.reader.cache.RunSliceHeaderReader;
import fr.profi.mzdb.io.reader.cache.SpectrumHeaderReader;
import fr.profi.mzdb.io.reader.iterator.BoundingBoxIterator;
import fr.profi.mzdb.io.reader.iterator.LcMsRunSliceIterator;
import fr.profi.mzdb.io.reader.iterator.LcMsnRunSliceIterator;
import fr.profi.mzdb.io.reader.iterator.SpectrumIterator;
import fr.profi.mzdb.io.reader.table.CvReader;
import fr.profi.mzdb.io.reader.table.CvTermReader;
import fr.profi.mzdb.io.reader.table.CvUnitReader;
import fr.profi.mzdb.io.reader.table.InstrumentConfigReader;
import fr.profi.mzdb.io.reader.table.MzDbHeaderReader;
import fr.profi.mzdb.io.reader.table.RunReader;
import fr.profi.mzdb.io.reader.table.SampleReader;
import fr.profi.mzdb.io.reader.table.SoftwareReader;
import fr.profi.mzdb.io.reader.table.SourceFileReader;
import fr.profi.mzdb.io.reader.table.UserTermReader;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.IonMobilityMode;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.RunSlice;
import fr.profi.mzdb.model.RunSliceData;
import fr.profi.mzdb.model.RunSliceHeader;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDbReader
extends AbstractMzDbReader {
    final Logger logger = LoggerFactory.getLogger(MzDbReader.class);
    private SQLiteConnection connection = null;
    private DataEncodingReader _dataEncodingReader;
    private SpectrumHeaderReader _spectrumHeaderReader;
    private RunSliceHeaderReader _runSliceHeaderReader;
    private MzDbHeaderReader _mzDbHeaderReader;
    private InstrumentConfigReader _instrumentConfigReader;
    private RunReader _runReader;
    private SampleReader _sampleReader;
    private SoftwareReader _softwareListReader;
    private SourceFileReader _sourceFileReader;
    private SharedParamTreeReader _sharedParamTreeReader;
    private CvReader _cvReader;
    private CvUnitReader _cvUnitReader;
    private CvTermReader _cvTermReader;
    private UserTermReader _userTermReader;

    public MzDbReader(File dbLocation, MzDbEntityCache entityCache, boolean logConnections) throws FileNotFoundException, SQLiteException {
        this.entityCache = entityCache;
        if (!logConnections) {
            java.util.logging.Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.OFF);
        }
        if (!dbLocation.exists()) {
            throw new FileNotFoundException("can't find the mzDB file at the given path: " + dbLocation);
        }
        this.dbLocation = dbLocation;
        this.connection = new SQLiteConnection(dbLocation);
        this.connection.openReadonly();
        this.connection.exec("PRAGMA synchronous=OFF;");
        this.connection.exec("PRAGMA journal_mode=OFF;");
        this.connection.exec("PRAGMA temp_store=2;");
        this.connection.exec("PRAGMA cache_size=-100000;");
        this.connection.exec("PRAGMA mmap_size=2147418112;");
        this._mzDbHeaderReader = new MzDbHeaderReader(this.connection);
        this._instrumentConfigReader = new InstrumentConfigReader(this.connection);
        this._runReader = new RunReader(this.connection);
        this._sampleReader = new SampleReader(this.connection);
        this._softwareListReader = new SoftwareReader(this.connection);
        this._sourceFileReader = new SourceFileReader(this.connection);
        this._sharedParamTreeReader = new SharedParamTreeReader(this.connection);
        this._cvReader = new CvReader(this.connection);
        this._cvTermReader = new CvTermReader(this.connection);
        this._cvUnitReader = new CvUnitReader(this.connection);
        this._userTermReader = new UserTermReader(this.connection);
        this._dataEncodingReader = new DataEncodingReader(this);
        this._spectrumHeaderReader = new SpectrumHeaderReader(this, (AbstractDataEncodingReader)this._dataEncodingReader);
        this._runSliceHeaderReader = new RunSliceHeaderReader(this);
        this.mzDbHeader = this._mzDbHeaderReader.getMzDbHeader();
        Software converterSoft = this.getMzdbConverter();
        String converterVersion = "";
        boolean isConverter09Compatible = false;
        if (converterSoft.getName().equals(ThermoConverterName) || converterSoft.getName().equals(TimsTofConverterName)) {
            converterVersion = converterSoft.getVersion();
            isConverter09Compatible = true;
        } else {
            converterVersion = converterSoft.getVersion();
        }
        this._paramNameGetter = isConverter09Compatible || converterVersion.compareTo("0.9.1") > 0 ? new MzDBParamName_0_9() : new MzDBParamName_0_8();
        this._setBBSizes(this._paramNameGetter);
    }

    public MzDbReader(File dbLocation, boolean cacheEntities) throws FileNotFoundException, SQLiteException {
        this(dbLocation, cacheEntities ? new MzDbEntityCache() : null, false);
    }

    public MzDbReader(String dbPath, boolean cacheEntities) throws FileNotFoundException, SQLiteException {
        this(new File(dbPath), cacheEntities ? new MzDbEntityCache() : null, false);
    }

    public SQLiteConnection getConnection() {
        return this.connection;
    }

    public SQLiteConnection setConnection(SQLiteConnection newConn) {
        this.connection = newConn;
        return this.connection;
    }

    @Override
    public void close() {
        this.connection.dispose();
    }

    @Override
    public DataEncodingReader getDataEncodingReader() {
        return this._dataEncodingReader;
    }

    @Override
    public SpectrumHeaderReader getSpectrumHeaderReader() {
        return this._spectrumHeaderReader;
    }

    @Override
    public RunSliceHeaderReader getRunSliceHeaderReader() {
        return this._runSliceHeaderReader;
    }

    public String getModelVersion() throws SQLiteException {
        return MzDbReaderQueries.getModelVersion(this.connection);
    }

    @Deprecated
    public String getPwizMzDbVersion() throws SQLiteException {
        return MzDbReaderQueries.getPwizMzDbVersion(this.connection);
    }

    public Software getMzdbConverter() throws SQLiteException {
        for (Software nextSoft : this.getSoftwareList()) {
            if (nextSoft.getName().endsWith("mzDB")) {
                return nextSoft;
            }
            if (nextSoft.getName().equals(ThermoConverterName)) {
                return nextSoft;
            }
            if (!nextSoft.getName().equals(TimsTofConverterName)) continue;
            return nextSoft;
        }
        return null;
    }

    public float getLastTime() throws SQLiteException {
        return MzDbReaderQueries.getLastTime(this.connection);
    }

    public int getMaxMsLevel() throws SQLiteException {
        return MzDbReaderQueries.getMaxMsLevel(this.connection);
    }

    public int[] getMzRange(int msLevel) throws SQLiteException {
        return MzDbReaderQueries.getMzRange(msLevel, this.connection);
    }

    public int getBoundingBoxesCount() throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxesCount(this.connection);
    }

    public int getBoundingBoxesCount(int runSliceId) throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxesCount(runSliceId, this.connection);
    }

    public int getCyclesCount() throws SQLiteException {
        return MzDbReaderQueries.getCyclesCount(this.connection);
    }

    public int getDataEncodingsCount() throws SQLiteException {
        return MzDbReaderQueries.getDataEncodingsCount(this.connection);
    }

    public int getSpectraCount() throws SQLiteException {
        return MzDbReaderQueries.getSpectraCount(this.connection);
    }

    public int getSpectraCount(int msLevel) throws SQLiteException {
        return MzDbReaderQueries.getSpectraCount(msLevel, this.connection);
    }

    public int getRunSlicesCount() throws SQLiteException {
        return MzDbReaderQueries.getRunSlicesCount(this.connection);
    }

    public int getTableRecordsCount(String tableName) throws SQLiteException {
        return MzDbReaderQueries.getTableRecordsCount(tableName, this.connection);
    }

    public DataEncoding getDataEncoding(long id) throws SQLiteException {
        return this._dataEncodingReader.getDataEncoding(id);
    }

    public Map<Long, DataEncoding> getDataEncodingBySpectrumId() throws SQLiteException {
        return this._dataEncodingReader.getDataEncodingBySpectrumId();
    }

    public DataEncoding getSpectrumDataEncoding(long spectrumId) throws SQLiteException {
        return this._dataEncodingReader.getSpectrumDataEncoding(spectrumId);
    }

    public RunSliceHeader[] getRunSliceHeaders(int msLevel) throws SQLiteException {
        return this._runSliceHeaderReader.getRunSliceHeaders(msLevel);
    }

    public HashMap<Integer, RunSliceHeader> getRunSliceHeaderById(int msLevel) throws SQLiteException {
        return this._runSliceHeaderReader.getRunSliceHeaderById(msLevel);
    }

    public RunSliceData getRunSliceData(int runSliceId) throws SQLiteException, StreamCorruptedException {
        return this.getRunSliceData(runSliceId, this.connection);
    }

    public byte[] getBoundingBoxData(int bbId) throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxData(bbId, this.connection);
    }

    public long getBoundingBoxFirstSpectrumId(long spectrumId) throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxFirstSpectrumId(spectrumId, this.connection);
    }

    public float getBoundingBoxMinMz(int bbId) throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxMinMz(bbId, this.connection);
    }

    public float getBoundingBoxMinTime(int bbId) throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxMinTime(bbId, this.connection);
    }

    public int getBoundingBoxMsLevel(int bbId) throws SQLiteException {
        return MzDbReaderQueries.getBoundingBoxMsLevel(bbId, this.connection);
    }

    public SpectrumHeader[] getMs1SpectrumHeaders() throws SQLiteException {
        return this._spectrumHeaderReader.getMs1SpectrumHeaders();
    }

    public Map<Long, SpectrumHeader> getMs1SpectrumHeaderById() throws SQLiteException {
        return this._spectrumHeaderReader.getMs1SpectrumHeaderById();
    }

    public SpectrumHeader[] getMs2SpectrumHeaders() throws SQLiteException {
        return this._spectrumHeaderReader.getMs2SpectrumHeaders();
    }

    public Map<Long, SpectrumHeader> getMs2SpectrumHeaderById() throws SQLiteException {
        return this._spectrumHeaderReader.getMs2SpectrumHeaderById();
    }

    public SpectrumHeader[] getSpectrumHeaders() throws SQLiteException {
        return this._spectrumHeaderReader.getSpectrumHeaders();
    }

    public Map<Long, SpectrumHeader> getSpectrumHeaderById() throws SQLiteException {
        return this._spectrumHeaderReader.getSpectrumHeaderById();
    }

    public SpectrumHeader getSpectrumHeader(long id) throws SQLiteException {
        return this._spectrumHeaderReader.getSpectrumHeader(id);
    }

    public SpectrumHeader getSpectrumHeaderForTime(float time, int msLevel) throws Exception {
        return this._spectrumHeaderReader.getSpectrumHeaderForTime(time, msLevel);
    }

    public SpectrumData getSpectrumData(long spectrumId) throws SQLiteException, StreamCorruptedException {
        return this.getSpectrumData(spectrumId, this.connection);
    }

    public Spectrum getSpectrum(long spectrumId) throws SQLiteException, StreamCorruptedException {
        return this.getSpectrum(spectrumId, this.connection);
    }

    public Peak[] getSpectrumPeaks(int spectrumId) throws SQLiteException, StreamCorruptedException {
        return this.getSpectrumPeaks(spectrumId, this.connection);
    }

    public SpectrumSlice[] getMsSpectrumSlices(double minMz, double maxMz, float minRt, float maxRt) throws SQLiteException, StreamCorruptedException {
        return this.getMsSpectrumSlices(minMz, maxMz, minRt, maxRt, this.connection);
    }

    public SpectrumSlice[] getMsnSpectrumSlices(double parentMz, double minFragMz, double maxFragMz, float minRt, float maxRt) throws SQLiteException, StreamCorruptedException {
        return this.getMsnSpectrumSlices(parentMz, minFragMz, maxFragMz, minRt, maxRt, this.connection);
    }

    public Iterator<BoundingBox> getBoundingBoxIterator(int msLevel) throws SQLiteException, StreamCorruptedException {
        SQLiteStatement stmt = this.connection.prepare("SELECT bounding_box.* FROM bounding_box, spectrum WHERE spectrum.id = bounding_box.first_spectrum_id AND spectrum.ms_level= ?", false);
        stmt.bind(1, msLevel);
        return new BoundingBoxIterator(this._spectrumHeaderReader, this._dataEncodingReader, this.connection, stmt, msLevel);
    }

    public Iterator<Spectrum> getSpectrumIterator() throws SQLiteException, StreamCorruptedException {
        return new SpectrumIterator(this, this.connection);
    }

    public Iterator<Spectrum> getSpectrumIterator(int msLevel) throws SQLiteException, StreamCorruptedException {
        return new SpectrumIterator(this, this.connection, msLevel);
    }

    public Iterator<RunSlice> getLcMsRunSliceIterator() throws SQLiteException, StreamCorruptedException {
        MzDbReader.readWholeFile(this.dbLocation);
        return new LcMsRunSliceIterator(this, this.connection);
    }

    private static void readWholeFile(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] b = new byte[0x100000];
            while (fis.available() != 0) {
                fis.read(b);
            }
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Iterator<RunSlice> getLcMsRunSliceIterator(double minRunSliceMz, double maxRunSliceMz) throws SQLiteException, StreamCorruptedException {
        return new LcMsRunSliceIterator(this, this.connection, minRunSliceMz, maxRunSliceMz);
    }

    public Iterator<RunSlice> getLcMsnRunSliceIterator(double minParentMz, double maxParentMz) throws SQLiteException, StreamCorruptedException {
        MzDbReader.readWholeFile(this.dbLocation);
        return new LcMsnRunSliceIterator(this, this.connection, minParentMz, maxParentMz);
    }

    public Iterator<RunSlice> getLcMsnRunSliceIterator(double minParentMz, double maxParentMz, double minRunSliceMz, double maxRunSliceMz) throws SQLiteException, StreamCorruptedException {
        return new LcMsnRunSliceIterator(this, this.connection, minParentMz, maxParentMz, minRunSliceMz, maxRunSliceMz);
    }

    public AcquisitionMode getAcquisitionMode() throws SQLiteException {
        return this.getAcquisitionMode(this.connection);
    }

    public IonMobilityMode getIonMobilityMode() throws SQLiteException {
        return this.getIonMobilityMode(this.connection);
    }

    public IsolationWindow[] getDIAIsolationWindows() throws SQLiteException {
        return this.getDIAIsolationWindows(this.connection);
    }

    @Override
    public List<InstrumentConfiguration> getInstrumentConfigurations() throws SQLiteException {
        if (this.instrumentConfigs == null) {
            this.instrumentConfigs = this._instrumentConfigReader.getInstrumentConfigList();
        }
        return this.instrumentConfigs;
    }

    public List<SharedParamTree> getSharedParamTreeList() throws SQLiteException {
        if (this.sharedParamTrees == null) {
            this.sharedParamTrees = this._sharedParamTreeReader.getSharedParamTreeList();
        }
        return this.sharedParamTrees;
    }

    public List<CV> getCvList() throws SQLiteException {
        if (this.allCVs == null) {
            this.allCVs = this._cvReader.getCvList();
        }
        return this.allCVs;
    }

    public List<CVUnit> getCvUnitList() throws SQLiteException {
        if (this.cvUnits == null) {
            this.cvUnits = this._cvUnitReader.getCvUnit();
        }
        return this.cvUnits;
    }

    public List<CVTerm> getCvTermList() throws SQLiteException {
        if (this.cvTerms == null) {
            this.cvTerms = this._cvTermReader.getCvTerms();
        }
        return this.cvTerms;
    }

    public List<UserTerm> getUserTermList() throws SQLiteException {
        if (this.userTerms == null) {
            this.userTerms = this._userTermReader.getUserTerms();
        }
        return this.userTerms;
    }

    @Override
    public List<Run> getRuns() throws SQLiteException {
        if (this.runs == null) {
            this.runs = this._runReader.getRunList();
        }
        return this.runs;
    }

    @Override
    public List<Sample> getSamples() throws SQLiteException {
        if (this.samples == null) {
            this.samples = this._sampleReader.getSampleList();
        }
        return this.samples;
    }

    @Override
    public List<Software> getSoftwareList() throws SQLiteException {
        if (this.softwareList == null) {
            this.softwareList = this._softwareListReader.getSoftwareList();
        }
        return this.softwareList;
    }

    @Override
    public List<SourceFile> getSourceFiles() throws SQLiteException {
        if (this.sourceFiles == null) {
            this.sourceFiles = this._sourceFileReader.getSourceFileList();
        }
        return this.sourceFiles;
    }

    public Peak[] getMsXicInMzRange(double minMz, double maxMz, XicMethod method) throws SQLiteException, StreamCorruptedException {
        return this.getMsXicInMzRange(minMz, maxMz, method, this.connection);
    }

    public Peak[] getMsXicInMzRtRanges(double minMz, double maxMz, float minRt, float maxRt, XicMethod method) throws SQLiteException, StreamCorruptedException {
        return this.getMsXicInMzRtRanges(minMz, maxMz, minRt, maxRt, method, this.connection);
    }

    public Peak[] getMsXic(double mz, double mzTolInDa, float minRt, float maxRt, int msLevel, XicMethod method) throws SQLiteException, StreamCorruptedException {
        return this.getMsXic(mz, mzTolInDa, minRt, maxRt, method, this.connection);
    }

    public Peak[] getMsnXIC(double parentMz, double fragmentMz, double fragmentMzTolInDa, float minRt, float maxRt, XicMethod method) throws SQLiteException, StreamCorruptedException {
        return this.getMsnXic(parentMz, fragmentMz, fragmentMzTolInDa, minRt, maxRt, method, this.connection);
    }

    public Peak[] getMsPeaksInMzRtRanges(double minMz, double maxMz, float minRt, float maxRt) throws SQLiteException, StreamCorruptedException {
        return this.getMsPeaksInMzRtRanges(minMz, maxMz, minRt, maxRt, this.connection);
    }

    public Peak[] getMsnPeaksInMzRtRanges(double parentMz, double minFragMz, double maxFragMz, float minRt, float maxRt) throws SQLiteException, StreamCorruptedException {
        return this.getMsnPeaksInMzRtRanges(parentMz, minFragMz, maxFragMz, minRt, maxRt, this.connection);
    }
}

