/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.db.model;

import fr.profi.mzdb.db.model.params.ComponentList;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import fr.profi.mzdb.util.misc.AbstractInMemoryIdGen;
import java.io.IOException;

public class InstrumentConfiguration
extends AbstractInMemoryIdGen
implements SerializationInterface {
    public static final String TABLE_NAME = "instrument_configuration";
    protected long id;
    protected String name;
    protected int softwareId;
    protected ParamTree paramTree;
    protected ComponentList componentList;

    public InstrumentConfiguration(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public InstrumentConfiguration(long id, String name, int softwareId, ParamTree paramTree, ComponentList comp) {
        this.id = id;
        this.name = name;
        this.softwareId = softwareId;
        this.paramTree = paramTree;
        this.componentList = comp;
    }

    public InstrumentConfiguration(long id, String name, int softwareId) {
        this(id, name, softwareId, null, null);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getSoftwareId() {
        return this.softwareId;
    }

    public ParamTree getParamTree() {
        return this.paramTree;
    }

    public ComponentList getComponentList() {
        return this.componentList;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        writer.writeInt64(this.id);
        writer.writeString(this.name);
        writer.writeInt32(this.softwareId);
        boolean hasData = this.paramTree != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.paramTree.write(writer);
        }
        hasData = this.componentList != null;
        writer.writeBoolean(hasData);
        if (hasData) {
            this.componentList.write(writer);
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        this.id = reader.readInt64();
        this.name = reader.readString();
        this.softwareId = reader.readInt32();
        boolean hasData = reader.readBoolean();
        this.paramTree = hasData ? new ParamTree(reader) : null;
        hasData = reader.readBoolean();
        this.componentList = hasData ? new ComponentList(reader) : null;
    }
}

