/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.iterator;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.io.reader.iterator.AbstractSpectrumSliceIterator;
import fr.profi.mzdb.model.BoundingBox;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.sqlite.ISQLiteStatementConsumer;
import java.io.StreamCorruptedException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class SpectrumIterator
extends AbstractSpectrumSliceIterator
implements Iterator<Spectrum> {
    private static String allMsLevelsSqlQuery = "SELECT bounding_box.* FROM bounding_box, spectrum WHERE spectrum.id = bounding_box.first_spectrum_id";
    private static String singleMsLevelSqlQuery = allMsLevelsSqlQuery + " AND spectrum.ms_level= ?";
    private static int PRIORITY_QUEUE_INITIAL_CAPACITY = 200;
    protected int spectrumSliceIdx;
    protected final boolean usePriorityQueue;
    private final PriorityQueue<Spectrum> priorityQueue;
    protected SpectrumSlice[] firstSpectrumSlices = null;
    protected SpectrumSlice[] spectrumSliceBuffer = null;
    protected boolean bbHasNext = true;

    public SpectrumIterator(AbstractMzDbReader mzDbReader, SQLiteConnection connection) throws SQLiteException, StreamCorruptedException {
        super(mzDbReader.getSpectrumHeaderReader(), mzDbReader.getDataEncodingReader(), connection, allMsLevelsSqlQuery);
        this.usePriorityQueue = true;
        this.priorityQueue = new PriorityQueue<Spectrum>(PRIORITY_QUEUE_INITIAL_CAPACITY, new Comparator<Spectrum>(){

            @Override
            public int compare(Spectrum s1, Spectrum s2) {
                return (int)(s1.getHeader().getId() - s2.getHeader().getId());
            }
        });
        this.initSpectrumSliceBuffer();
    }

    public SpectrumIterator(AbstractMzDbReader mzDbReader, SQLiteConnection connection, final int msLevel) throws SQLiteException, StreamCorruptedException {
        super(mzDbReader.getSpectrumHeaderReader(), mzDbReader.getDataEncodingReader(), connection, singleMsLevelSqlQuery, msLevel, new ISQLiteStatementConsumer(){

            @Override
            public void accept(SQLiteStatement stmt) throws SQLiteException {
                stmt.bind(1, msLevel);
            }
        });
        this.usePriorityQueue = false;
        this.priorityQueue = null;
        this.initSpectrumSliceBuffer();
    }

    protected void initSpectrumSliceBuffer() {
        this.spectrumSliceBuffer = this.firstSpectrumSlices != null ? this.firstSpectrumSlices : this.firstBB.toSpectrumSlices();
        this.spectrumSliceIdx = 0;
        boolean continueSlicesLoading = false;
        while (this.bbHasNext = this.boundingBoxIterator.hasNext()) {
            BoundingBox bb = (BoundingBox)this.boundingBoxIterator.next();
            SpectrumSlice[] sSlices = bb.toSpectrumSlices();
            if (sSlices == null) continue;
            if (sSlices[0].getSpectrumId() == this.spectrumSliceBuffer[0].getSpectrumId()) {
                for (int i = 0; i < sSlices.length; ++i) {
                    this.spectrumSliceBuffer[i].getData().addSpectrumData(sSlices[i].getData());
                }
                continue;
            }
            this.firstBB = bb;
            this.firstSpectrumSlices = sSlices;
            if (!this.usePriorityQueue) break;
            for (SpectrumSlice spectrum : this.spectrumSliceBuffer) {
                this.priorityQueue.add(spectrum);
            }
            SpectrumHeader curSpectrumHeader = this.spectrumSliceBuffer[0].getHeader();
            SpectrumHeader nextSpectrumHeader = sSlices[0].getHeader();
            int nextMsLevel = nextSpectrumHeader.getMsLevel();
            if (curSpectrumHeader.getCycle() != nextSpectrumHeader.getCycle() && curSpectrumHeader.getMsLevel() != nextMsLevel && nextMsLevel <= 1) break;
            continueSlicesLoading = true;
            break;
        }
        if (continueSlicesLoading) {
            this.initSpectrumSliceBuffer();
        }
    }

    @Override
    public Spectrum next() {
        int spectrumSliceIdxCopy = this.spectrumSliceIdx++;
        Spectrum spectrum = null;
        boolean noMoreSpectrum = false;
        if (this.usePriorityQueue) {
            spectrum = this.priorityQueue.poll();
            noMoreSpectrum = this.priorityQueue.isEmpty();
        } else {
            spectrum = this.spectrumSliceBuffer[spectrumSliceIdxCopy];
            boolean bl = noMoreSpectrum = this.spectrumSliceIdx == this.spectrumSliceBuffer.length;
        }
        if (noMoreSpectrum) {
            if (this.bbHasNext) {
                this.initSpectrumSliceBuffer();
            } else {
                this.firstBB = null;
            }
        }
        return spectrum;
    }
}

