/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.table.SoftwareTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.List;

public class SoftwareReader
extends AbstractTableModelReader<Software> {
    public SoftwareReader(SQLiteConnection connection) throws SQLiteException {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<Software> buildRecordExtractor() {
        return new ISQLiteRecordExtraction<Software>(){

            @Override
            public Software extract(SQLiteRecord r) throws SQLiteException {
                int id = r.columnInt(SoftwareTable.ID);
                String name = r.columnString(SoftwareTable.NAME);
                String version = r.columnString(SoftwareTable.VERSION);
                String paramTreeAsStr = r.columnString(SoftwareTable.PARAM_TREE);
                return new Software(id, name, version, ParamTreeParser.parseParamTree(paramTreeAsStr));
            }
        };
    }

    public Software getSoftware(int id) throws SQLiteException {
        return (Software)this.getRecord("software", id);
    }

    public List<Software> getSoftwareList() throws SQLiteException {
        return this.getRecordList("software");
    }
}

