/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.util;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDbHeader;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.model.params.param.CV;
import fr.profi.mzdb.db.model.params.param.CVTerm;
import fr.profi.mzdb.db.model.params.param.CVUnit;
import fr.profi.mzdb.db.model.params.param.UserTerm;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.ProcessingMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDBUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MzDBUtil.class);

    public static MzDBMetaData createMzDbMetaData(MzDbReader srcReader) throws SQLiteException {
        MzDbHeader mzdbHeader = srcReader.getMzDbHeader();
        ArrayList<DataEncoding> dataEncodings = new ArrayList<DataEncoding>(Arrays.asList(srcReader.getDataEncodingReader().getDataEncodings()));
        List<InstrumentConfiguration> instrumentConfigurations = srcReader.getInstrumentConfigurations();
        ArrayList<ProcessingMethod> processingMethods = new ArrayList<ProcessingMethod>();
        int processingMethodsNumber = 0;
        int processingMethodsid = 1;
        List<Software> softwares = srcReader.getSoftwareList();
        for (Software srcSoftware : softwares) {
            ProcessingMethod pm = new ProcessingMethod(processingMethodsid++, null, processingMethodsNumber++, "fake processing method - to be done", (int)srcSoftware.getId());
            processingMethods.add(pm);
        }
        List<Run> runs = srcReader.getRuns();
        List<Sample> samples = srcReader.getSamples();
        List<SourceFile> sourceFiles = srcReader.getSourceFiles();
        List<SharedParamTree> sharedParamTrees = srcReader.getSharedParamTreeList();
        List<CV> cvs = srcReader.getCvList();
        List<CVTerm> cvTerms = srcReader.getCvTermList();
        List<CVUnit> cvUnits = srcReader.getCvUnitList();
        List<UserTerm> userTerms = srcReader.getUserTermList();
        LOG.info("Created MzDBMetaData.");
        MzDBMetaData mzMetaData = new MzDBMetaData();
        mzMetaData.setMzdbHeader(mzdbHeader);
        mzMetaData.setDataEncodings(dataEncodings);
        mzMetaData.setSharedParamTrees(sharedParamTrees);
        mzMetaData.setInstrumentConfigurations(instrumentConfigurations);
        mzMetaData.setProcessingMethods(processingMethods);
        mzMetaData.setRuns(runs);
        mzMetaData.setSamples(samples);
        mzMetaData.setSourceFiles(sourceFiles);
        mzMetaData.setSoftwares(softwares);
        mzMetaData.setCvList(cvs);
        mzMetaData.setCvTerms(cvTerms);
        mzMetaData.setCvUnits(cvUnits);
        mzMetaData.setUserTerms(userTerms);
        return mzMetaData;
    }
}

