/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDbHeader;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.model.params.param.CV;
import fr.profi.mzdb.db.model.params.param.CVTerm;
import fr.profi.mzdb.db.model.params.param.CVUnit;
import fr.profi.mzdb.db.model.params.param.UserTerm;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.ProcessingMethod;
import fr.profi.mzdb.serialization.SerializationInterface;
import fr.profi.mzdb.serialization.SerializationReader;
import fr.profi.mzdb.serialization.SerializationWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MzDBMetaData
implements SerializationInterface {
    protected MzDbHeader mzdbHeader;
    protected List<DataEncoding> dataEncodings = new ArrayList<DataEncoding>();
    protected List<InstrumentConfiguration> instrumentConfigurations = new ArrayList<InstrumentConfiguration>();
    protected List<SharedParamTree> sharedParamTrees = new ArrayList<SharedParamTree>();
    protected List<ProcessingMethod> processingMethods = new ArrayList<ProcessingMethod>();
    protected List<Run> runs = new ArrayList<Run>();
    protected List<Sample> samples = new ArrayList<Sample>();
    protected List<Software> softwares = new ArrayList<Software>();
    protected List<SourceFile> sourceFiles = new ArrayList<SourceFile>();
    protected List<CV> cvList = new ArrayList<CV>();
    protected List<CVTerm> cvTerms = new ArrayList<CVTerm>();
    protected List<CVUnit> cvUnits = new ArrayList<CVUnit>();
    protected List<UserTerm> userTerms = new ArrayList<UserTerm>();
    protected double lowestMS1Mz = 0.0;

    public MzDBMetaData() {
    }

    public MzDBMetaData(SerializationReader reader) throws IOException {
        this.read(reader);
    }

    public MzDbHeader getMzdbHeader() {
        return this.mzdbHeader;
    }

    public void setMzdbHeader(MzDbHeader mzdbHeader) {
        this.mzdbHeader = mzdbHeader;
    }

    public List<DataEncoding> getDataEncodings() {
        return this.dataEncodings;
    }

    public void setDataEncodings(List<DataEncoding> dataEncodings) {
        this.dataEncodings = dataEncodings;
    }

    public List<InstrumentConfiguration> getInstrumentConfigurations() {
        return this.instrumentConfigurations;
    }

    public void setInstrumentConfigurations(List<InstrumentConfiguration> instrumentConfigurations) {
        this.instrumentConfigurations = instrumentConfigurations;
    }

    public List<SharedParamTree> getSharedParamTrees() {
        return this.sharedParamTrees;
    }

    public void setSharedParamTrees(List<SharedParamTree> sharedParamTrees) {
        this.sharedParamTrees = sharedParamTrees;
    }

    public List<ProcessingMethod> getProcessingMethods() {
        return this.processingMethods;
    }

    public void setProcessingMethods(List<ProcessingMethod> processingMethods) {
        this.processingMethods = processingMethods;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public void setRuns(List<Run> runs) {
        this.runs = runs;
    }

    public List<Sample> getSamples() {
        return this.samples;
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    public List<Software> getSoftwares() {
        return this.softwares;
    }

    public void setSoftwares(List<Software> softwares) {
        this.softwares = softwares;
    }

    public List<SourceFile> getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(List<SourceFile> sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public List<CV> getCvList() {
        return this.cvList;
    }

    public void setCvList(List<CV> cvList) {
        this.cvList = cvList;
    }

    public List<CVTerm> getCvTerms() {
        return this.cvTerms;
    }

    public void setCvTerms(List<CVTerm> cvTerms) {
        this.cvTerms = cvTerms;
    }

    public List<UserTerm> getUserTerms() {
        return this.userTerms;
    }

    public void setUserTerms(List<UserTerm> userTerms) {
        this.userTerms = userTerms;
    }

    public List<CVUnit> getCvUnits() {
        return this.cvUnits;
    }

    public void setCvUnits(List<CVUnit> cvUnits) {
        this.cvUnits = cvUnits;
    }

    public double getLowestMS1Mz() {
        return this.lowestMS1Mz;
    }

    public void setLowestMS1Mz(double lowestMS1Mz) {
        this.lowestMS1Mz = lowestMS1Mz;
    }

    @Override
    public void write(SerializationWriter writer) throws IOException {
        this.mzdbHeader.write(writer);
        this.writeList(writer, this.dataEncodings);
        this.writeList(writer, this.instrumentConfigurations);
        this.writeList(writer, this.sharedParamTrees);
        this.writeList(writer, this.processingMethods);
        this.writeList(writer, this.runs);
        this.writeList(writer, this.samples);
        this.writeList(writer, this.softwares);
        this.writeList(writer, this.sourceFiles);
        this.writeList(writer, this.cvList);
        this.writeList(writer, this.cvTerms);
        this.writeList(writer, this.cvUnits);
        this.writeList(writer, this.userTerms);
        writer.writeDouble(this.lowestMS1Mz);
    }

    private void writeList(SerializationWriter writer, List list) throws IOException {
        writer.writeInt32(list.size());
        for (Object serializableObject : list) {
            ((SerializationInterface)serializableObject).write(writer);
        }
    }

    @Override
    public void read(SerializationReader reader) throws IOException {
        SerializationInterface element;
        int i;
        this.mzdbHeader = new MzDbHeader(reader);
        int size = reader.readInt32();
        this.dataEncodings = new ArrayList<DataEncoding>(size);
        for (i = 0; i < size; ++i) {
            element = new DataEncoding(reader);
            this.dataEncodings.add((DataEncoding)element);
        }
        size = reader.readInt32();
        this.instrumentConfigurations = new ArrayList<InstrumentConfiguration>(size);
        for (i = 0; i < size; ++i) {
            element = new InstrumentConfiguration(reader);
            this.instrumentConfigurations.add((InstrumentConfiguration)element);
        }
        size = reader.readInt32();
        this.sharedParamTrees = new ArrayList<SharedParamTree>(size);
        for (i = 0; i < size; ++i) {
            element = new SharedParamTree(reader);
            this.sharedParamTrees.add((SharedParamTree)element);
        }
        size = reader.readInt32();
        this.processingMethods = new ArrayList<ProcessingMethod>(size);
        for (i = 0; i < size; ++i) {
            element = new ProcessingMethod(reader);
            this.processingMethods.add((ProcessingMethod)element);
        }
        size = reader.readInt32();
        this.runs = new ArrayList<Run>(size);
        for (i = 0; i < size; ++i) {
            element = new Run(reader);
            this.runs.add((Run)element);
        }
        size = reader.readInt32();
        this.samples = new ArrayList<Sample>(size);
        for (i = 0; i < size; ++i) {
            element = new Sample(reader);
            this.samples.add((Sample)element);
        }
        size = reader.readInt32();
        this.softwares = new ArrayList<Software>(size);
        for (i = 0; i < size; ++i) {
            element = new Software(reader);
            this.softwares.add((Software)element);
        }
        size = reader.readInt32();
        this.sourceFiles = new ArrayList<SourceFile>(size);
        for (i = 0; i < size; ++i) {
            element = new SourceFile(reader);
            this.sourceFiles.add((SourceFile)element);
        }
        size = reader.readInt32();
        this.cvList = new ArrayList<CV>(size);
        for (i = 0; i < size; ++i) {
            element = new CV(reader);
            this.cvList.add((CV)element);
        }
        size = reader.readInt32();
        this.cvTerms = new ArrayList<CVTerm>(size);
        for (i = 0; i < size; ++i) {
            element = new CVTerm(reader);
            this.cvTerms.add((CVTerm)element);
        }
        size = reader.readInt32();
        this.cvUnits = new ArrayList<CVUnit>(size);
        for (i = 0; i < size; ++i) {
            element = new CVUnit(reader);
            this.cvUnits.add((CVUnit)element);
        }
        size = reader.readInt32();
        this.userTerms = new ArrayList<UserTerm>(size);
        for (i = 0; i < size; ++i) {
            element = new UserTerm(reader);
            this.userTerms.add((UserTerm)element);
        }
        this.lowestMS1Mz = reader.readDouble();
    }
}

