/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.util.patch;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.table.BoundingBoxMsnRtreeTable;
import fr.profi.mzdb.db.table.BoundingBoxTable;
import fr.profi.mzdb.db.table.RunTable;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.util.patch.MsnRtreeEntry;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import fr.profi.mzdb.util.sqlite.SQLiteRecordIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIAIsolationWindowsPatch {
    private static final Logger logger = LoggerFactory.getLogger(DIAIsolationWindowsPatch.class);

    private static List<IsolationWindow> toIsolationWindowsList(Map<SpectrumHeader, IsolationWindow> headers) throws SQLiteException {
        List<IsolationWindow> list = headers.values().stream().distinct().collect(Collectors.toList());
        list.sort((o1, o2) -> Double.compare(o1.getMinMz(), o2.getMaxMz()));
        return list;
    }

    private static void updateIsolationWindows(SQLiteConnection connection, Map<SpectrumHeader, IsolationWindow> headers) throws SQLiteException {
        String sqlString = "UPDATE bounding_box_msn_rtree SET min_parent_mz = ?, max_parent_mz = ? WHERE bounding_box_msn_rtree.id IN (SELECT id FROM bounding_box WHERE bounding_box.first_spectrum_id = ?)";
        int count = 0;
        SQLiteStatement stmt = connection.prepare(sqlString, true);
        connection.exec("BEGIN TRANSACTION;");
        for (Map.Entry<SpectrumHeader, IsolationWindow> entry : headers.entrySet()) {
            SpectrumHeader header = entry.getKey();
            IsolationWindow window = entry.getValue();
            long firstSpectrumId = header.getBBFirstSpectrumId();
            stmt.bind(1, window.getMinMz()).bind(2, window.getMaxMz()).bind(3, firstSpectrumId);
            stmt.step();
            stmt.reset(true);
            if (++count % 10 != 0) continue;
            logger.info("updating header {}/{}", (Object)count, (Object)headers.size());
        }
        connection.exec("COMMIT;");
    }

    private static void updateIsolationWindows2(SQLiteConnection connection, Map<SpectrumHeader, IsolationWindow> headers) throws SQLiteException {
        String queryStr = "SELECT bounding_box.first_spectrum_id, bounding_box_msn_rtree.* FROM bounding_box_msn_rtree, bounding_box WHERE bounding_box_msn_rtree.id = bounding_box.id";
        String createIndex = "CREATE VIRTUAL TABLE bounding_box_msn_rtree USING rtree(\nid INTEGER NOT NULL PRIMARY KEY, \nmin_ms_level REAL NOT NULL, \nmax_ms_level REAL NOT NULL, \nmin_parent_mz REAL NOT NULL, \nmax_parent_mz REAL NOT NULL, \nmin_mz REAL NOT NULL, \nmax_mz REAL NOT NULL, \nmin_time REAL NOT NULL, \nmax_time REAL NOT NULL);";
        String insertQuery = "INSERT INTO bounding_box_msn_rtree VALUES(?,?,?,?,?,?,?,?,?)";
        SQLiteRecordIterator records = new SQLiteQuery(connection, queryStr).getRecordIterator();
        ArrayList<Object> entries = new ArrayList<Object>();
        while (records.hasNext()) {
            SQLiteRecord record = records.next();
            MsnRtreeEntry entry = new MsnRtreeEntry();
            entry.firstSpectrumId = record.columnInt(BoundingBoxTable.FIRST_SPECTRUM_ID);
            entry.id = record.columnInt(BoundingBoxMsnRtreeTable.ID);
            entry.minMsLevel = record.columnDouble(BoundingBoxMsnRtreeTable.MIN_MS_LEVEL);
            entry.maxMsLevel = record.columnDouble(BoundingBoxMsnRtreeTable.MAX_MS_LEVEL);
            entry.minParentMz = record.columnDouble(BoundingBoxMsnRtreeTable.MIN_PARENT_MZ);
            entry.maxParentMz = record.columnDouble(BoundingBoxMsnRtreeTable.MAX_PARENT_MZ);
            entry.minMz = record.columnDouble(BoundingBoxMsnRtreeTable.MIN_MZ);
            entry.maxMz = record.columnDouble(BoundingBoxMsnRtreeTable.MAX_MZ);
            entry.minTime = record.columnDouble(BoundingBoxMsnRtreeTable.MIN_TIME);
            entry.maxTime = record.columnDouble(BoundingBoxMsnRtreeTable.MAX_TIME);
            entries.add(entry);
        }
        logger.info("read {} Msn RTree index entries", (Object)entries.size());
        Map<Integer, List<MsnRtreeEntry>> indexEntriesByFirstSpectrumId = entries.stream().collect(Collectors.groupingBy(MsnRtreeEntry::getFirstSpectrumId));
        logger.info("{} mapped index Msn RTree", (Object)indexEntriesByFirstSpectrumId.size());
        for (Map.Entry entry : headers.entrySet()) {
            SpectrumHeader header = (SpectrumHeader)entry.getKey();
            IsolationWindow isolationWindow = (IsolationWindow)entry.getValue();
            List<MsnRtreeEntry> indexEntries = indexEntriesByFirstSpectrumId.get(header.getBBFirstSpectrumId());
            for (MsnRtreeEntry indexEntry : indexEntries) {
                indexEntry.minParentMz = isolationWindow.getMinMz();
                indexEntry.maxParentMz = isolationWindow.getMaxMz();
            }
        }
        logger.info("index entries updated (in memory)");
        connection.exec("BEGIN TRANSACTION;");
        connection.exec("DROP TABLE bounding_box_msn_rtree;");
        connection.exec("COMMIT;");
        logger.info("index dropped");
        connection.exec("BEGIN TRANSACTION;");
        connection.exec(createIndex);
        connection.exec("COMMIT;");
        logger.info("index created");
        int count = 0;
        connection.exec("BEGIN TRANSACTION;");
        SQLiteStatement sQLiteStatement = connection.prepare(insertQuery, true);
        for (MsnRtreeEntry msnRtreeEntry : entries) {
            sQLiteStatement.bind(1, msnRtreeEntry.id).bind(2, msnRtreeEntry.minMsLevel).bind(3, msnRtreeEntry.maxMsLevel);
            sQLiteStatement.bind(4, msnRtreeEntry.minParentMz).bind(5, msnRtreeEntry.maxParentMz);
            sQLiteStatement.bind(6, msnRtreeEntry.minMz).bind(7, msnRtreeEntry.maxMz);
            sQLiteStatement.bind(8, msnRtreeEntry.minTime).bind(9, msnRtreeEntry.maxTime);
            sQLiteStatement.step();
            sQLiteStatement.reset(true);
            if (++count % 100000 != 0) continue;
            logger.info("updating header {}/{}", (Object)count, (Object)entries.size());
        }
        connection.exec("COMMIT;");
        logger.info("{} index entries inserted", (Object)entries.size());
    }

    public static Map<SpectrumHeader, IsolationWindow> retrieveTrueIsolationWindows(MzDbReader reader) throws SQLiteException {
        HashMap<SpectrumHeader, IsolationWindow> windows = new HashMap<SpectrumHeader, IsolationWindow>();
        SpectrumHeader[] headers = reader.getMs2SpectrumHeaders();
        SpectrumHeader.loadPrecursors(headers, reader.getConnection());
        for (SpectrumHeader header : headers) {
            Precursor precursor = header.getPrecursor();
            if (precursor == null) continue;
            String center = null;
            String upper = null;
            String lower = null;
            IsolationWindowParamTree tree = precursor.getIsolationWindow();
            for (CVParam cvParam : tree.getCVParams()) {
                if (cvParam.getAccession().equals("MS:1000827")) {
                    center = cvParam.getValue();
                    continue;
                }
                if (cvParam.getAccession().equals("MS:1000828")) {
                    lower = cvParam.getValue();
                    continue;
                }
                if (!cvParam.getAccession().equals("MS:1000829")) continue;
                upper = cvParam.getValue();
            }
            windows.put(header, new IsolationWindow(Double.valueOf(center) - Double.valueOf(lower), Double.valueOf(center) + Double.valueOf(upper)));
        }
        return windows;
    }

    public static void run(String filePath) {
        DIAIsolationWindowsPatch.updateDIAModeForPRM(filePath);
        DIAIsolationWindowsPatch.patchDIAWindows(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patchDIAWindows(String filepath) {
        MzDbReader reader = null;
        SQLiteConnection connection = null;
        try {
            reader = new MzDbReader(new File(filepath), false);
            AcquisitionMode acqMode = null;
            acqMode = reader.getAcquisitionMode();
            if (acqMode != null && acqMode.isDataIndependantAcquisition()) {
                int[] range = reader.getMzRange(1);
                logger.info("MS1 mz Range :: " + range[0] + "-" + range[1]);
                int[] range_ms2 = reader.getMzRange(2);
                logger.info("MS2 mz Range :: " + range_ms2[0] + "-" + range_ms2[1]);
                Map<SpectrumHeader, IsolationWindow> headers = DIAIsolationWindowsPatch.retrieveTrueIsolationWindows(reader);
                List<IsolationWindow> windows = DIAIsolationWindowsPatch.toIsolationWindowsList(headers);
                for (IsolationWindow window : windows) {
                    logger.info("window : [{},{}]", (Object)window.getMinMz(), (Object)window.getMaxMz());
                }
                reader.close();
                reader = null;
                connection = new SQLiteConnection(new File(filepath));
                connection.open();
                logger.info("Updating {} spectrum headers bb indexes", (Object)headers.size());
                DIAIsolationWindowsPatch.updateIsolationWindows2(connection, headers);
                connection.dispose();
            }
        }
        catch (Exception e) {
            logger.error("Error during isolation window fix/retrieval", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (connection != null && connection.isOpen()) {
                connection.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDIAModeForPRM(String filepath) {
        MzDbReader reader = null;
        SQLiteConnection connection = null;
        try {
            reader = new MzDbReader(new File(filepath), false){

                public boolean isPRM() {
                    try {
                        List<String> lines = this.extractFromInstrumentMethod("PRM");
                        lines.addAll(this.extractFromInstrumentMethod("Scan tMSn"));
                        lines.addAll(this.extractFromInstrumentMethod("Scan tMS2"));
                        return !lines.isEmpty();
                    }
                    catch (Exception e) {
                        logger.error("Cannot infer PRM mode from InstrumentMethods", (Throwable)e);
                        return false;
                    }
                }

                @Override
                public AcquisitionMode getAcquisitionMode() throws SQLiteException {
                    if (this.isPRM()) {
                        return AcquisitionMode.PRM;
                    }
                    return super.getAcquisitionMode();
                }
            };
            AcquisitionMode acqMode = reader.getAcquisitionMode();
            if (acqMode.equals(AcquisitionMode.PRM)) {
                connection = new SQLiteConnection(new File(filepath));
                connection.open();
                String queryStr = "SELECT * FROM run";
                SQLiteRecordIterator records = new SQLiteQuery(connection, queryStr).getRecordIterator();
                SQLiteRecord record = records.next();
                String paramTree = record.columnString(RunTable.PARAM_TREE);
                int id = record.columnInt(RunTable.ID);
                paramTree = paramTree.replace("DDA", "SWATH");
                String sqlString = "UPDATE run SET param_tree = ? WHERE id = ? ";
                SQLiteStatement stmt = connection.prepare(sqlString, false);
                connection.exec("BEGIN TRANSACTION;");
                stmt.bind(1, paramTree);
                stmt.bind(2, id);
                stmt.step();
                connection.exec("COMMIT;");
                connection.dispose();
                logger.info("Acquisition Mode patched to SWATH");
            }
        }
        catch (Exception e) {
            logger.error("Error during isolation window fix/retrieval", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (connection != null && connection.isOpen()) {
                connection.dispose();
            }
        }
    }
}

