/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope;

import fr.profi.mzscope.Constants;
import fr.profi.mzscope.Peak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MSMSSpectrum {
    private Map<String, Object> annotations;
    protected Peak precursor;
    protected double retentionTime;
    List<Peak> peaks;

    protected MSMSSpectrum(MSMSSpectrum sp) {
        this(sp.getPrecursorMz(), sp.getPrecursorIntensity(), sp.getPrecursorCharge(), sp.getRetentionTime());
    }

    public MSMSSpectrum(double MHParent, double intensityParent, int chargeParent) {
        this(MHParent, intensityParent, chargeParent, Double.MIN_VALUE);
    }

    public MSMSSpectrum(double precursorMz, double intensityParent, int charge, double retentionTime) {
        this.precursor = new Peak(precursorMz, intensityParent, charge, this);
        this.retentionTime = retentionTime;
        this.peaks = new ArrayList<Peak>();
    }

    public double getPrecursorMz() {
        return this.precursor.getMz();
    }

    public double getPrecursorMass() {
        return Constants.convertMzToMH(this.precursor.getMz(), this.precursor.getCharge());
    }

    public double getPrecursorIntensity() {
        return this.precursor.getIntensity();
    }

    public int getPrecursorCharge() {
        return this.precursor.getCharge();
    }

    public double getRetentionTime() {
        return this.retentionTime;
    }

    public double getRetentionTimeInMinutes() {
        return this.retentionTime / 60.0;
    }

    public double[] getMassValues() {
        Iterator<Peak> it = this.peaks.iterator();
        double[] mass = new double[this.peaksCount()];
        int count = 0;
        while (it.hasNext()) {
            Peak p = it.next();
            mass[count++] = p.getMz();
        }
        return mass;
    }

    public double[] getIntensityValues() {
        Iterator<Peak> it = this.peaks.iterator();
        double[] intensities = new double[this.peaksCount()];
        int count = 0;
        while (it.hasNext()) {
            Peak p = it.next();
            intensities[count++] = p.getIntensity();
        }
        return intensities;
    }

    protected void addPeak(Peak p) {
        if (p.spectrum != this) {
            throw new IllegalArgumentException("a peak cannot belong to more than one spectrum");
        }
        this.peaks.add(p);
    }

    public void addPeak(double mass, double intensity) {
        this.addPeak(new Peak(mass, intensity, this));
    }

    public List<Peak> getPeaks() {
        return this.peaks;
    }

    public int peaksCount() {
        return this.peaks.size();
    }

    public void setAnnotation(String key, Object value) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, Object>();
        }
        this.annotations.put(key, value);
    }

    public Object getAnnotation(String key) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(key);
    }

    public Iterator<String> getAnnotations() {
        return this.annotations.keySet().iterator();
    }
}

