/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.VTDNav_L5;

public class TextIter {
    private int prevLocation;
    protected int depth;
    protected int index;
    protected VTDNav vn = null;
    private int lcIndex;
    private int lcLower;
    private int lcUpper;
    private int sel_type = 0;
    private String piName = null;

    public void selectText() {
        this.sel_type = 0;
    }

    public void selectComment() {
        this.sel_type = 1;
    }

    public void selectPI0() {
        this.sel_type = 2;
    }

    public void selectPI1(String s) {
        this.sel_type = 3;
        this.piName = s;
    }

    public void selectNode() {
        this.sel_type = 4;
    }

    public int getNext() {
        if (this.vn == null) {
            throw new IllegalArgumentException(" VTDNav instance can't be null");
        }
        if (this.vn.shallowDepth) {
            switch (this.depth) {
                case -1: {
                    return this.handleDocumentNode();
                }
                case 0: {
                    return this.handleLevel0();
                }
                case 1: {
                    return this.handleLevel1();
                }
                case 2: {
                    return this.handleLevel2();
                }
            }
            return this.handleDefault();
        }
        switch (this.depth) {
            case -1: {
                return this.handleDocumentNode();
            }
            case 0: {
                return this.handleLevel0();
            }
            case 1: {
                return this.handleLevel1();
            }
            case 2: {
                return this._handleLevel2();
            }
            case 3: {
                return this.handleLevel3();
            }
            case 4: {
                return this.handleLevel4();
            }
        }
        return this.handleDefault();
    }

    private final boolean isText(int index) {
        int type = this.vn.getTokenType(index);
        switch (this.sel_type) {
            case 0: {
                return type == 5 || type == 11;
            }
            case 1: {
                return type == 6;
            }
            case 2: {
                return type == 7;
            }
            case 3: {
                try {
                    return this.vn.matchRawTokenString(index, this.piName);
                }
                catch (NavException e) {
                    return false;
                }
            }
            case 4: {
                return type != 8;
            }
        }
        return false;
    }

    public void touch(VTDNav v) {
        if (v == null) {
            throw new IllegalArgumentException(" VTDNav instance can't be null");
        }
        this.depth = v.context[0];
        this.index = this.depth == -1 ? 0 : (this.depth != 0 ? v.context[this.depth] : v.rootIndex);
        this.vn = v;
        this.prevLocation = -1;
        this.lcIndex = -1;
        this.lcUpper = -1;
        this.lcLower = -1;
    }

    private int increment(int sp) {
        int i;
        int type = this.vn.getTokenType(sp);
        int vtdSize = this.vn.vtdBuffer.size;
        for (i = sp + 1; i < vtdSize && this.depth == this.vn.getTokenDepth(i) && type == this.vn.getTokenType(i) && this.vn.getTokenOffset(i - 1) + (int)((this.vn.vtdBuffer.longAt(i - 1) & 0xFFFFF00000000L) >> 32) == this.vn.getTokenOffset(i); ++i) {
        }
        return i;
    }

    private int handleLevel0() {
        int sp;
        int n = sp = this.prevLocation != -1 ? this.increment(this.prevLocation) : this.index + 1;
        if (this.vn.l1Buffer.size != 0) {
            int temp1 = this.vn.l1Buffer.upper32At(0);
            int temp2 = this.vn.l1Buffer.upper32At(this.vn.l1Buffer.size - 1);
            int n2 = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : 0;
            while (sp < this.vn.vtdSize) {
                if (sp >= temp1 && sp < temp2) {
                    int s = this.vn.l1Buffer.upper32At(this.lcIndex);
                    if (sp == s) {
                        ++this.lcIndex;
                        sp = this.vn.l1Buffer.upper32At(this.lcIndex) - 1;
                        boolean b = false;
                        while (this.vn.getTokenDepth(sp) == 0) {
                            b = true;
                            --sp;
                        }
                        if (b) {
                            ++sp;
                        }
                    }
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 0) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp < temp1) {
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 0) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp == temp2) {
                    sp = this.vn.vtdBuffer.size - 1;
                    while (this.vn.getTokenDepth(sp) <= 0) {
                        --sp;
                    }
                    ++sp;
                }
                if (sp >= this.vn.vtdSize) {
                    return -1;
                }
                if (this.isText(sp) && this.vn.getTokenDepth(sp) == 0) {
                    this.prevLocation = sp;
                    return sp;
                }
                if (this.vn.getTokenDepth(sp) > 1) break;
                ++sp;
            }
            return -1;
        }
        while (sp < this.vn.vtdSize) {
            if (this.isText(sp) && this.vn.getTokenDepth(sp) == 0) {
                this.prevLocation = sp;
                return sp;
            }
            ++sp;
        }
        return -1;
    }

    private int handleLevel1() {
        int sp;
        if (this.prevLocation != -1) {
            sp = this.increment(this.prevLocation);
        } else {
            this.lcLower = this.vn.l1Buffer.lower32At(this.vn.l1index);
            if (this.lcLower != -1) {
                this.lcUpper = this.vn.l2Buffer.size - 1;
                int size = this.vn.l1Buffer.size;
                for (int i = this.vn.l1index + 1; i < size; ++i) {
                    int temp = this.vn.l1Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.lcUpper = temp - 1;
                    break;
                }
            }
            sp = this.index + 1;
        }
        if (this.lcLower != -1) {
            int temp1 = this.vn.l2Buffer.upper32At(this.lcLower);
            int temp2 = this.vn.l2Buffer.upper32At(this.lcUpper);
            int n = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (sp < this.vn.vtdSize) {
                int s = this.vn.l2Buffer.upper32At(this.lcIndex);
                if (sp >= temp1 && sp < temp2) {
                    if (sp == s) {
                        ++this.lcIndex;
                        sp = this.vn.l2Buffer.upper32At(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(sp) == 1) {
                            --sp;
                        }
                        ++sp;
                    }
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 1) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp < temp1) {
                    if (this.isText(sp)) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (this.isText(sp) && this.vn.getTokenDepth(sp) == 1) {
                    this.prevLocation = sp;
                    return sp;
                }
                if (this.vn.getTokenType(sp) == 0 && this.vn.getTokenDepth(sp) < 2 || this.vn.getTokenDepth(sp) < 1) break;
                ++sp;
            }
            return -1;
        }
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        int d = this.vn.getTokenDepth(sp);
        int type = this.vn.getTokenType(sp);
        while (sp < this.vn.vtdSize && d >= 1 && (d != 1 || type != 0)) {
            if (this.isText(sp)) {
                this.prevLocation = sp;
                return sp;
            }
            d = this.vn.getTokenDepth(++sp);
            type = this.vn.getTokenType(sp);
        }
        return -1;
    }

    private int handleLevel2() {
        int sp;
        if (this.prevLocation != -1) {
            sp = this.increment(this.prevLocation);
        } else {
            this.lcLower = this.vn.l2Buffer.lower32At(this.vn.l2index);
            if (this.lcLower != -1) {
                this.lcUpper = this.vn.l3Buffer.size - 1;
                int size = this.vn.l2Buffer.size;
                for (int i = this.vn.l2index + 1; i < size; ++i) {
                    int temp = this.vn.l2Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.lcUpper = temp - 1;
                    break;
                }
            }
            sp = this.index + 1;
        }
        if (this.lcLower != -1) {
            int temp1 = this.vn.l3Buffer.intAt(this.lcLower);
            int temp2 = this.vn.l3Buffer.intAt(this.lcUpper);
            int n = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (sp < this.vn.vtdSize) {
                int s = this.vn.l3Buffer.intAt(this.lcIndex);
                if (sp >= temp1 && sp < temp2) {
                    if (sp == s) {
                        ++this.lcIndex;
                        sp = this.vn.l3Buffer.intAt(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(sp) == 2) {
                            --sp;
                        }
                        ++sp;
                    }
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 2) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp < temp1) {
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 2) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (this.isText(sp) && this.vn.getTokenDepth(sp) == 2) {
                    this.prevLocation = sp;
                    return sp;
                }
                if (this.vn.getTokenType(sp) == 0 && this.vn.getTokenDepth(sp) < 3 || this.vn.getTokenDepth(sp) < 2) break;
                ++sp;
            }
            return -1;
        }
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        int d = this.vn.getTokenDepth(sp);
        int type = this.vn.getTokenType(sp);
        while (sp < this.vn.vtdSize && d >= 2 && (d != 2 || type != 0)) {
            if (this.isText(sp) && this.vn.getTokenDepth(sp) == 2) {
                this.prevLocation = sp;
                return sp;
            }
            d = this.vn.getTokenDepth(++sp);
            type = this.vn.getTokenType(sp);
        }
        return -1;
    }

    private int handleLevel3() {
        int sp;
        VTDNav_L5 vnl = (VTDNav_L5)this.vn;
        if (this.prevLocation != -1) {
            sp = this.increment(this.prevLocation);
        } else {
            this.lcLower = vnl.l3Buffer.lower32At(vnl.l3index);
            if (this.lcLower != -1) {
                this.lcUpper = vnl.l4Buffer.size - 1;
                int size = vnl.l3Buffer.size;
                for (int i = vnl.l3index + 1; i < size; ++i) {
                    int temp = vnl.l3Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.lcUpper = temp - 1;
                    break;
                }
            }
            sp = this.index + 1;
        }
        if (this.lcLower != -1) {
            int temp1 = vnl.l4Buffer.upper32At(this.lcLower);
            int temp2 = vnl.l4Buffer.upper32At(this.lcUpper);
            int n = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (sp < this.vn.vtdSize) {
                int s = vnl.l4Buffer.upper32At(this.lcIndex);
                if (sp >= temp1 && sp < temp2) {
                    if (sp == s) {
                        ++this.lcIndex;
                        sp = vnl.l4Buffer.upper32At(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(sp) == 2) {
                            --sp;
                        }
                        ++sp;
                    }
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 3) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp < temp1) {
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 3) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (this.isText(sp) && this.vn.getTokenDepth(sp) == 3) {
                    this.prevLocation = sp;
                    return sp;
                }
                if (this.vn.getTokenType(sp) == 0 && this.vn.getTokenDepth(sp) < 4 || this.vn.getTokenDepth(sp) < 3) break;
                ++sp;
            }
            return -1;
        }
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        int d = this.vn.getTokenDepth(sp);
        int type = this.vn.getTokenType(sp);
        while (sp < this.vn.vtdSize && d >= 3 && (d != 3 || type != 0)) {
            if (this.isText(sp) && this.vn.getTokenDepth(sp) == 3) {
                this.prevLocation = sp;
                return sp;
            }
            d = this.vn.getTokenDepth(++sp);
            type = this.vn.getTokenType(sp);
        }
        return -1;
    }

    private int handleLevel4() {
        int sp;
        VTDNav_L5 vnl = (VTDNav_L5)this.vn;
        if (this.prevLocation != -1) {
            sp = this.increment(this.prevLocation);
        } else {
            this.lcLower = vnl.l4Buffer.lower32At(vnl.l4index);
            if (this.lcLower != -1) {
                this.lcUpper = vnl.l5Buffer.size - 1;
                int size = vnl.l4Buffer.size;
                for (int i = vnl.l4index + 1; i < size; ++i) {
                    int temp = vnl.l4Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.lcUpper = temp - 1;
                    break;
                }
            }
            sp = this.index + 1;
        }
        if (this.lcLower != -1) {
            int temp1 = vnl.l5Buffer.intAt(this.lcLower);
            int temp2 = vnl.l5Buffer.intAt(this.lcUpper);
            int n = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (sp < this.vn.vtdSize) {
                int s = vnl.l5Buffer.intAt(this.lcIndex);
                if (sp >= temp1 && sp < temp2) {
                    if (sp == s) {
                        ++this.lcIndex;
                        sp = vnl.l5Buffer.intAt(this.lcIndex) - 1;
                        while (this.vn.getTokenDepth(sp) == 4) {
                            --sp;
                        }
                        ++sp;
                    }
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 4) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp < temp1) {
                    if (this.isText(sp) && this.vn.getTokenDepth(sp) == 4) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (this.isText(sp) && this.vn.getTokenDepth(sp) == 4) {
                    this.prevLocation = sp;
                    return sp;
                }
                if (this.vn.getTokenType(sp) == 0 && this.vn.getTokenDepth(sp) < 5 || this.vn.getTokenDepth(sp) < 4) break;
                ++sp;
            }
            return -1;
        }
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        int d = this.vn.getTokenDepth(sp);
        int type = this.vn.getTokenType(sp);
        while (sp < this.vn.vtdSize && d >= 4 && (d != 4 || type != 0)) {
            if (this.isText(sp) && this.vn.getTokenDepth(sp) == 4) {
                this.prevLocation = sp;
                return sp;
            }
            d = this.vn.getTokenDepth(++sp);
            type = this.vn.getTokenType(sp);
        }
        return -1;
    }

    private int _handleLevel2() {
        int sp;
        VTDNav_L5 vnl = (VTDNav_L5)this.vn;
        if (this.prevLocation != -1) {
            sp = this.increment(this.prevLocation);
        } else {
            this.lcLower = vnl.l2Buffer.lower32At(vnl.l2index);
            if (this.lcLower != -1) {
                this.lcUpper = vnl.l3Buffer.size - 1;
                int size = vnl.l2Buffer.size;
                for (int i = vnl.l2index + 1; i < size; ++i) {
                    int temp = vnl.l2Buffer.lower32At(i);
                    if (temp == -1) continue;
                    this.lcUpper = temp - 1;
                    break;
                }
            }
            sp = this.index + 1;
        }
        if (this.lcLower != -1) {
            int temp1 = vnl.l3Buffer.upper32At(this.lcLower);
            int temp2 = vnl.l3Buffer.upper32At(this.lcUpper);
            int n = this.lcIndex = this.lcIndex != -1 ? this.lcIndex : this.lcLower;
            while (sp < vnl.vtdSize) {
                int s = vnl.l3Buffer.upper32At(this.lcIndex);
                if (sp >= temp1 && sp < temp2) {
                    if (sp == s) {
                        ++this.lcIndex;
                        sp = vnl.l3Buffer.upper32At(this.lcIndex) - 1;
                        while (vnl.getTokenDepth(sp) == 2) {
                            --sp;
                        }
                        ++sp;
                    }
                    if (this.isText(sp) && vnl.getTokenDepth(sp) == 2) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (sp < temp1) {
                    if (this.isText(sp) && vnl.getTokenDepth(sp) == 2) {
                        this.prevLocation = sp;
                        return sp;
                    }
                    ++sp;
                    continue;
                }
                if (this.isText(sp) && vnl.getTokenDepth(sp) == 2) {
                    this.prevLocation = sp;
                    return sp;
                }
                if (vnl.getTokenType(sp) == 0 && vnl.getTokenDepth(sp) < 3 || vnl.getTokenDepth(sp) < 2) break;
                ++sp;
            }
            return -1;
        }
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        int d = this.vn.getTokenDepth(sp);
        int type = this.vn.getTokenType(sp);
        while (sp < this.vn.vtdSize && d >= 2 && (d != 2 || type != 0)) {
            if (this.isText(sp) && this.vn.getTokenDepth(sp) == 2) {
                this.prevLocation = sp;
                return sp;
            }
            d = this.vn.getTokenDepth(++sp);
            type = this.vn.getTokenType(sp);
        }
        return -1;
    }

    private int handleDefault() {
        int sp;
        int n = sp = this.prevLocation != -1 ? this.increment(this.prevLocation) : this.index + 1;
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        int d = this.vn.getTokenDepth(sp);
        int type = this.vn.getTokenType(sp);
        while (d >= this.depth && (d != this.depth || type != 0)) {
            if (this.isText(sp) && d == this.depth) {
                this.prevLocation = sp;
                return sp;
            }
            if (++sp >= this.vn.vtdSize) {
                return -1;
            }
            d = this.vn.getTokenDepth(sp);
            type = this.vn.getTokenType(sp);
        }
        return -1;
    }

    private int handleDocumentNode() {
        int sp;
        if (this.sel_type == 0) {
            return -1;
        }
        int n = sp = this.prevLocation != -1 ? this.increment(this.prevLocation) : this.index + 1;
        if (sp >= this.vn.vtdSize) {
            return -1;
        }
        while (true) {
            if (sp < this.vn.rootIndex) {
                if (this.isText(sp)) {
                    this.prevLocation = sp;
                    return sp;
                }
                ++sp;
                continue;
            }
            if (sp == this.vn.rootIndex) {
                sp = this.vn.vtdSize - 1;
                while (this.vn.getTokenDepth(sp) == -1) {
                    --sp;
                }
                ++sp;
            }
            if (sp >= this.vn.vtdSize) {
                return -1;
            }
            if (this.isText(sp)) {
                this.prevLocation = sp;
                return sp;
            }
            ++sp;
        }
    }
}

