/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.security;

import fr.profi.util.DateUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionManager {
    private static EncryptionManager m_singleton = null;
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private KeyPair m_keypair = null;

    public static EncryptionManager getEncryptionManager() {
        if (m_singleton == null) {
            m_singleton = new EncryptionManager();
        }
        return m_singleton;
    }

    private EncryptionManager() {
        this.generateKeys();
    }

    private void generateKeys() {
        try {
            KeyPairGenerator keygenerator = KeyPairGenerator.getInstance("RSA");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            keygenerator.initialize(1024, random);
            this.m_keypair = keygenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOG.error("Specified algorithm doesn't exist !", (Throwable)e);
            throw new IllegalArgumentException("Specified algorithm doesn't exist !");
        }
    }

    public String getPublicKeyAsString() {
        PublicKey publicKey = this.m_keypair.getPublic();
        byte[] publicKeyEncoded = publicKey.getEncoded();
        String publicKeyAsString = Base64.encodeBase64String((byte[])publicKeyEncoded);
        return publicKeyAsString;
    }

    public String decrypt(String encryptedString) {
        try {
            byte[] encrypted = Base64.decodeBase64((String)encryptedString);
            PrivateKey privateKey = this.m_keypair.getPrivate();
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] decrypted = cipher.doFinal(encrypted);
            String text = new String(decrypted, "UTF-8");
            return text;
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.error("Error while decrypting specified text", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String text, String publicKeyAsString) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, EncryptionManager.retrievePublicKey(publicKeyAsString));
            byte[] encrypted = cipher.doFinal(text.getBytes("UTF-8"));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOG.error("Error while crypting specified text ", (Throwable)e);
            return null;
        }
    }

    private static PublicKey retrievePublicKey(String publicKeyAsString) {
        try {
            byte[] publicKeyEncoded = Base64.decodeBase64((String)publicKeyAsString);
            X509EncodedKeySpec ks = new X509EncodedKeySpec(publicKeyEncoded);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = kf.generatePublic(ks);
            return publicKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.error("Specified algorithm doesn't exist !", (Throwable)e);
            return null;
        }
    }
}

