/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.version;

import fr.profi.util.version.IVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(VersionHelper.class);

    private VersionHelper() {
    }

    public static IVersion[] getVersions() {
        ServiceLoader<IVersion> versionLoader = ServiceLoader.load(IVersion.class);
        Iterator<IVersion> iter = versionLoader.iterator();
        ArrayList<IVersion> versions = new ArrayList<IVersion>();
        boolean hasNext = false;
        do {
            hasNext = false;
            try {
                hasNext = iter.hasNext();
                if (!hasNext) continue;
                IVersion v = iter.next();
                versions.add(v);
            }
            catch (ServiceConfigurationError sce) {
                LOG.error("Error retrieving IVersion service", (Throwable)sce);
            }
        } while (hasNext);
        return versions.toArray(new IVersion[0]);
    }
}

