/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.mzdb.DemultiplexedSpectrum;
import fr.profi.mzdb.FeatureDetectorConfig;
import fr.profi.mzdb.FeatureDetectorConfig$;
import fr.profi.mzdb.MzDbFeatureDetector;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.util.collection.package;
import fr.profi.util.collection.package$;
import fr.profi.util.stat.Bin;
import fr.profi.util.stat.package;
import java.io.Serializable;
import java.util.Iterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.FilterMonadic;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001E4Aa\u0003\u0007\u0001'!AA\u0005\u0001B\u0001B\u0003%Q\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0004.\u0001\t\u0007I\u0011\u0001\u0018\t\ru\u0002\u0001\u0015!\u00030\u0011\u001dq\u0004A1A\u0005\u0002}Baa\u0011\u0001!\u0002\u0013\u0001\u0005\"\u0002#\u0001\t\u0003)\u0005\"\u0002'\u0001\t\u0013i\u0005\"\u0002.\u0001\t\u0013Y\u0006\"\u00023\u0001\t\u0003)'\u0001F'{\t\nl5K\u001c#f[VdG/\u001b9mKb,'O\u0003\u0002\u000e\u001d\u0005!QN\u001f3c\u0015\ty\u0001#A\u0003qe>4\u0017NC\u0001\u0012\u0003\t1'o\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u00155THI\u0019*fC\u0012,'\u000f\u0005\u0002'O5\tA\"\u0003\u0002)\u0019\tQQJ\u001f#c%\u0016\fG-\u001a:\u0002\rqJg.\u001b;?)\tYC\u0006\u0005\u0002'\u0001!)AE\u0001a\u0001K\u0005\u00112\u000f]3diJ,X\u000eS3bI\u0016\u0014()_%e+\u0005y\u0003c\u0001\u00196o5\t\u0011G\u0003\u00023g\u00059Q.\u001e;bE2,'B\u0001\u001b\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mE\u0012q\u0001T8oO6\u000b\u0007\u000f\u0005\u00029w5\t\u0011H\u0003\u0002;\u0019\u0005)Qn\u001c3fY&\u0011A(\u000f\u0002\u000f'B,7\r\u001e:v[\"+\u0017\rZ3s\u0003M\u0019\b/Z2ueVl\u0007*Z1eKJ\u0014\u00150\u00133!\u0003Qi\u0017N\u001c(c!\u0016\f7n]%o'B,7\r\u001e:v[V\t\u0001\t\u0005\u0002\u0016\u0003&\u0011!I\u0006\u0002\u0004\u0013:$\u0018!F7j]:\u0013\u0007+Z1lg&s7\u000b]3diJ,X\u000eI\u0001\u0013I\u0016lW\u000f\u001c;ja2,\u00070T*o\t\u0006$\u0018\rF\u0001G!\r)r)S\u0005\u0003\u0011Z\u0011Q!\u0011:sCf\u0004\"A\n&\n\u0005-c!!\u0006#f[VdG/\u001b9mKb,Gm\u00159fGR\u0014X/\\\u0001\u001b?\u001e\u0014x.\u001e9N':\u001cuN\u001d:fY\u0006$X\r\u001a)fC.,Gn\u001d\u000b\u0004\r:#\u0006\"B(\t\u0001\u0004\u0001\u0016AB7tc\u0019#8\u000fE\u0002\u0016\u000fF\u0003\"\u0001\u000f*\n\u0005MK$a\u0002$fCR,(/\u001a\u0005\u0006+\"\u0001\rAV\u0001\u000b[Nt\u0007+Z1lK2\u001c\bcA\u000bH/B\u0011\u0001\bW\u0005\u00033f\u0012a\u0001U3bW\u0016d\u0017aG0fqR\u0014\u0018m\u0019;XK&<\u0007\u000e^3e\u0003Z,'/Y4f)&lW\r\u0006\u0002]?B\u0011Q#X\u0005\u0003=Z\u0011QA\u00127pCRDQ\u0001Y\u0005A\u0002\u0005\fq\u0002]3bW\u0016dwJ\u001d$fCR,(/\u001a\t\u0003q\tL!aY\u001d\u0003\u0015%c5mQ8oi\u0016DH/A\u000f`OJ|W\u000f\u001d$ug\nK\u0018j]8mCRLwN\\,j]\u0012|w/\u00133y)\r1'\u000e\u001d\t\u0004aU:\u0007c\u0001\u0019i#&\u0011\u0011.\r\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fC\u0003l\u0015\u0001\u0007A.A\u000bjg>d\u0017\r^5p]^Kg\u000eZ8x%\u0006tw-Z:\u0011\u0007U9U\u000e\u0005\u00029]&\u0011q.\u000f\u0002\u0010\u0013N|G.\u0019;j_:<\u0016N\u001c3po\")qJ\u0003a\u0001!\u0002")
public class MzDbMSnDemultiplexer
implements LazyLogging {
    private final MzDbReader mzDbReader;
    private final LongMap<SpectrumHeader> spectrumHeaderById;
    private final int minNbPeaksInSpectrum;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        MzDbMSnDemultiplexer mzDbMSnDemultiplexer = this;
        synchronized (mzDbMSnDemultiplexer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public LongMap<SpectrumHeader> spectrumHeaderById() {
        return this.spectrumHeaderById;
    }

    public int minNbPeaksInSpectrum() {
        return this.minNbPeaksInSpectrum;
    }

    public DemultiplexedSpectrum[] demultiplexMSnData() {
        Predef$.MODULE$.println((Object)"Unsupervised ms1 feature detection");
        FeatureDetectorConfig ftDetectorConf = new FeatureDetectorConfig(1, 15.0f, FeatureDetectorConfig$.MODULE$.apply$default$3(), FeatureDetectorConfig$.MODULE$.apply$default$4(), FeatureDetectorConfig$.MODULE$.apply$default$5(), FeatureDetectorConfig$.MODULE$.apply$default$6());
        MzDbFeatureDetector ftDetectorMs1 = new MzDbFeatureDetector(this.mzDbReader, ftDetectorConf);
        Feature[] ms1Fts = (Feature[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ftDetectorMs1.detectFeatures())).filter((Function1 & Serializable & scala.Serializable)ft -> BoxesRunTime.boxToBoolean((boolean)MzDbMSnDemultiplexer.$anonfun$demultiplexMSnData$1(ft))))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.getMz()), (Ordering)Ordering.Double$.MODULE$);
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("# ").append(ms1Fts.length).append(" detected ms1 features").toString());
        FeatureDetectorConfig ftDetectorConfMs2 = new FeatureDetectorConfig(2, 20.0f, FeatureDetectorConfig$.MODULE$.apply$default$3(), FeatureDetectorConfig$.MODULE$.apply$default$4(), FeatureDetectorConfig$.MODULE$.apply$default$5(), FeatureDetectorConfig$.MODULE$.apply$default$6());
        IsolationWindow[] isolationWindows = this.mzDbReader.getDIAIsolationWindows();
        LongMap<ArrayBuffer<Feature>> ms1FtsByIWIdx = this._groupFtsByIsolationWindowIdx(isolationWindows, ms1Fts);
        ArrayBuffer spectra = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), isolationWindows.length).foreach((Function1 & Serializable & scala.Serializable)i -> MzDbMSnDemultiplexer.$anonfun$demultiplexMSnData$3(this, isolationWindows, ftDetectorConfMs2, ms1FtsByIWIdx, spectra, BoxesRunTime.unboxToInt((Object)i)));
        return (DemultiplexedSpectrum[])spectra.toArray(ClassTag$.MODULE$.apply(DemultiplexedSpectrum.class));
    }

    private DemultiplexedSpectrum[] _groupMSnCorrelatedPeakels(Feature[] ms1Fts, Peakel[] msnPeakels) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("combining peakels into features...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Product[] allLcEntities = (Product[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ms1Fts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])msnPeakels)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Product.class)));
        Map peakelTimeByLcEntity = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allLcEntities)).map((Function1 & Serializable & scala.Serializable)lcEntity -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(lcEntity), (Object)BoxesRunTime.boxToFloat((float)this._extractWeightedAverageTime((ILcContext)lcEntity))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        package.EntityHistogramComputer histoComputer = new package.EntityHistogramComputer((Seq)Predef$.MODULE$.wrapRefArray((Object[])allLcEntities), (Function1 & Serializable & scala.Serializable)entity -> BoxesRunTime.boxToDouble((double)MzDbMSnDemultiplexer.$anonfun$_groupMSnCorrelatedPeakels$2(peakelTimeByLcEntity, entity)));
        Iterable peakelTimes = peakelTimeByLcEntity.values();
        float timeRange = BoxesRunTime.unboxToFloat((Object)peakelTimes.max((Ordering)Ordering.Float$.MODULE$)) - BoxesRunTime.unboxToFloat((Object)peakelTimes.min((Ordering)Ordering.Float$.MODULE$));
        Tuple2[] peakelBins = histoComputer.calcHistogram((int)(timeRange / 3.0f), histoComputer.calcHistogram$default$2());
        ArrayBuffer spectra = new ArrayBuffer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelBins)).size());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelBins)).sliding(3).foreach((Function1 & Serializable & scala.Serializable)peakelBinGroup -> {
            MzDbMSnDemultiplexer.$anonfun$_groupMSnCorrelatedPeakels$3(this, peakelTimeByLcEntity, spectra, peakelBinGroup);
            return BoxedUnit.UNIT;
        });
        return (DemultiplexedSpectrum[])spectra.toArray(ClassTag$.MODULE$.apply(DemultiplexedSpectrum.class));
    }

    private float _extractWeightedAverageTime(ILcContext peakelOrFeature) {
        float f;
        ILcContext iLcContext = peakelOrFeature;
        if (iLcContext instanceof Peakel) {
            Peakel peakel = (Peakel)iLcContext;
            f = peakel.calcWeightedAverageTime();
        } else if (iLcContext instanceof Feature) {
            Feature feature = (Feature)iLcContext;
            f = feature.weightedAverageTime();
        } else {
            throw new MatchError((Object)iLcContext);
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public LongMap<ArrayBuffer<Feature>> _groupFtsByIsolationWindowIdx(IsolationWindow[] isolationWindowRanges, Feature[] ms1Fts) {
        void var3_3;
        LongMap ftsByIWIdx = new LongMap();
        IsolationWindow firstIW = isolationWindowRanges[0];
        int rangesCount = isolationWindowRanges.length;
        IntRef currIdx = IntRef.create((int)0);
        DoubleRef currMaxParentMz = DoubleRef.create((double)firstIW.getMaxMz());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ms1Fts)).foreach((Function1 & Serializable & scala.Serializable)ft -> {
            block1: {
                double mz = ft.getMz();
                if (!(mz > currMaxParentMz$1.elem)) break block1;
                if (currIdx$1.elem + 1 < rangesCount) {
                    ++currIdx$1.elem;
                }
                currMaxParentMz$1.elem = isolationWindowRanges[currIdx$1.elem].getMaxMz();
            }
            return ((ArrayBuffer)ftsByIWIdx.getOrElseUpdate((long)currIdx$1.elem, (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer())).$plus$eq(ft);
        });
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$demultiplexMSnData$1(Feature ft) {
        return ft.charge() == 2 || ft.charge() == 3;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$demultiplexMSnData$3(MzDbMSnDemultiplexer $this, IsolationWindow[] isolationWindows$1, FeatureDetectorConfig ftDetectorConfMs2$1, LongMap ms1FtsByIWIdx$1, ArrayBuffer spectra$1, int i) {
        IsolationWindow pair = isolationWindows$1[i];
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(pair.getMinMz(), pair.getMaxMz());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double minParentMz = sp2._1$mcD$sp();
        double maxParentMz = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(minParentMz, maxParentMz);
        Tuple2.mcDD.sp sp4 = sp3;
        double minParentMz2 = sp4._1$mcD$sp();
        double maxParentMz2 = sp4._2$mcD$sp();
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("Unsupervised ms2 feature detection: range(").append(minParentMz2).append(", ").append(maxParentMz2).append(")").toString());
        MzDbFeatureDetector ftDetectorMs2 = new MzDbFeatureDetector($this.mzDbReader, ftDetectorConfMs2$1);
        Iterator lcMSnRsIter = $this.mzDbReader.getLcMsnRunSliceIterator(minParentMz2, maxParentMz2);
        Peakel[] peakels = ftDetectorMs2.detectPeakels(lcMSnRsIter, ftDetectorMs2.detectPeakels$default$2());
        ArrayBuffer ms1FtsSub = (ArrayBuffer)ms1FtsByIWIdx$1.apply((long)i);
        DemultiplexedSpectrum[] newSpectra = $this._groupMSnCorrelatedPeakels((Feature[])ms1FtsSub.toArray(ClassTag$.MODULE$.apply(Feature.class)), peakels);
        return spectra$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newSpectra)));
    }

    public static final /* synthetic */ double $anonfun$_groupMSnCorrelatedPeakels$2(Map peakelTimeByLcEntity$1, Product entity) {
        return BoxesRunTime.unboxToFloat((Object)peakelTimeByLcEntity$1.apply((Object)entity));
    }

    public static final /* synthetic */ double $anonfun$_groupMSnCorrelatedPeakels$5(Tuple2 x$4) {
        return ((Bin)x$4._1()).center();
    }

    public static final /* synthetic */ float $anonfun$_groupMSnCorrelatedPeakels$6(Map peakelTimeByLcEntity$1, Product x$5) {
        return BoxesRunTime.unboxToFloat((Object)peakelTimeByLcEntity$1.apply((Object)x$5));
    }

    public static final /* synthetic */ void $anonfun$_groupMSnCorrelatedPeakels$3(MzDbMSnDemultiplexer $this, Map peakelTimeByLcEntity$1, ArrayBuffer spectra$2, Tuple2[] peakelBinGroup) {
        block4: {
            BoxedUnit boxedUnit;
            Product[] peakelGroup = (Product[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelBinGroup)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Product.class)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelGroup)).isEmpty()) break block4;
            double meanTime = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelBinGroup)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)MzDbMSnDemultiplexer.$anonfun$_groupMSnCorrelatedPeakels$5(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)peakelBinGroup.length;
            float[] times = (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelGroup)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToFloat((float)MzDbMSnDemultiplexer.$anonfun$_groupMSnCorrelatedPeakels$6(peakelTimeByLcEntity$1, x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("min time is {} and max time is {}", new Object[]{new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(times)).min((Ordering)Ordering.Float$.MODULE$), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(times)).max((Ordering)Ordering.Float$.MODULE$)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Tuple2 tuple2 = new Tuple2((Object)new ArrayBuffer(), (Object)new ArrayBuffer());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer ms1FtsInGroup = (ArrayBuffer)tuple2._1();
            ArrayBuffer msnPeakels = (ArrayBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)ms1FtsInGroup, (Object)msnPeakels);
            Tuple2 tuple23 = tuple22;
            ArrayBuffer ms1FtsInGroup2 = (ArrayBuffer)tuple23._1();
            ArrayBuffer msnPeakels2 = (ArrayBuffer)tuple23._2();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelGroup)).map((Function1 & Serializable & scala.Serializable)peakelOrFt -> {
                ArrayBuffer arrayBuffer;
                Product product = peakelOrFt;
                if (product instanceof Feature) {
                    Feature feature = (Feature)product;
                    arrayBuffer = ms1FtsInGroup2.$plus$eq((Object)feature);
                } else if (product instanceof Peakel) {
                    Peakel peakel = (Peakel)product;
                    arrayBuffer = msnPeakels2.$plus$eq((Object)peakel);
                } else {
                    throw new MatchError((Object)product);
                }
                return arrayBuffer;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayBuffer.class)));
            if (msnPeakels2.length() >= $this.minNbPeaksInSpectrum()) {
                ms1FtsInGroup2.foreach((Function1 & Serializable & scala.Serializable)ft -> spectra$2.$plus$eq((Object)new DemultiplexedSpectrum(ft.mz(), ft.charge(), (float)meanTime, (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])msnPeakels2.toArray(ClassTag$.MODULE$.apply(Peakel.class)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getCursorAtApex().toPeak($this.spectrumHeaderById()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.getMz()), (Ordering)Ordering.Double$.MODULE$))));
            }
        }
    }

    public MzDbMSnDemultiplexer(MzDbReader mzDbReader) {
        this.mzDbReader = mzDbReader;
        LazyLogging.$init$((LazyLogging)this);
        this.spectrumHeaderById = package.LongMapBuilderFromFilterMonadic$.MODULE$.toLongMapWith$extension(package$.MODULE$.filterMonadic2longMapBuilder((FilterMonadic)JavaConverters$.MODULE$.mapAsScalaMapConverter(mzDbReader.getMs2SpectrumHeaderById()).asScala()), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Long k = (Long)tuple2._1();
            SpectrumHeader v = (SpectrumHeader)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(k))), (Object)v);
            return tuple22;
        });
        this.minNbPeaksInSpectrum = 3;
    }
}

