/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternEstimator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.DotProductPatternScorer$;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.SpectrumData;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class KLPatternScorer$
implements IIsotopicPatternScorer {
    public static KLPatternScorer$ MODULE$;
    private final int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new KLPatternScorer$();
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypotheses(SpectrumData spectrum, double mz, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypotheses$(this, spectrum, mz, ppmTol);
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern>[] calcIsotopicPatternHypothesesFromCharge(SpectrumData spectrum, double mz, int charge, double ppmTol) {
        return IIsotopicPatternScorer.calcIsotopicPatternHypothesesFromCharge$(this, spectrum, mz, charge, ppmTol);
    }

    @Override
    public int fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE() {
        return this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE;
    }

    @Override
    public final void fr$profi$mzdb$algo$IIsotopicPatternScorer$_setter_$fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE_$eq(int x$1) {
        this.fr$profi$mzdb$algo$IIsotopicPatternScorer$$MAX_CHARGE = x$1;
    }

    private Logger logger$lzycompute() {
        KLPatternScorer$ kLPatternScorer$ = this;
        synchronized (kLPatternScorer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> getIPHypothesis(SpectrumData spectrum, double initialMz, int isotopicShift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = initialMz - (double)isotopicShift * 1.0027 / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator$.MODULE$.getTheoreticalPattern(mz, charge);
        double scale = (double)spectrum.getIntensityList()[spectrum.getNearestPeakIndex(initialMz)] / (double)BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[isotopicShift]._2());
        DoubleRef ipMoz = DoubleRef.create((double)mz);
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pattern.mzAbundancePairs().length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)rank -> {
            ipMoz$4.elem = rank == 0 ? ipMoz$4.elem : ipMoz$4.elem + 1.0027 / (double)charge;
            int nearestPeakIdx = spectrum.getNearestPeakIndex(ipMoz$4.elem);
            observed$3[rank] = 1000000.0 * Math.abs(spectrum.getMzList()[nearestPeakIdx] - ipMoz$4.elem) / ipMoz$4.elem < ppmTol ? (double)spectrum.getIntensityList()[nearestPeakIdx] : 1.0 / (double)BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2()) * scale;
            expected$3[rank] = BoxesRunTime.unboxToFloat((Object)pattern.mzAbundancePairs()[rank]._2());
        });
        score = this.distance(observed, expected);
        score = 1.0 - score;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)pattern);
    }

    /*
     * WARNING - void declaration
     */
    public double distance(double[] observed, double[] expected) {
        void var3_3;
        double product = 0.0;
        double[] exp = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expected)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] obs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(observed)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$5 -> x$5 / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(observed)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        for (int k = 0; k < obs.length && exp[k] > 0.01; ++k) {
            product += exp[k] * package$.MODULE$.log(exp[k] / obs[k]);
        }
        return (double)var3_3;
    }

    @Override
    public Tuple2<Object, TheoreticalIsotopePattern> selectBestPatternHypothese(Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns, double deltaScore) {
        return DotProductPatternScorer$.MODULE$.selectBestPatternHypothese(putativePatterns, deltaScore);
    }

    @Override
    public double selectBestPatternHypothese$default$2() {
        return 0.1;
    }

    private KLPatternScorer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        IIsotopicPatternScorer.$init$(this);
    }
}

