/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.Settings$;
import fr.profi.mzdb.algo.IIsotopicPatternPredictor;
import fr.profi.mzdb.algo.IIsotopicPatternScorer;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelCursor;
import fr.profi.mzdb.model.SpectrumData;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PeakelsPatternPredictor$
implements IIsotopicPatternPredictor {
    public static PeakelsPatternPredictor$ MODULE$;
    private final IIsotopicPatternScorer isotopicPatternScorer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new PeakelsPatternPredictor$();
    }

    @Override
    public boolean isMatchReliable(SpectrumData spectrumData, double ppm, double moz, int charge, double mozTolInDa) {
        return IIsotopicPatternPredictor.isMatchReliable$(this, spectrumData, ppm, moz, charge, mozTolInDa);
    }

    @Override
    public IIsotopicPatternScorer isotopicPatternScorer() {
        return this.isotopicPatternScorer;
    }

    @Override
    public void fr$profi$mzdb$algo$IIsotopicPatternPredictor$_setter_$isotopicPatternScorer_$eq(IIsotopicPatternScorer x$1) {
        this.isotopicPatternScorer = x$1;
    }

    private Logger logger$lzycompute() {
        PeakelsPatternPredictor$ peakelsPatternPredictor$ = this;
        synchronized (peakelsPatternPredictor$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Tuple2<Object, TheoreticalIsotopePattern> getBestExplanation(float mozTolPPM, Seq<Peakel> coelutingPeakels, Peakel peakel) {
        SpectrumData spectrumData = this.buildSpectrumFromPeakels(coelutingPeakels, peakel);
        Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = this.isotopicPatternScorer().calcIsotopicPatternHypotheses(spectrumData, peakel.getApexMz(), mozTolPPM);
        return this.isotopicPatternScorer().selectBestPatternHypothese(putativePatterns, this.isotopicPatternScorer().selectBestPatternHypothese$default$2());
    }

    public ArrayBuffer<Tuple2<Peakel, Object>> assessReliability(float mozTolPPM, Seq<Peakel> coelutingPeakels, Seq<Peakel> matchingPeakels, int charge, double mozTolInDa) {
        ArrayBuffer filteredPeakels = new ArrayBuffer(matchingPeakels.length());
        matchingPeakels.foreach((Function1 & Serializable & scala.Serializable)matchingPeakel -> {
            SpectrumData spectrumData = MODULE$.buildSpectrumFromPeakels(coelutingPeakels, (Peakel)matchingPeakel);
            boolean isReliable = MODULE$.isMatchReliable(spectrumData, mozTolPPM, matchingPeakel.getApexMz(), charge, mozTolInDa);
            return filteredPeakels.$plus$eq((Object)new Tuple2(matchingPeakel, (Object)BoxesRunTime.boxToBoolean((boolean)isReliable)));
        });
        return filteredPeakels;
    }

    public SpectrumData buildSpectrumFromPeakels(Seq<Peakel> coelutingPeakels, Peakel peakel) {
        Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> tuple2 = this.slicePeakels(coelutingPeakels, peakel.getApexSpectrumId(), Settings$.MODULE$.peakelsSlicingSpan());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayBuffer mzList = (ArrayBuffer)tuple2._1();
        ArrayBuffer intensityList = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mzList, (Object)intensityList);
        Tuple2 tuple23 = tuple22;
        ArrayBuffer mzList2 = (ArrayBuffer)tuple23._1();
        ArrayBuffer intensityList2 = (ArrayBuffer)tuple23._2();
        SpectrumData spectrumData = new SpectrumData((double[])mzList2.toArray(ClassTag$.MODULE$.Double()), (float[])intensityList2.toArray(ClassTag$.MODULE$.Float()));
        return spectrumData;
    }

    public Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> slicePeakels(Seq<Peakel> coelutingPeakels, long matchingSpectrumId, int span) {
        int coelutingPeakelsCount = coelutingPeakels.length();
        ArrayBuffer mzList = new ArrayBuffer(coelutingPeakelsCount);
        ArrayBuffer intensityList = new ArrayBuffer(coelutingPeakelsCount);
        ((TraversableLike)coelutingPeakels.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.getApexMz()), (Ordering)Ordering.Double$.MODULE$)).map((Function1 & Serializable & scala.Serializable)peakel -> {
            BoxedUnit boxedUnit;
            boolean foundPeak;
            int index = Arrays.binarySearch(peakel.getSpectrumIds(), matchingSpectrumId);
            boolean bl = foundPeak = index >= 0 && index < peakel.peaksCount();
            if (!foundPeak) {
                foundPeak = (index ^= 0xFFFFFFFF) > 0 && index < peakel.peaksCount();
            }
            FloatRef intensitySum = FloatRef.create((float)0.0f);
            DoubleRef mzSum = DoubleRef.create((double)0.0);
            IntRef count = IntRef.create((int)0);
            if (foundPeak) {
                int minBound = Math.max(0, index - span);
                int maxBound = Math.min(index + span, peakel.getPeaksCount() - 1);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minBound), maxBound).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    intensitySum$1.elem += peakel.intensityValues()[i];
                    mzSum$1.elem += peakel.mzValues()[i];
                    ++count$1.elem;
                });
                mzList.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(mzSum.elem / (double)count.elem)));
                boxedUnit = intensityList.$plus$eq((Object)BoxesRunTime.boxToFloat((float)(intensitySum.elem / (float)count.elem)));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)mzList, (Object)intensityList);
    }

    public int slicePeakels$default$3() {
        return 1;
    }

    public Tuple2<ArrayBuffer<Object>, ArrayBuffer<Object>> slicePeakelsV1(Seq<Peakel> coelutingPeakels, long matchingSpectrumId) {
        int coelutingPeakelsCount = coelutingPeakels.length();
        ArrayBuffer mzList = new ArrayBuffer(coelutingPeakelsCount);
        ArrayBuffer intensityList = new ArrayBuffer(coelutingPeakelsCount);
        ((TraversableLike)coelutingPeakels.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.getApexMz()), (Ordering)Ordering.Double$.MODULE$)).map((Function1 & Serializable & scala.Serializable)peakel -> {
            PeakelsPatternPredictor$.$anonfun$slicePeakelsV1$2(matchingSpectrumId, mzList, intensityList, peakel);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)mzList, (Object)intensityList);
    }

    public static final /* synthetic */ void $anonfun$slicePeakelsV1$2(long matchingSpectrumId$2, ArrayBuffer mzList$2, ArrayBuffer intensityList$2, Peakel peakel) {
        PeakelCursor peakelCursor = peakel.getNewCursor();
        boolean foundPeak = false;
        while (peakelCursor.next() && !foundPeak) {
            if (peakelCursor.getSpectrumId() != matchingSpectrumId$2) continue;
            mzList$2.$plus$eq((Object)BoxesRunTime.boxToDouble((double)peakelCursor.getMz()));
            intensityList$2.$plus$eq((Object)BoxesRunTime.boxToFloat((float)peakelCursor.getIntensity()));
            foundPeak = true;
        }
    }

    private PeakelsPatternPredictor$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        IIsotopicPatternPredictor.$init$(this);
    }
}

