/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.ms.normalization;

import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.util.collection.package;
import fr.profi.util.collection.package$;
import java.io.Serializable;
import java.util.Iterator;
import mr.go.sgfilter.SGFilterMath3;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MsSpectrumNormalizer$ {
    public static MsSpectrumNormalizer$ MODULE$;

    static {
        new MsSpectrumNormalizer$();
    }

    public LongMap<Object> computeNfBySpectrumId(MzDbReader mzDbReader) {
        int cyclesCount = mzDbReader.getCyclesCount();
        float[] medians = new float[cyclesCount];
        long[] spectrumIds = new long[cyclesCount];
        Iterator msSpectrumIter = mzDbReader.getSpectrumIterator(1);
        while (msSpectrumIter.hasNext()) {
            Spectrum spectrum = (Spectrum)msSpectrumIter.next();
            float[] intensities = (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrum.toPeaks())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToFloat((float)x$1.getIntensity()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            double medInt = this.median((Seq<Object>)Predef$.MODULE$.wrapFloatArray(intensities));
            SpectrumHeader sh = spectrum.getHeader();
            int idx = sh.getCycle() - 1;
            spectrumIds[idx] = sh.getId();
            medians[idx] = (float)medInt;
        }
        float[] nfs = this.computeNFs(medians);
        return package.LongMapBuilderFromTraversableOnce$.MODULE$.toLongMapWith$extension(package$.MODULE$.array2longMapBuilder(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(spectrumIds)).zip((GenIterable)Predef$.MODULE$.wrapFloatArray(nfs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            float nf = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), (Object)BoxesRunTime.boxToFloat((float)nf));
            return tuple22;
        });
    }

    public float[] computeNFs(float[] sic) {
        int nbSpectra = sic.length;
        float[] smoothedValues = this.smoothValues(sic, 1);
        float[] nfs = new float[nbSpectra];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nbSpectra).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            float intensity = sic[idx];
            float corIntensity = smoothedValues[idx];
            nfs$1[idx] = corIntensity / intensity;
        });
        return nfs;
    }

    public double median(Seq<Object> s) {
        Tuple2 tuple2 = ((TraversableLike)s.sortWith((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)MsSpectrumNormalizer$.$anonfun$median$1(BoxesRunTime.unboxToFloat((Object)x$2), BoxesRunTime.unboxToFloat((Object)x$3))))).splitAt(s.size() / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq lower = (Seq)tuple2._1();
        Seq upper = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lower, (Object)upper);
        Tuple2 tuple23 = tuple22;
        Seq lower2 = (Seq)tuple23._1();
        Seq upper2 = (Seq)tuple23._2();
        return s.size() % 2 == 0 ? (double)(BoxesRunTime.unboxToFloat((Object)lower2.last()) + BoxesRunTime.unboxToFloat((Object)upper2.head())) / 2.0 : (double)BoxesRunTime.unboxToFloat((Object)upper2.head());
    }

    public float[] smoothValues(float[] values, int times) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int nl = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int nr = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int order = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)nl), (Object)BoxesRunTime.boxToInteger((int)nr), (Object)BoxesRunTime.boxToInteger((int)order));
        Tuple3 tuple33 = tuple32;
        int nl2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int nr2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        int order2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        float[] leftPad = (float[])Array$.MODULE$.fill(nl2, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(values)).head()), ClassTag$.MODULE$.Float());
        float[] rightPad = (float[])Array$.MODULE$.fill(nl2, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(values)).last()), ClassTag$.MODULE$.Float());
        double[] coeffs = SGFilterMath3.computeSGCoefficients(nl2, nr2, order2);
        SGFilterMath3 sgFilter = new SGFilterMath3(nl2, nr2);
        ObjectRef smoothedValues = ObjectRef.create((Object)values);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), times).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            smoothedValues$2.elem = sgFilter.smooth(values, leftPad, rightPad, coeffs);
        });
        return (float[])smoothedValues.elem;
    }

    public static final /* synthetic */ boolean $anonfun$median$1(float x$2, float x$3) {
        return x$2 < x$3;
    }

    private MsSpectrumNormalizer$() {
        MODULE$ = this;
    }
}

