/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.exporter;

import fr.profi.mzdb.model.Feature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Locale;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class MzTSVFeatureWriter$ {
    public static MzTSVFeatureWriter$ MODULE$;
    private final Locale locale;

    static {
        new MzTSVFeatureWriter$();
    }

    public Locale locale() {
        return this.locale;
    }

    public void writeFeatures(Seq<Feature> features, File outFile) {
        PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
        this.writeFeatures(features, out);
        out.close();
    }

    public void writeFeatures(Seq<Feature> features, PrintWriter out) {
        List colNames = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "apex_spectrum", "first_spectrum", "last_spectrum", "elution_time", "charge", "moz", "intensity_sum", "area", "quality_score", "peakels_ratios", "peakels_count", "ms1_count", "ms2_count", "apex_ip", "isotopic_patterns", "overlap_factor", "overlap_correlation", "overlapping_feature"}));
        String header = colNames.mkString("\t");
        out.println(header);
        out.flush();
        features.foreach((Function1 & Serializable & scala.Serializable)ft -> {
            MzTSVFeatureWriter$.$anonfun$writeFeatures$1(out, ft);
            return BoxedUnit.UNIT;
        });
        out.flush();
        out.close();
    }

    public static final /* synthetic */ String $anonfun$writeFeatures$7(float x$4) {
        return new StringOps(Predef$.MODULE$.augmentString("%.2f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)x$4)}));
    }

    public static final /* synthetic */ void $anonfun$writeFeatures$1(PrintWriter out$1, Feature ft) {
        Option<float[]> peakelsRatiosOpt;
        BoxedUnit boxedUnit;
        String overlapCorrelationStr = "";
        String bestOlpFtJSONString = "";
        Feature bestOlpFt = (Feature)Option$.MODULE$.apply((Object)ft.overlapProperties()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getBestOverlappingFeature().feature()).orNull(Predef$.MODULE$.$conforms());
        if (bestOlpFt != null) {
            overlapCorrelationStr = new StringOps(Predef$.MODULE$.augmentString("%.8f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)bestOlpFt.overlapProperties().getOverlapPMCC())}));
            HashMap olpFtJSONObject = new HashMap();
            olpFtJSONObject.put((Object)"id", (Object)BoxesRunTime.boxToInteger((int)bestOlpFt.id()));
            olpFtJSONObject.put((Object)"apex_spectrum", (Object)BoxesRunTime.boxToLong((long)bestOlpFt.getApexSpectrumId()));
            olpFtJSONObject.put((Object)"first_spectrum", new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(bestOlpFt.getSpectrumIds())).head());
            olpFtJSONObject.put((Object)"last_spectrum", new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(bestOlpFt.getSpectrumIds())).last());
            olpFtJSONObject.put((Object)"elution_time", (Object)BoxesRunTime.boxToFloat((float)bestOlpFt.getElutionTime()));
            olpFtJSONObject.put((Object)"charge", (Object)BoxesRunTime.boxToInteger((int)bestOlpFt.charge()));
            olpFtJSONObject.put((Object)"moz", (Object)new StringOps(Predef$.MODULE$.augmentString("%.8f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bestOlpFt.mz())})));
            olpFtJSONObject.put((Object)"intensity_sum", (Object)new StringOps(Predef$.MODULE$.augmentString("%.1f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bestOlpFt.getIntensitySum())})));
            olpFtJSONObject.put((Object)"area", (Object)new StringOps(Predef$.MODULE$.augmentString("%.1f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)bestOlpFt.area())})));
            olpFtJSONObject.put((Object)"quality_score", (Object)new StringOps(Predef$.MODULE$.augmentString("%.8f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)bestOlpFt.qualityProperties()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToFloat((float)x$2.getMeanPeakelCorrelation())).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f)})));
            olpFtJSONObject.put((Object)"ms1_count", (Object)BoxesRunTime.boxToInteger((int)bestOlpFt.getMs1Count()));
            boxedUnit = olpFtJSONObject.put((Object)"ms2_count", (Object)BoxesRunTime.boxToInteger((int)bestOlpFt.getMs2Count()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        float peakelCorrel = BoxesRunTime.unboxToFloat((Object)Option$.MODULE$.apply((Object)ft.qualityProperties()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToFloat((float)x$3.getMeanPeakelCorrelation())).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f));
        String qualityScoreStr = "";
        if (!Predef$.MODULE$.float2Float(peakelCorrel).isNaN()) {
            qualityScoreStr = new StringOps(Predef$.MODULE$.augmentString("%.8f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)peakelCorrel)}));
        }
        String peakelsRatiosStr = "";
        if (ft.getPeakelsCount() > 1 && (peakelsRatiosOpt = ft.calcPeakelsAreaRatios()).isDefined()) {
            String[] formattedPeakelsRatios = (String[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])peakelsRatiosOpt.get())).map((Function1 & Serializable & scala.Serializable)x$4 -> MzTSVFeatureWriter$.$anonfun$writeFeatures$7(BoxesRunTime.unboxToFloat((Object)x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        List ftValues = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ft.id()), BoxesRunTime.boxToLong((long)ft.getApexSpectrumId()), new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ft.getSpectrumIds())).head(), new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ft.getSpectrumIds())).last(), BoxesRunTime.boxToFloat((float)ft.getElutionTime()), BoxesRunTime.boxToInteger((int)ft.charge()), new StringOps(Predef$.MODULE$.augmentString("%.8f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)ft.mz())})), new StringOps(Predef$.MODULE$.augmentString("%.1f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)ft.getIntensitySum())})), new StringOps(Predef$.MODULE$.augmentString("%.1f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)ft.area())})), qualityScoreStr, peakelsRatiosStr, BoxesRunTime.boxToInteger((int)ft.getPeakelsCount()), BoxesRunTime.boxToInteger((int)ft.getMs1Count()), BoxesRunTime.boxToInteger((int)ft.getMs2Count()), "", new StringOps(Predef$.MODULE$.augmentString("%.2f")).formatLocal(MODULE$.locale(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)ft.overlapProperties()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToFloat((float)x$5.getOverlapRelativeFactor())).getOrElse((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f)})), overlapCorrelationStr, bestOlpFtJSONString}));
        String ftString = ftValues.mkString("\t");
        out$1.println(ftString);
        out$1.flush();
    }

    private MzTSVFeatureWriter$() {
        MODULE$ = this;
        this.locale = Locale.ENGLISH;
    }
}

