/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.PeakList$;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t]u!B!C\u0011\u0003Ye!B'C\u0011\u0003q\u0005\"\u0002-\u0002\t\u0003I\u0006\"\u0002.\u0002\t\u0003Y\u0006\"B4\u0002\t\u0003A\u0007\"\u00026\u0002\t\u0003Y\u0007\"B=\u0002\t#Q\b\"CA\u0013\u0003\u0005\u0005I\u0011QA\u0014\u0011%\u0011I(AA\u0001\n\u0003\u0013Y\bC\u0005\u0003\u000e\u0006\t\t\u0011\"\u0003\u0003\u0010\u001a)QJ\u0011!\u0002,!Q\u00111\u0007\u0006\u0003\u0016\u0004%\t!!\u000e\t\u0015\u0005u\"B!E!\u0002\u0013\t9\u0004C\u0004\u0002N)!\t!a\u0014\t\u0015\u0005E#B!f\u0001\n\u0003\t\u0019\u0006C\u0005\u0002V)\u0011\t\u0012)A\u0005]\"9\u0011\u0011\f\u0006\u0005\u0002\u0005m\u0003BCA/\u0015\tU\r\u0011\"\u0001\u0002`!Q\u0011q\r\u0006\u0003\u0012\u0003\u0006I!!\u0019\t\u000f\u0005-$\u0002\"\u0001\u0002n!Q\u0011q\u000e\u0006\u0003\u0016\u0004%\t!a\u0018\t\u0015\u0005E$B!E!\u0002\u0013\t\t\u0007C\u0004\u0002v)!\t!!\u001c\t\raSA\u0011CA<\u0011%\t\tI\u0003b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002\u0004*\u0001\u000b\u0011BA1\u0011\u001d\t)I\u0003C\t\u0003\u000fCa\u0001\u0017\u0006\u0005\u0002\u0005M\u0005\"CAL\u0015\t\u0007I\u0011BA0\u0011!\tIJ\u0003Q\u0001\n\u0005\u0005\u0004\"CAN\u0015\t\u0007I\u0011BAO\u0011!\t)K\u0003Q\u0001\n\u0005}\u0005\"CAT\u0015\t\u0007I\u0011BAU\u0011!\t\tL\u0003Q\u0001\n\u0005-\u0006\"CAZ\u0015\t\u0007I\u0011BA[\u0011!\tIL\u0003Q\u0001\n\u0005]\u0006\u0002\u0003;\u000b\u0005\u0004%I!a/\t\u000f\u0005u&\u0002)A\u0005k\"I\u0011q\u0018\u0006C\u0002\u0013%\u00111\u0018\u0005\b\u0003\u0003T\u0001\u0015!\u0003v\u0011%\t\u0019M\u0003b\u0001\n\u0013\tY\fC\u0004\u0002F*\u0001\u000b\u0011B;\t\u000f\u0005\u001d'\u0002\"\u0001\u0002J\"9\u00111\u001a\u0006\u0005\u0002\u00055\u0007bBAh\u0015\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003'TA\u0011AAk\u0011\u001d\t9N\u0003C\u0001\u0003+Dq!!7\u000b\t\u0003\t)\u000eC\u0004\u0002\\*!\t!!8\t\u000f\u0005\r(\u0002\"\u0001\u0002f\"9\u0011\u0011\u001e\u0006\u0005\u0002\u0005-\bbBA{\u0015\u0011\u0005\u0011q\u001f\u0005\n\u0003{T\u0011\u0011!C\u0001\u0003\u007fD\u0011B!\u0003\u000b#\u0003%\tAa\u0003\t\u0013\t\u0005\"\"%A\u0005\u0002\t\r\u0002\"\u0003B\u0014\u0015E\u0005I\u0011\u0001B\u0015\u0011%\u0011iCCI\u0001\n\u0003\u0011I\u0003C\u0005\u00030)\t\t\u0011\"\u0011\u00032!I!\u0011\b\u0006\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u0005wQ\u0011\u0011!C\u0001\u0005{A\u0011B!\u0013\u000b\u0003\u0003%\tEa\u0013\t\u0013\te#\"!A\u0005\u0002\tm\u0003\"\u0003B3\u0015\u0005\u0005I\u0011IA.\u0011%\u00119GCA\u0001\n\u0003\u0012I\u0007C\u0005\u0003l)\t\t\u0011\"\u0011\u0003n\u0005A\u0001+Z1l\u0019&\u001cHO\u0003\u0002D\t\u0006)Qn\u001c3fY*\u0011QIR\u0001\u0005[j$'M\u0003\u0002H\u0011\u0006)\u0001O]8gS*\t\u0011*\u0001\u0002ge\u000e\u0001\u0001C\u0001'\u0002\u001b\u0005\u0011%\u0001\u0003)fC.d\u0015n\u001d;\u0014\u0007\u0005yU\u000b\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004B]f\u0014VM\u001a\t\u0003!ZK!aV)\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Y\u0015\u0001G:peR\u0004V-Y6t\u0005f$Um]2J]R,gn]5usR\u0011Al\u0018\t\u0003!vK!AX)\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\u000e\u0001\r!Y\u0001\u0006a\u0016\f7n\u001d\t\u0004!\n$\u0017BA2R\u0005\u0015\t%O]1z!\taU-\u0003\u0002g\u0005\n!\u0001+Z1l\u0003A\u0019xN\u001d;QK\u0006\\7OQ=Bg\u000el%\u0010\u0006\u0002]S\")\u0001\r\u0002a\u0001C\u0006q2o\u001c:u!\u0016\f7n]\"p_J$7OQ=EKN\u001c\u0017J\u001c;f]NLG/\u001f\u000b\u0004YF\u001c\bc\u0001)c[B\u0019\u0001K\u00198\u0011\u0005A{\u0017B\u00019R\u0005\rIe\u000e\u001e\u0005\u0006e\u0016\u0001\r\u0001\\\u0001\fa\u0016\f7n]\"p_J$7\u000fC\u0003u\u000b\u0001\u0007Q/A\u0007j]R,gn]5us2K7\u000f\u001e\t\u0004!\n4\bC\u0001)x\u0013\tA\u0018KA\u0003GY>\fG/A\bt_J$\b+Z1lg\u000e{wN\u001d3t)\ra7\u0010 \u0005\u0006e\u001a\u0001\r\u0001\u001c\u0005\u0006{\u001a\u0001\rA`\u0001\u000ea\u0016\f7n](sI\u0016\u0014\u0018N\\4\u0011\u000b}\fy!!\u0006\u000f\t\u0005\u0005\u00111\u0002\b\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001&\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0016bAA\u0007#\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\t\u0003'\u0011\u0001b\u0014:eKJLgn\u001a\u0006\u0004\u0003\u001b\t\u0006\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0005Y\u0006twM\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u0007\u0003\u000f%sG/Z4fe\u0006)\u0011\r\u001d9msRQ\u0011\u0011\u0006B9\u0005g\u0012)Ha\u001e\u0011\u00051S1#\u0002\u0006P\u0003[)\u0006c\u0001)\u00020%\u0019\u0011\u0011G)\u0003\u000fA\u0013x\u000eZ;di\u0006A1\u000f]3diJ,X.\u0006\u0002\u00028A\u0019A*!\u000f\n\u0007\u0005m\"I\u0001\u0005Ta\u0016\u001cGO];n\u0003%\u0019\b/Z2ueVl\u0007\u0005K\u0002\r\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\n\u0016!\u00022fC:\u001c\u0018\u0002BA&\u0003\u000b\u0012ABQ3b]B\u0013x\u000e]3sif\f1bZ3u'B,7\r\u001e:v[R\u0011\u0011qG\u0001\u000ba\u0016\f7n]\"pk:$X#\u00018\u0002\u0017A,\u0017m[:D_VtG\u000f\t\u0015\u0004\u001f\u0005\u0005\u0013!D4fiB+\u0017m[:D_VtG\u000fF\u0001o\u0003\u0015i\u0017N\\'{+\t\t\t\u0007E\u0002Q\u0003GJ1!!\u001aR\u0005\u0019!u.\u001e2mK\u00061Q.\u001b8Nu\u0002B3AEA!\u0003!9W\r^'j]6SHCAA1\u0003\u0015i\u0017\r_'{\u0003\u0019i\u0017\r_'{A!\u001aQ#!\u0011\u0002\u0011\u001d,G/T1y\u001bj$\"\"!\u000b\u0002z\u0005m\u0014QPA@\u0011\u001d\t\u0019d\u0006a\u0001\u0003oAa!!\u0015\u0018\u0001\u0004q\u0007bBA//\u0001\u0007\u0011\u0011\r\u0005\b\u0003_:\u0002\u0019AA1\u0003Ii%lX%O\t\u0016Cv\f\u0015*F\u0007&\u001b\u0016j\u0014(\u0002'5Sv,\u0013(E\u000bb{\u0006KU#D\u0013NKuJ\u0014\u0011\u0002\u0017\r\fGnY'{\u0013:$W\r\u001f\u000b\u0005\u0003\u0013\u000by\tE\u0002Q\u0003\u0017K1!!$R\u0005\u0011auN\\4\t\u000f\u0005E%\u00041\u0001\u0002b\u0005\u0011QN\u001f\u000b\u0005\u0003S\t)\nC\u0004\u00024m\u0001\r!a\u000e\u0002\u00115Tx+\u001b8e_^\f\u0011\"\u001c>XS:$wn\u001e\u0011\u0002\u001dM\u0004Xm\u0019;sk6DU-\u00193feV\u0011\u0011q\u0014\t\u0004\u0019\u0006\u0005\u0016bAAR\u0005\nq1\u000b]3diJ,X\u000eS3bI\u0016\u0014\u0018aD:qK\u000e$(/^7IK\u0006$WM\u001d\u0011\u0002\u0019M\u0004Xm\u0019;sk6$\u0015\r^1\u0016\u0005\u0005-\u0006c\u0001'\u0002.&\u0019\u0011q\u0016\"\u0003\u0019M\u0003Xm\u0019;sk6$\u0015\r^1\u0002\u001bM\u0004Xm\u0019;sk6$\u0015\r^1!\u0003\u0019i'\u0010T5tiV\u0011\u0011q\u0017\t\u0005!\n\f\t'A\u0004nu2K7\u000f\u001e\u0011\u0016\u0003U\fa\"\u001b8uK:\u001c\u0018\u000e^=MSN$\b%\u0001\u0007mK\u001a$\bj\u001e5n\u0019&\u001cH/A\u0007mK\u001a$\bj\u001e5n\u0019&\u001cH\u000fI\u0001\u000ee&<\u0007\u000e\u001e%xQ6d\u0015n\u001d;\u0002\u001dILw\r\u001b;Io\"lG*[:uA\u0005\tr-\u001a;Ta\u0016\u001cGO];n\u0011\u0016\fG-\u001a:\u0015\u0005\u0005}\u0015aD4fiN\u0003Xm\u0019;sk6$\u0015\r^1\u0015\u0005\u0005-\u0016!C4fi6SH*[:u)\t\t9,\u0001\thKRLe\u000e^3og&$\u0018\u0010T5tiR\tQ/A\bhKRdUM\u001a;Io\"lG*[:u\u0003A9W\r\u001e*jO\"$\bj\u001e5n\u0019&\u001cH/A\u0005ck&dG\rU3bWR\u0019A-a8\t\r\u0005\u0005\b\u00071\u0001o\u0003\u001d\u0001X-Y6JIb\f\u0011bZ3u!\u0016\f7.\u0011;\u0015\u0007\u0011\f9\u000f\u0003\u0004\u0002bF\u0002\rA\\\u0001\u000fO\u0016$h*Z1sKN$\b+Z1l)\u0015!\u0017Q^Ay\u0011\u001d\tyO\ra\u0001\u0003C\n1\"\u001c>U_\u0016CHO]1di\"9\u00111\u001f\u001aA\u0002\u0005\u0005\u0014aB7{)>dG)Y\u0001\u0012O\u0016$h*Z1sKN$\b+Z1l\u0013\u0012DH#\u00028\u0002z\u0006m\bbBAxg\u0001\u0007\u0011\u0011\r\u0005\b\u0003g\u001c\u0004\u0019AA1\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005%\"\u0011\u0001B\u0002\u0005\u000b\u00119\u0001C\u0005\u00024Q\u0002\n\u00111\u0001\u00028!A\u0011\u0011\u000b\u001b\u0011\u0002\u0003\u0007a\u000eC\u0005\u0002^Q\u0002\n\u00111\u0001\u0002b!I\u0011q\u000e\u001b\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iA\u000b\u0003\u00028\t=1F\u0001B\t!\u0011\u0011\u0019B!\b\u000e\u0005\tU!\u0002\u0002B\f\u00053\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm\u0011+\u0001\u0006b]:|G/\u0019;j_:LAAa\b\u0003\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0005\u0016\u0004]\n=\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005WQC!!\u0019\u0003\u0010\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00034A!\u0011q\u0003B\u001b\u0013\u0011\u00119$!\u0007\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0010\u0003FA\u0019\u0001K!\u0011\n\u0007\t\r\u0013KA\u0002B]fD\u0001Ba\u0012<\u0003\u0003\u0005\rA\\\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t5\u0003C\u0002B(\u0005+\u0012y$\u0004\u0002\u0003R)\u0019!1K)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003X\tE#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0018\u0003dA\u0019\u0001Ka\u0018\n\u0007\t\u0005\u0014KA\u0004C_>dW-\u00198\t\u0013\t\u001dS(!AA\u0002\t}\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\r\u0002\r\u0015\fX/\u00197t)\u0011\u0011iFa\u001c\t\u0013\t\u001d\u0003)!AA\u0002\t}\u0002bBA\u001a\u000f\u0001\u0007\u0011q\u0007\u0005\u0007\u0003#:\u0001\u0019\u00018\t\u000f\u0005us\u00011\u0001\u0002b!9\u0011qN\u0004A\u0002\u0005\u0005\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005{\u0012I\tE\u0003Q\u0005\u007f\u0012\u0019)C\u0002\u0003\u0002F\u0013aa\u00149uS>t\u0007C\u0003)\u0003\u0006\u0006]b.!\u0019\u0002b%\u0019!qQ)\u0003\rQ+\b\u000f\\35\u0011%\u0011Y\tCA\u0001\u0002\u0004\tI#A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0013\t\u0005\u0003/\u0011\u0019*\u0003\u0003\u0003\u0016\u0006e!AB(cU\u0016\u001cG\u000f")
public class PeakList
implements Product,
Serializable {
    private final Spectrum spectrum;
    private final int peaksCount;
    private final double minMz;
    private final double maxMz;
    private final double MZ_INDEX_PRECISION;
    private final double mzWindow;
    private final SpectrumHeader spectrumHeader;
    private final SpectrumData spectrumData;
    private final double[] mzList;
    private final float[] intensityList;
    private final float[] leftHwhmList;
    private final float[] rightHwhmList;

    public static Option<Tuple4<Spectrum, Object, Object, Object>> unapply(PeakList peakList) {
        return PeakList$.MODULE$.unapply(peakList);
    }

    public static PeakList apply(Spectrum spectrum, int n, double d, double d2) {
        return PeakList$.MODULE$.apply(spectrum, n, d, d2);
    }

    public static int[][] sortPeaksCoordsByDescIntensity(int[][] nArray, float[] fArray) {
        return PeakList$.MODULE$.sortPeaksCoordsByDescIntensity(nArray, fArray);
    }

    public static void sortPeaksByAscMz(Peak[] peakArray) {
        PeakList$.MODULE$.sortPeaksByAscMz(peakArray);
    }

    public static void sortPeaksByDescIntensity(Peak[] peakArray) {
        PeakList$.MODULE$.sortPeaksByDescIntensity(peakArray);
    }

    public Spectrum spectrum() {
        return this.spectrum;
    }

    public int peaksCount() {
        return this.peaksCount;
    }

    public double minMz() {
        return this.minMz;
    }

    public double maxMz() {
        return this.maxMz;
    }

    private double MZ_INDEX_PRECISION() {
        return this.MZ_INDEX_PRECISION;
    }

    public long calcMzIndex(double mz) {
        return (long)(mz / this.MZ_INDEX_PRECISION());
    }

    private double mzWindow() {
        return this.mzWindow;
    }

    private SpectrumHeader spectrumHeader() {
        return this.spectrumHeader;
    }

    private SpectrumData spectrumData() {
        return this.spectrumData;
    }

    private double[] mzList() {
        return this.mzList;
    }

    private float[] intensityList() {
        return this.intensityList;
    }

    private float[] leftHwhmList() {
        return this.leftHwhmList;
    }

    private float[] rightHwhmList() {
        return this.rightHwhmList;
    }

    public SpectrumHeader getSpectrumHeader() {
        return this.spectrumHeader();
    }

    public SpectrumData getSpectrumData() {
        return this.spectrumData();
    }

    public double[] getMzList() {
        return this.mzList();
    }

    public float[] getIntensityList() {
        return this.intensityList();
    }

    public float[] getLeftHwhmList() {
        return this.leftHwhmList();
    }

    public float[] getRightHwhmList() {
        return this.rightHwhmList();
    }

    public Peak buildPeak(int peakIdx) {
        if (peakIdx == -1) {
            return null;
        }
        return new Peak(this.mzList()[peakIdx], this.intensityList()[peakIdx], this.leftHwhmList() == null ? 0.0f : this.leftHwhmList()[peakIdx], this.rightHwhmList() == null ? 0.0f : this.rightHwhmList()[peakIdx], (ILcContext)this.spectrumHeader());
    }

    public Peak getPeakAt(int peakIdx) {
        return this.buildPeak(peakIdx);
    }

    public Peak getNearestPeak(double mzToExtract, double mzTolDa) {
        int nearestPeakIdx = this.getNearestPeakIdx(mzToExtract, mzTolDa);
        if (nearestPeakIdx == -1) {
            return null;
        }
        return this.buildPeak(nearestPeakIdx);
    }

    public int getNearestPeakIdx(double mzToExtract, double mzTolDa) {
        if (this.peaksCount() == 0) {
            return -1;
        }
        double searchedMinMz = mzToExtract - mzTolDa;
        double searchedMaxMz = mzToExtract + mzTolDa;
        if (searchedMinMz > this.maxMz() || searchedMaxMz < this.minMz()) {
            return -1;
        }
        int nPeaks = this.peaksCount();
        int expectedNearestIdx = mzToExtract < this.minMz() ? 0 : (mzToExtract > this.maxMz() ? nPeaks - 1 : (int)((double)(nPeaks - 1) * (mzToExtract - this.minMz()) / this.mzWindow()));
        Predef$.MODULE$.assert(expectedNearestIdx >= 0 && expectedNearestIdx < nPeaks, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(49).append("invalid expectedNearestIdx=").append(expectedNearestIdx).append(" while peaks count is ").append(nPeaks).toString());
        double mzAtExpectedNearestIdx = this.mzList()[expectedNearestIdx];
        int idxOffset = mzAtExpectedNearestIdx < mzToExtract ? 1 : -1;
        double lowestDeltaMz = mzTolDa;
        double prevDeltaMz = this.mzWindow();
        int nearestMzIdx = -1;
        boolean outOfRange = false;
        for (int mzIdx = expectedNearestIdx; mzIdx >= 0 && mzIdx < nPeaks && !outOfRange; mzIdx += idxOffset) {
            double absDeltaMz;
            double mz = this.mzList()[mzIdx];
            double deltaMz = mz - mzToExtract;
            double d = absDeltaMz = deltaMz <= 0.0 ? 0.0 - deltaMz : deltaMz;
            if (absDeltaMz < lowestDeltaMz || absDeltaMz == lowestDeltaMz && (nearestMzIdx == -1 || this.intensityList()[mzIdx] > this.intensityList()[nearestMzIdx])) {
                lowestDeltaMz = absDeltaMz;
                nearestMzIdx = mzIdx;
            } else if (absDeltaMz > prevDeltaMz) {
                outOfRange = true;
            }
            prevDeltaMz = absDeltaMz;
        }
        return nearestMzIdx;
    }

    public PeakList copy(Spectrum spectrum, int peaksCount, double minMz, double maxMz) {
        return new PeakList(spectrum, peaksCount, minMz, maxMz);
    }

    public Spectrum copy$default$1() {
        return this.spectrum();
    }

    public int copy$default$2() {
        return this.peaksCount();
    }

    public double copy$default$3() {
        return this.minMz();
    }

    public double copy$default$4() {
        return this.maxMz();
    }

    public double getMaxMz() {
        return this.maxMz();
    }

    public double getMinMz() {
        return this.minMz();
    }

    public int getPeaksCount() {
        return this.peaksCount();
    }

    public Spectrum getSpectrum() {
        return this.spectrum();
    }

    public String productPrefix() {
        return "PeakList";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.spectrum();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.peaksCount());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this.minMz());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToDouble((double)this.maxMz());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PeakList;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.spectrum()));
        n = Statics.mix((int)n, (int)this.peaksCount());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minMz()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxMz()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PeakList)) return false;
        boolean bl = true;
        if (!bl) return false;
        PeakList peakList = (PeakList)x$1;
        Spectrum spectrum = this.spectrum();
        Spectrum spectrum2 = peakList.spectrum();
        if (spectrum == null) {
            if (spectrum2 != null) {
                return false;
            }
        } else if (!spectrum.equals(spectrum2)) return false;
        if (this.peaksCount() != peakList.peaksCount()) return false;
        if (this.minMz() != peakList.minMz()) return false;
        if (this.maxMz() != peakList.maxMz()) return false;
        if (!peakList.canEqual(this)) return false;
        return true;
    }

    public PeakList(Spectrum spectrum, int peaksCount, double minMz, double maxMz) {
        this.spectrum = spectrum;
        this.peaksCount = peaksCount;
        this.minMz = minMz;
        this.maxMz = maxMz;
        Product.$init$((Product)this);
        this.MZ_INDEX_PRECISION = 0.1;
        this.mzWindow = maxMz - minMz;
        this.spectrumHeader = spectrum.getHeader();
        this.spectrumData = spectrum.getData();
        this.mzList = this.spectrumData().getMzList();
        this.intensityList = this.spectrumData().getIntensityList();
        this.leftHwhmList = this.spectrumData().getLeftHwhmList();
        this.rightHwhmList = this.spectrumData().getRightHwhmList();
    }

    public PeakList(Spectrum spectrum) {
        this(spectrum, spectrum.getData().getPeaksCount(), spectrum.getData().getMinMz(), spectrum.getData().getMaxMz());
    }
}

